/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class AlphaNodeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AlphaNodeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testAlpha() {
        String str = "import " + Person.class.getCanonicalName() + "\nrule R1 when\n  $p : Person(name == \"Mario\")\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testSharedAlpha() {
        String str = "import " + Person.class.getCanonicalName() + "\nrule R1 when\n  $p : Person(name == \"Mario\")\nthen\nend\nrule R2 when\n  $p : Person(name == \"Mario\")\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario"));
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testBeta() {
        String str = "import " + Person.class.getCanonicalName() + "\nrule R1 when\n  $p : Person(name == \"Mario\")\n  $s : String(this == $p.name)\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario"));
        ksession.insert((Object)"Mario");
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testSharedAlphaWithBeta() {
        String str = "import " + Person.class.getCanonicalName() + "\nrule R1 when\n  $p : Person(name == \"Mario\")\nthen\nend\nrule R2 when\n  $p : Person(name == \"Mario\")\n  $s : String(this == $p.name)\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario"));
        ksession.insert((Object)"Mario");
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testAlphaModify() {
        String str = "import " + Person.class.getCanonicalName() + "\nrule R1 when\n  $p : Person(name == \"Mario\")\nthen\n  modify($p) { setName(\"Mark\")}end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testAlphaDelete() {
        String str = "import " + Person.class.getCanonicalName() + "\nrule R1 when\n  $p : Person()\nthen\n  delete($p);end\nrule R2 when\n  $p : Person()\nthen\n  delete($p);end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testAlphaModifyDelete() {
        String str = "import " + Person.class.getCanonicalName() + "\nrule R1 when\n  $p : Person(name == \"Mario\")\nthen\n  modify($p) { setName(\"Mark\")}end\nrule R2 when\n  $p : Person(name == \"Mark\")\nthen\n  delete($p);end\nrule R3 when\n  not( Person() )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario"));
        Assert.assertEquals((long)3L, (long)ksession.fireAllRules());
    }

    @Test
    public void testBetaModifyWithAlpha() {
        String str = "import " + Person.class.getCanonicalName() + "\nrule R1 when\n  $p : Person(name == \"Mario\")\n  $s : String(this == $p.name)\nthen\n  modify($p) { setName(\"Mark\") }end\nrule R2 when\n  $p : Person(name == \"Mark\")\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario"));
        ksession.insert((Object)"Mario");
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testAlphaModifyWithBeta() {
        String str = "import " + Person.class.getCanonicalName() + "\nrule R1 when\n  $p : Person(name == \"Mario\")\nthen\n  modify($p) { setName(\"Mark\") }end\nrule R2 when\n  $p : Person(name == \"Mark\")\n  $s : String(this == $p.name)\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario"));
        ksession.insert((Object)"Mark");
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void test3Alpha() {
        String str = "import " + Person.class.getCanonicalName() + "\nrule R1 when\n  $p : Person(name == \"Mario\")\nthen\n  modify($p) { setAge(2) }  modify($p) { setAge(2) }end\nrule R3 when\n  $p : Person(age > 1)\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario", 0));
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }
}

