/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public abstract class AbstractBackwardChainingTest {
    protected final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AbstractBackwardChainingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Test(timeout=10000L)
    public void testQueryPositional() {
        String drl = this.getQueryHeader();
        drl = drl + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($name1 : $name, $likes1 : $likes, $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        drl = drl + "rule x2\nwhen\n    String( this == \"go2\" )\n    ?peeps($name1, \"stilton\", $age1; )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        drl = drl + "rule x3\nwhen\n    String( this == \"go3\" )\n    $name1 : String() from \"darth\";\n     ?peeps($name1, \"stilton\", $age1; )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        drl = drl + "rule x4\nwhen\n    String( this == \"go4\" )\n    $name1 : String() from \"darth\"\n     $age1 : Integer() from 200;\n     ?peeps($name1, \"stilton\", $age1; )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        this.testQuery(drl);
    }

    @Test(timeout=10000L)
    public void testQueryNamed() {
        String drl = this.getQueryHeader();
        drl = drl + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($name1 : $name, $likes1 : $likes, $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        drl = drl + "rule x2\nwhen\n    String( this == \"go2\" )\n    ?peeps($name1 : $name, $likes : \"stilton\", $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        drl = drl + "rule x3\nwhen\n    String( this == \"go3\" )\n    $name1 : String() from \"darth\";\n     ?peeps($name1 : $name, $likes : \"stilton\", $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        drl = drl + "rule x4\nwhen\n    String( this == \"go4\" )\n    $name1 : String() from \"darth\";\n     $age1 : Integer() from 200;\n     ?peeps($name1 : $name, $likes : \"stilton\", $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        this.testQuery(drl);
    }

    @Test(timeout=10000L)
    public void testQueryMixed() {
        String drl = this.getQueryHeader();
        drl = drl + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($name1; $likes1 : $likes, $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        drl = drl + "rule x2\nwhen\n    String( this == \"go2\" )\n    ?peeps($name1, \"stilton\"; $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        drl = drl + "rule x3\nwhen\n    String( this == \"go3\" )\n    $name1 : String() from \"darth\";\n     ?peeps($name1, \"stilton\"; $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        drl = drl + "rule x4\nwhen\n    String( this == \"go4\" )\n    $name1 : String() from \"darth\"\n     $age1 : Integer() from 200;\n     ?peeps($name1; $likes : \"stilton\", $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        this.testQuery(drl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testQuery(String drl) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person p1 = new Person("darth", "stilton", 100);
            Person p2 = new Person("darth", "stilton", 200);
            Person p3 = new Person("yoda", "stilton", 300);
            Person p4 = new Person("luke", "brie", 300);
            Person p5 = new Person("bobba", "cheddar", 300);
            ksession.insert((Object)p1);
            ksession.insert((Object)p2);
            ksession.insert((Object)p3);
            ksession.insert((Object)p4);
            ksession.insert((Object)p5);
            ksession.insert((Object)"go1");
            ksession.fireAllRules();
            if (this.kieBaseTestConfiguration.isIdentity()) {
                Assert.assertEquals((long)5L, (long)list.size());
                Assert.assertTrue((boolean)list.contains("darth : 100"));
                Assert.assertTrue((boolean)list.contains("darth : 200"));
                Assert.assertTrue((boolean)list.contains("yoda : 300"));
                Assert.assertTrue((boolean)list.contains("luke : 300"));
                Assert.assertTrue((boolean)list.contains("bobba : 300"));
            } else {
                Assert.assertEquals((long)4L, (long)list.size());
                Assert.assertTrue((boolean)list.contains("darth : 100"));
                Assert.assertTrue((boolean)list.contains("yoda : 300"));
                Assert.assertTrue((boolean)list.contains("luke : 300"));
                Assert.assertTrue((boolean)list.contains("bobba : 300"));
            }
            list.clear();
            ksession.insert((Object)"go2");
            ksession.fireAllRules();
            if (this.kieBaseTestConfiguration.isIdentity()) {
                Assert.assertEquals((long)3L, (long)list.size());
                Assert.assertTrue((boolean)list.contains("darth : 100"));
                Assert.assertTrue((boolean)list.contains("darth : 200"));
                Assert.assertTrue((boolean)list.contains("yoda : 300"));
            } else {
                Assert.assertEquals((long)2L, (long)list.size());
                Assert.assertTrue((boolean)list.contains("darth : 100"));
                Assert.assertTrue((boolean)list.contains("yoda : 300"));
            }
            list.clear();
            ksession.insert((Object)"go3");
            ksession.fireAllRules();
            if (this.kieBaseTestConfiguration.isIdentity()) {
                Assert.assertEquals((long)2L, (long)list.size());
                Assert.assertTrue((boolean)list.contains("darth : 100"));
                Assert.assertTrue((boolean)list.contains("darth : 200"));
            } else {
                Assert.assertEquals((long)1L, (long)list.size());
                Assert.assertTrue((boolean)list.contains("darth : 100"));
            }
            list.clear();
            ksession.insert((Object)"go4");
            ksession.fireAllRules();
            if (this.kieBaseTestConfiguration.isIdentity()) {
                Assert.assertEquals((long)1L, (long)list.size());
                Assert.assertTrue((boolean)list.contains("darth : 200"));
            } else {
                Assert.assertEquals((long)0L, (long)list.size());
            }
        }
        finally {
            ksession.dispose();
        }
    }

    private String getQueryHeader() {
        return "package org.drools.compiler.test  \nimport " + Person.class.getCanonicalName() + "\nglobal java.util.List list\nquery peeps( String $name, String $likes, int $age ) \n    Person( $name := name, $likes := likes, $age := age; ) \nend\n";
    }
}

