/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.phreak;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NodeMemories;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.mvel.integrationtests.phreak.A;
import org.drools.mvel.integrationtests.phreak.B;
import org.drools.mvel.integrationtests.phreak.C;
import org.drools.mvel.integrationtests.phreak.E;
import org.drools.mvel.integrationtests.phreak.X;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class RemoveRuleTest {
    @Test
    public void testPopulatedSingleRuleNoSharing() throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        wm.insert((Object)new A(1));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        kbase.addPackages(this.buildKnowledgePackage("r1", "   A() B() C(object == 2) X() E()\n"));
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        ObjectTypeNode aotn = this.getObjectTypeNode((KieBase)kbase, A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        Assert.assertNotNull((Object)sm.getStagedLeftTuples().getInsertFirst());
        wm.fireAllRules();
        BetaMemory bMem = (BetaMemory)sm.getNodeMemories().get(1);
        junit.framework.Assert.assertEquals((int)1, (int)bMem.getLeftTupleMemory().size());
        junit.framework.Assert.assertEquals((int)1, (int)bMem.getRightTupleMemory().size());
        BetaMemory eMem = (BetaMemory)sm.getNodeMemories().get(4);
        junit.framework.Assert.assertEquals((int)1, (int)eMem.getLeftTupleMemory().size());
        junit.framework.Assert.assertEquals((int)1, (int)eMem.getRightTupleMemory().size());
        NodeMemories nms = wm.getNodeMemories();
        junit.framework.Assert.assertEquals((int)12, (int)this.countNodeMemories(nms));
        Assert.assertNull((Object)sm.getStagedLeftTuples().getInsertFirst());
        junit.framework.Assert.assertEquals((int)1, (int)list.size());
        junit.framework.Assert.assertEquals((String)"r1", (String)((Match)list.get(0)).getRule().getName());
        kbase.removeRule("org.kie", "r1");
        junit.framework.Assert.assertEquals((int)6, (int)this.countNodeMemories(nms));
    }

    @Test
    public void testPopulatedSingleRuleNoSharingWithSubnetworkAtStart() throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.insert((Object)new C(2));
        wm.fireAllRules();
        kbase.addPackages(this.buildKnowledgePackage("r1", "   A() not( B() and C() ) X() E()\n"));
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)2, (int)list.size());
        junit.framework.Assert.assertEquals((String)"r1", (String)((Match)list.get(0)).getRule().getName());
        junit.framework.Assert.assertEquals((String)"r1", (String)((Match)list.get(1)).getRule().getName());
        kbase.removeRule("org.kie", "r1");
        wm.insert((Object)new A(1));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)2, (int)list.size());
    }

    private int countNodeMemories(NodeMemories nms) {
        int count = 0;
        for (int i = 0; i < nms.length(); ++i) {
            if (nms.peekNodeMemory(i) == null) continue;
            System.out.println(nms.peekNodeMemory(i));
            ++count;
        }
        return count;
    }

    @Test
    public void testPopulatedRuleMidwayShare() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A() B() C(1;) X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(3));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)7, (int)this.countNodeMemories(wm.getNodeMemories()));
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   a : A() B() C(2;) X() E()\n"));
        wm.fireAllRules();
        ObjectTypeNode aotn = this.getObjectTypeNode((KieBase)kbase1, A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c1Node = (JoinNode)bNode.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c2Node = (JoinNode)bNode.getSinkPropagator().getLastLeftTupleSink();
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        BetaMemory c1Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c1Node);
        TestCase.assertSame((Object)sm.getFirst(), (Object)c1Mem.getSegmentMemory());
        junit.framework.Assert.assertEquals((int)3, (int)c1Mem.getLeftTupleMemory().size());
        junit.framework.Assert.assertEquals((int)1, (int)c1Mem.getRightTupleMemory().size());
        BetaMemory c2Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c2Node);
        SegmentMemory c2Smem = ((SegmentMemory)sm.getFirst()).getNext();
        TestCase.assertSame((Object)c2Smem, (Object)c2Mem.getSegmentMemory());
        junit.framework.Assert.assertEquals((int)3, (int)c2Mem.getLeftTupleMemory().size());
        junit.framework.Assert.assertEquals((int)1, (int)c2Mem.getRightTupleMemory().size());
        junit.framework.Assert.assertEquals((int)6, (int)list.size());
        kbase1.removeRule("org.kie", "r2");
        junit.framework.Assert.assertEquals((int)10, (int)this.countNodeMemories(wm.getNodeMemories()));
        Assert.assertNull((Object)sm.getFirst());
        TestCase.assertSame((Object)sm, (Object)c1Mem.getSegmentMemory());
        wm.insert((Object)new A(1));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((String)"r1", (String)((Match)list.get(6)).getRule().getName());
        junit.framework.Assert.assertEquals((int)7, (int)list.size());
    }

    @Test
    public void testPopulatedRuleWithEvals() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   a:A() B() eval(1==1) eval(1==1) C(1;) \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(3));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)7, (int)this.countNodeMemories(wm.getNodeMemories()));
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   a:A() B() eval(1==1) eval(1==1) C(2;) \n"));
        wm.fireAllRules();
        ObjectTypeNode aotn = this.getObjectTypeNode((KieBase)kbase1, A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getFirstLeftTupleSink();
        EvalConditionNode e1 = (EvalConditionNode)bNode.getSinkPropagator().getFirstLeftTupleSink();
        EvalConditionNode e2 = (EvalConditionNode)e1.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c1Node = (JoinNode)e2.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c2Node = (JoinNode)e2.getSinkPropagator().getLastLeftTupleSink();
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        BetaMemory c1Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c1Node);
        TestCase.assertSame((Object)sm.getFirst(), (Object)c1Mem.getSegmentMemory());
        junit.framework.Assert.assertEquals((int)3, (int)c1Mem.getLeftTupleMemory().size());
        junit.framework.Assert.assertEquals((int)1, (int)c1Mem.getRightTupleMemory().size());
        BetaMemory c2Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c2Node);
        SegmentMemory c2Smem = ((SegmentMemory)sm.getFirst()).getNext();
        TestCase.assertSame((Object)c2Smem, (Object)c2Mem.getSegmentMemory());
        junit.framework.Assert.assertEquals((int)3, (int)c2Mem.getLeftTupleMemory().size());
        junit.framework.Assert.assertEquals((int)1, (int)c2Mem.getRightTupleMemory().size());
        junit.framework.Assert.assertEquals((int)6, (int)list.size());
        kbase1.removeRule("org.kie", "r2");
        junit.framework.Assert.assertEquals((int)8, (int)this.countNodeMemories(wm.getNodeMemories()));
        Assert.assertNull((Object)sm.getFirst());
        TestCase.assertSame((Object)sm, (Object)c1Mem.getSegmentMemory());
        wm.insert((Object)new A(1));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((String)"r1", (String)((Match)list.get(6)).getRule().getName());
        junit.framework.Assert.assertEquals((int)7, (int)list.size());
    }

    @Test
    public void testPopulatedSharedLiaNode() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A() B(1;) C() X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(3));
        wm.insert((Object)new B(1));
        wm.insert((Object)new B(2));
        wm.insert((Object)new C(1));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)3, (int)list.size());
        junit.framework.Assert.assertEquals((int)7, (int)this.countNodeMemories(wm.getNodeMemories()));
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   a : A() B(2;) C() X() E()\n"));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)17, (int)this.countNodeMemories(wm.getNodeMemories()));
        ObjectTypeNode aotn = this.getObjectTypeNode((KieBase)kbase1, A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode b1Node = (JoinNode)liaNode.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode b2Node = (JoinNode)liaNode.getSinkPropagator().getLastLeftTupleSink();
        JoinNode c1Node = (JoinNode)b1Node.getSinkPropagator().getLastLeftTupleSink();
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        BetaMemory b1Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)b1Node);
        TestCase.assertSame((Object)sm.getFirst(), (Object)b1Mem.getSegmentMemory());
        junit.framework.Assert.assertEquals((int)3, (int)b1Mem.getLeftTupleMemory().size());
        junit.framework.Assert.assertEquals((int)1, (int)b1Mem.getRightTupleMemory().size());
        BetaMemory b2Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)b2Node);
        SegmentMemory b2Smem = ((SegmentMemory)sm.getFirst()).getNext();
        TestCase.assertSame((Object)b2Smem, (Object)b2Mem.getSegmentMemory());
        junit.framework.Assert.assertEquals((int)3, (int)b2Mem.getLeftTupleMemory().size());
        junit.framework.Assert.assertEquals((int)1, (int)b2Mem.getRightTupleMemory().size());
        junit.framework.Assert.assertEquals((int)6, (int)list.size());
        BetaMemory c1Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c1Node);
        TestCase.assertSame((Object)b1Mem.getSegmentMemory(), (Object)c1Mem.getSegmentMemory());
        TestCase.assertNotSame((Object)b1Mem.getSegmentMemory(), (Object)b2Mem.getSegmentMemory());
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)6, (int)list.size());
        junit.framework.Assert.assertEquals((int)17, (int)this.countNodeMemories(wm.getNodeMemories()));
        kbase1.removeRule("org.kie", "r2");
        junit.framework.Assert.assertEquals((int)12, (int)this.countNodeMemories(wm.getNodeMemories()));
        TestCase.assertSame((Object)sm, (Object)b1Mem.getSegmentMemory());
        TestCase.assertSame((Object)sm, (Object)c1Mem.getSegmentMemory());
        Assert.assertNull((Object)sm.getFirst());
        junit.framework.Assert.assertEquals((int)3, (int)b1Mem.getLeftTupleMemory().size());
        junit.framework.Assert.assertEquals((int)1, (int)b1Mem.getRightTupleMemory().size());
        TestCase.assertSame((Object)b2Smem, (Object)b2Mem.getSegmentMemory());
        wm.insert((Object)new A(1));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((String)"r1", (String)((Match)list.get(6)).getRule().getName());
        junit.framework.Assert.assertEquals((int)7, (int)list.size());
    }

    @Test
    public void testPopulatedSharedLiaNodeNoBeta() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        A a1 = new A(1);
        InternalFactHandle fh1 = (InternalFactHandle)wm.insert((Object)a1);
        A a2 = new A(2);
        InternalFactHandle fh2 = (InternalFactHandle)wm.insert((Object)a2);
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)2, (int)list.size());
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   a : A()\n"));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)4, (int)list.size());
        kbase1.removeRule("org.kie", "r1");
        kbase1.removeRule("org.kie", "r2");
        list.clear();
        Assert.assertNull((Object)fh1.getFirstLeftTuple());
        Assert.assertNull((Object)fh2.getFirstLeftTuple());
        wm.update((FactHandle)fh1, (Object)a1);
        wm.update((FactHandle)fh2, (Object)a2);
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testPopulatedSharedToRtn() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A() B() C() X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)2, (int)list.size());
        junit.framework.Assert.assertEquals((int)7, (int)this.countNodeMemories(wm.getNodeMemories()));
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A() B() C() X() E()\n"));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)8, (int)this.countNodeMemories(wm.getNodeMemories()));
        junit.framework.Assert.assertEquals((int)4, (int)list.size());
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", kbase1);
        RuleTerminalNode rtn2 = this.getRtn("org.kie.r2", kbase1);
        PathMemory pmem1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        PathMemory pmem2 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn2);
        SegmentMemory[] smems1 = pmem1.getSegmentMemories();
        SegmentMemory[] smems2 = pmem2.getSegmentMemories();
        junit.framework.Assert.assertEquals((int)2, (int)smems1.length);
        junit.framework.Assert.assertEquals((int)2, (int)smems2.length);
        TestCase.assertSame((Object)smems1[0], (Object)smems2[0]);
        TestCase.assertNotSame((Object)smems1[1], (Object)smems2[1]);
        SegmentMemory sm = smems1[0];
        junit.framework.Assert.assertEquals((Object)smems1[1], (Object)sm.getFirst());
        JoinNode eNode1 = (JoinNode)rtn1.getLeftTupleSource();
        JoinNode eNode2 = (JoinNode)rtn2.getLeftTupleSource();
        TestCase.assertSame((Object)eNode1, (Object)eNode2);
        pmem1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        kbase1.removeRule("org.kie", "r2");
        System.out.println("---");
        junit.framework.Assert.assertEquals((int)7, (int)this.countNodeMemories(wm.getNodeMemories()));
        Assert.assertNull((Object)sm.getFirst());
        pmem1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        smems1 = pmem1.getSegmentMemories();
        junit.framework.Assert.assertEquals((int)1, (int)smems1.length);
        TestCase.assertSame((Object)sm, (Object)smems1[0]);
        wm.insert((Object)new A(1));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((String)"r1", (String)((Match)list.get(4)).getRule().getName());
        junit.framework.Assert.assertEquals((int)5, (int)list.size());
    }

    @Test
    public void testPopulatedMultipleSharesRemoveFirst() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        InternalFactHandle fh1 = (InternalFactHandle)wm.insert((Object)new A(1));
        InternalFactHandle fh2 = (InternalFactHandle)wm.insert((Object)new A(2));
        InternalFactHandle fh3 = (InternalFactHandle)wm.insert((Object)new A(2));
        InternalFactHandle fh4 = (InternalFactHandle)wm.insert((Object)new A(3));
        InternalFactHandle fh5 = (InternalFactHandle)wm.insert((Object)new B(1));
        InternalFactHandle fh6 = (InternalFactHandle)wm.insert((Object)new B(2));
        InternalFactHandle fh7 = (InternalFactHandle)wm.insert((Object)new C(1));
        InternalFactHandle fh8 = (InternalFactHandle)wm.insert((Object)new C(2));
        InternalFactHandle fh9 = (InternalFactHandle)wm.insert((Object)new X(1));
        InternalFactHandle fh10 = (InternalFactHandle)wm.insert((Object)new E(1));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)2, (int)list.size());
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(2;) X() E()\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(3;) B(1;) B(2;) C(2;) X() E()\n"));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)5, (int)list.size());
        kbase1.removeRule("org.kie", "r1");
        list.clear();
        wm.update((FactHandle)fh1, fh1.getObject());
        wm.update((FactHandle)fh2, fh2.getObject());
        wm.update((FactHandle)fh3, fh3.getObject());
        wm.update((FactHandle)fh4, fh4.getObject());
        wm.update((FactHandle)fh5, fh5.getObject());
        wm.update((FactHandle)fh6, fh6.getObject());
        wm.update((FactHandle)fh7, fh7.getObject());
        wm.update((FactHandle)fh8, fh8.getObject());
        wm.update((FactHandle)fh9, fh9.getObject());
        wm.update((FactHandle)fh10, fh10.getObject());
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testPopulatedMultipleSharesRemoveMid() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        InternalFactHandle fh1 = (InternalFactHandle)wm.insert((Object)new A(1));
        InternalFactHandle fh2 = (InternalFactHandle)wm.insert((Object)new A(2));
        InternalFactHandle fh3 = (InternalFactHandle)wm.insert((Object)new A(2));
        InternalFactHandle fh4 = (InternalFactHandle)wm.insert((Object)new A(3));
        InternalFactHandle fh5 = (InternalFactHandle)wm.insert((Object)new B(1));
        InternalFactHandle fh6 = (InternalFactHandle)wm.insert((Object)new B(2));
        InternalFactHandle fh7 = (InternalFactHandle)wm.insert((Object)new C(1));
        InternalFactHandle fh8 = (InternalFactHandle)wm.insert((Object)new C(2));
        InternalFactHandle fh9 = (InternalFactHandle)wm.insert((Object)new X(1));
        InternalFactHandle fh10 = (InternalFactHandle)wm.insert((Object)new E(1));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)2, (int)list.size());
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(2;) X() E()\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(3;) B(1;) B(2;) C(2;) X() E()\n"));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)5, (int)list.size());
        kbase1.removeRule("org.kie", "r2");
        list.clear();
        wm.update((FactHandle)fh1, fh1.getObject());
        wm.update((FactHandle)fh2, fh2.getObject());
        wm.update((FactHandle)fh3, fh3.getObject());
        wm.update((FactHandle)fh4, fh4.getObject());
        wm.update((FactHandle)fh5, fh5.getObject());
        wm.update((FactHandle)fh6, fh6.getObject());
        wm.update((FactHandle)fh7, fh7.getObject());
        wm.update((FactHandle)fh8, fh8.getObject());
        wm.update((FactHandle)fh9, fh9.getObject());
        wm.update((FactHandle)fh10, fh10.getObject());
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testPopulatedMultipleSharesRemoveLast() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        InternalFactHandle fh1 = (InternalFactHandle)wm.insert((Object)new A(1));
        InternalFactHandle fh2 = (InternalFactHandle)wm.insert((Object)new A(2));
        InternalFactHandle fh3 = (InternalFactHandle)wm.insert((Object)new A(2));
        InternalFactHandle fh4 = (InternalFactHandle)wm.insert((Object)new A(3));
        InternalFactHandle fh5 = (InternalFactHandle)wm.insert((Object)new B(1));
        InternalFactHandle fh6 = (InternalFactHandle)wm.insert((Object)new B(2));
        InternalFactHandle fh7 = (InternalFactHandle)wm.insert((Object)new C(1));
        InternalFactHandle fh8 = (InternalFactHandle)wm.insert((Object)new C(2));
        InternalFactHandle fh9 = (InternalFactHandle)wm.insert((Object)new X(1));
        InternalFactHandle fh10 = (InternalFactHandle)wm.insert((Object)new E(1));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)2, (int)list.size());
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(2;) X() E()\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(3;) B(1;) B(2;) C(2;) X() E()\n"));
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)5, (int)list.size());
        kbase1.removeRule("org.kie", "r3");
        list.clear();
        wm.update((FactHandle)fh1, fh1.getObject());
        wm.update((FactHandle)fh2, fh2.getObject());
        wm.update((FactHandle)fh3, fh3.getObject());
        wm.update((FactHandle)fh4, fh4.getObject());
        wm.update((FactHandle)fh5, fh5.getObject());
        wm.update((FactHandle)fh6, fh6.getObject());
        wm.update((FactHandle)fh7, fh7.getObject());
        wm.update((FactHandle)fh8, fh8.getObject());
        wm.update((FactHandle)fh9, fh9.getObject());
        wm.update((FactHandle)fh10, fh10.getObject());
        wm.fireAllRules();
        junit.framework.Assert.assertEquals((int)4, (int)list.size());
    }

    @Test
    public void testPathMemorySizeAfterSegmentMerge() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;) B(1;)\n");
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)\n"));
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new B(1));
        wm.fireAllRules();
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", kbase1);
        RuleTerminalNode rtn2 = this.getRtn("org.kie.r2", kbase1);
        junit.framework.Assert.assertEquals((int)1, (int)((PathMemory)wm.getNodeMemory((MemoryFactory)rtn1)).getSegmentMemories().length);
        junit.framework.Assert.assertEquals((int)1, (int)((PathMemory)wm.getNodeMemory((MemoryFactory)rtn2)).getSegmentMemories().length);
        kbase1.removeRule("org.kie", "r2");
        junit.framework.Assert.assertEquals((int)1, (int)((PathMemory)wm.getNodeMemory((MemoryFactory)rtn1)).getSegmentMemories().length);
    }

    @Test
    public void testPathMemorySizeAfterSegmentMergeNonInitialized() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;) B(1;)\n");
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)\n"));
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", kbase1);
        RuleTerminalNode rtn2 = this.getRtn("org.kie.r2", kbase1);
        junit.framework.Assert.assertEquals((int)1, (int)((PathMemory)wm.getNodeMemory((MemoryFactory)rtn1)).getSegmentMemories().length);
        junit.framework.Assert.assertEquals((int)1, (int)((PathMemory)wm.getNodeMemory((MemoryFactory)rtn2)).getSegmentMemories().length);
        kbase1.removeRule("org.kie", "r2");
        junit.framework.Assert.assertEquals((int)1, (int)((PathMemory)wm.getNodeMemory((MemoryFactory)rtn1)).getSegmentMemories().length);
    }

    @Test
    public void testSplitTwoBeforeCreatedSegment() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n");
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r4", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) \n"));
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new E(1));
        wm.insert((Object)new E(2));
        wm.flushPropagations();
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", kbase1);
        RuleTerminalNode rtn2 = this.getRtn("org.kie.r2", kbase1);
        RuleTerminalNode rtn3 = this.getRtn("org.kie.r3", kbase1);
        RuleTerminalNode rtn4 = this.getRtn("org.kie.r4", kbase1);
        PathMemory pm1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        SegmentMemory[] smems = pm1.getSegmentMemories();
        junit.framework.Assert.assertEquals((int)4, (int)smems.length);
        Assert.assertNull((Object)smems[0]);
        Assert.assertNull((Object)smems[1]);
        Assert.assertNull((Object)smems[3]);
        SegmentMemory sm = smems[2];
        junit.framework.Assert.assertEquals((int)2, (int)sm.getPos());
        junit.framework.Assert.assertEquals((long)4L, (long)sm.getSegmentPosMaskBit());
        junit.framework.Assert.assertEquals((long)4L, (long)pm1.getLinkedSegmentMask());
        kbase1.addPackages(this.buildKnowledgePackage("r5", "   A(1;)  A(2;) B(1;) B(2;) \n"));
        smems = pm1.getSegmentMemories();
        junit.framework.Assert.assertEquals((int)5, (int)smems.length);
        Assert.assertNull((Object)smems[0]);
        Assert.assertNull((Object)smems[1]);
        Assert.assertNull((Object)smems[2]);
        sm = smems[3];
        junit.framework.Assert.assertEquals((int)3, (int)sm.getPos());
        junit.framework.Assert.assertEquals((long)8L, (long)sm.getSegmentPosMaskBit());
        junit.framework.Assert.assertEquals((long)8L, (long)pm1.getLinkedSegmentMask());
        RuleTerminalNode rtn5 = this.getRtn("org.kie.r5", kbase1);
        PathMemory pm5 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn5);
        smems = pm5.getSegmentMemories();
        junit.framework.Assert.assertEquals((int)2, (int)smems.length);
        Assert.assertNull((Object)smems[0]);
        Assert.assertNull((Object)smems[1]);
    }

    private RuleTerminalNode getRtn(String ruleName, InternalKnowledgeBase kbase) {
        return (RuleTerminalNode)((KnowledgeBaseImpl)kbase).getReteooBuilder().getTerminalNodes(ruleName)[0];
    }

    private InternalKnowledgeBase buildKnowledgeBase(String ruleName, String rule) {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        boolean i = false;
        str = str + "rule " + ruleName + "  when \n";
        str = str + rule;
        str = str + "then \n";
        str = str + " list.add( kcontext.getMatch() );\n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private Collection<KiePackage> buildKnowledgePackage(String ruleName, String rule) {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        boolean i = false;
        str = str + "rule " + ruleName + "  when \n";
        str = str + rule;
        str = str + "then \n";
        str = str + " list.add( kcontext.getMatch() );\n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        return kbuilder.getKnowledgePackages();
    }

    public ObjectTypeNode getObjectTypeNode(KieBase kbase, Class<?> nodeClass) {
        List nodes = ((KnowledgeBaseImpl)kbase).getRete().getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != nodeClass) continue;
            return n;
        }
        return null;
    }
}

