/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.mvel.compiler.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.internal.command.CommandFactory;

@RunWith(value=Parameterized.class)
public class MoreBatchExecutionTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private KieSession ksession = null;

    public MoreBatchExecutionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @After
    public void disposeKSession() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testFireAllRules() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/mvel/integrationtests/drl/test_ImportFunctions.drl"});
        this.ksession = kbase.newKieSession();
        Cheese cheese = new Cheese("stilton", 15);
        this.ksession.insert((Object)cheese);
        List list = new ArrayList();
        this.ksession.setGlobal("list", list);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newFireAllRules((String)"fired"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        Assert.assertNotNull((String)"Batch execution result is null!", (Object)result);
        Object firedObject = result.getValue("fired");
        Assert.assertTrue((String)"Retrieved object is null or incorrect!", (firedObject != null && firedObject instanceof Integer ? 1 : 0) != 0);
        Assert.assertEquals((Object)4, (Object)firedObject);
        list = (List)this.ksession.getGlobal("list");
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"rule1", list.get(0));
        Assert.assertEquals((Object)"rule2", list.get(1));
        Assert.assertEquals((Object)"rule3", list.get(2));
        Assert.assertEquals((Object)"rule4", list.get(3));
    }

    @Test
    public void testQuery() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/mvel/integrationtests/simple_query_test.drl"});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Cheese("stinky", 5));
        ksession.insert((Object)new Cheese("smelly", 7));
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newQuery((String)"numStinkyCheeses", (String)"simple query"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)ksession.execute((Command)cmds);
        Assert.assertNotNull((String)"Batch execution result is null!", (Object)result);
        Object queryResultsObject = result.getValue("numStinkyCheeses");
        Assert.assertTrue((String)"Retrieved object is null or incorrect!", (queryResultsObject != null && queryResultsObject instanceof QueryResults ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)((QueryResults)queryResultsObject).size());
    }
}

