/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler;

import java.util.Arrays;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.BindingDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.test.model.DroolsTestCase;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Person;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;

public class QueryBuilderTest
extends DroolsTestCase {
    @Test
    public void testRuleWithQuery() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr = new PackageDescr("p1");
        QueryDescr queryDescr = new QueryDescr("query1");
        queryDescr.addParameter("String", "$name");
        queryDescr.addParameter("int", "$age");
        queryDescr.addParameter("String", "$likes");
        packageDescr.addRule((RuleDescr)queryDescr);
        AndDescr lhs = new AndDescr();
        queryDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Person.class.getName());
        lhs.addDescr((BaseDescr)pattern);
        pattern.addConstraint((BaseDescr)new BindingDescr("$name", "name", true));
        pattern.addConstraint((BaseDescr)new BindingDescr("$age", "age", true));
        pattern.addConstraint((BaseDescr)new BindingDescr("$likes", "likes", true));
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        pattern = new PatternDescr(Cheese.class.getName());
        lhs.addDescr((BaseDescr)pattern);
        pattern.addConstraint((BaseDescr)new BindingDescr("$type", "type"));
        pattern = new PatternDescr("query1");
        pattern.setQuery(true);
        lhs.addDescr((BaseDescr)pattern);
        ExprConstraintDescr expr = new ExprConstraintDescr("'bobba'");
        expr.setPosition(0);
        expr.setType(ExprConstraintDescr.Type.POSITIONAL);
        pattern.addConstraint((BaseDescr)expr);
        expr = new ExprConstraintDescr("$age");
        expr.setPosition(1);
        expr.setType(ExprConstraintDescr.Type.POSITIONAL);
        pattern.addConstraint((BaseDescr)expr);
        expr = new ExprConstraintDescr("$type");
        expr.setPosition(2);
        expr.setType(ExprConstraintDescr.Type.POSITIONAL);
        pattern.addConstraint((BaseDescr)expr);
        ruleDescr.setConsequence((Object)"System.out.println(\"age: \" + $age);");
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Arrays.asList(builder.getPackage(packageDescr.getName())));
        KieSession session = kbase.newKieSession();
        session.insert((Object)new Person("bobba", "stilton", 90));
        session.insert((Object)new Person("bobba", "brie", 80));
        session.insert((Object)new Person("bobba", "brie", 75));
        session.insert((Object)new Person("darth", "brie", 100));
        session.insert((Object)new Person("luke", "brie", 25));
        session.insert((Object)new Cheese("brie", 25));
        session.fireAllRules();
    }

    @Test
    public void testQuery() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        PackageDescr packageDescr = new PackageDescr("p1");
        QueryDescr queryDescr = new QueryDescr("query1");
        queryDescr.addParameter("String", "$type");
        packageDescr.addRule((RuleDescr)queryDescr);
        AndDescr lhs = new AndDescr();
        queryDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr("type == $type"));
        QueryDescr queryDescr2 = new QueryDescr("query2");
        packageDescr.addRule((RuleDescr)queryDescr2);
        AndDescr lhs2 = new AndDescr();
        queryDescr2.setLhs(lhs2);
        PatternDescr pattern2 = new PatternDescr(Cheese.class.getName());
        lhs2.addDescr((BaseDescr)pattern2);
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Arrays.asList(builder.getPackage(packageDescr.getName())));
        KieSession session = kbase.newKieSession();
        session.insert((Object)new Cheese("stilton", 15));
        QueryResults results = session.getQueryResults("query1", new Object[]{"stilton"});
        Assert.assertEquals((long)1L, (long)results.size());
        Object object = ((QueryResultsRow)results.iterator().next()).get("stilton");
        Assert.assertEquals((Object)new Cheese("stilton", 15), (Object)object);
        results = session.getQueryResults("query1", new Object[]{"cheddar"});
        Assert.assertEquals((long)0L, (long)results.size());
        session.insert((Object)new Cheese("dolcelatte", 20));
        results = session.getQueryResults("query2", new Object[0]);
        Assert.assertEquals((long)2L, (long)results.size());
    }
}

