/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler;

import java.util.Collection;
import java.util.List;
import org.drools.mvel.compiler.compiler.TypeDeclarationTest;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;

@RunWith(value=Parameterized.class)
public class TypeDeclarationUnsupportedModelTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public TypeDeclarationUnsupportedModelTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testTraitExtendPojo() {
        String s1 = "package test;\ndeclare Poojo end declare trait Mask extends Poojo end ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package test;\ndeclare Poojo end declare trait Mask extends Poojo end "});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertEquals((long)1L, (long)errors.size());
    }

    @Test
    public void testRedeclareWithInterfaceExtensionAndOverride() {
        String s1 = "package test;\ndeclare trait " + TypeDeclarationTest.Ext.class.getCanonicalName() + " extends " + TypeDeclarationTest.Base.class.getCanonicalName() + "  fld : String end declare trait " + TypeDeclarationTest.Base.class.getCanonicalName() + " end ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{s1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
    }

    @Test
    public void testDeclaresInForeignPackages() {
        String str1 = "package org.drools \ndeclare foreign.ClassC fld : foreign.ClassD end declare foreign.ClassD end ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
    }

    @Test
    public void testTypeReDeclarationPojo() {
        String str1 = "package org.drools \nimport " + TypeDeclarationTest.class.getName() + ".ClassC; \ndeclare " + TypeDeclarationTest.class.getName() + ".ClassC \n    name : String \n    age : Integer \nend \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
    }

    @Test
    public void testTypeReDeclarationPojoMoreFields() {
        String str1 = "package org.drools \nimport " + TypeDeclarationTest.class.getName() + ".ClassC; \ndeclare " + TypeDeclarationTest.class.getName() + ".ClassC \n    name : String \n    age : Integer \n    address : Objet \nend \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testTypeReDeclarationPojoLessFields() {
        String str1 = "package org.drools \nimport " + TypeDeclarationTest.class.getName() + ".ClassC; \ndeclare " + TypeDeclarationTest.class.getName() + ".ClassC \n    name : String \nend \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }
}

