/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.conf;

import org.drools.core.runtime.rule.impl.DefaultConsequenceExceptionHandler;
import org.drools.core.util.MemoryUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.conf.BetaRangeIndexOption;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.RemoveIdentitiesOption;
import org.kie.api.conf.SequentialOption;
import org.kie.internal.conf.AlphaRangeIndexThresholdOption;
import org.kie.internal.conf.AlphaThresholdOption;
import org.kie.internal.conf.CompositeKeyDepthOption;
import org.kie.internal.conf.ConsequenceExceptionHandlerOption;
import org.kie.internal.conf.IndexLeftBetaMemoryOption;
import org.kie.internal.conf.IndexPrecedenceOption;
import org.kie.internal.conf.IndexRightBetaMemoryOption;
import org.kie.internal.conf.MaxThreadsOption;
import org.kie.internal.conf.MultithreadEvaluationOption;
import org.kie.internal.conf.PermGenThresholdOption;
import org.kie.internal.conf.SequentialAgendaOption;
import org.kie.internal.conf.ShareAlphaNodesOption;
import org.kie.internal.conf.ShareBetaNodesOption;

public class KnowledgeBaseConfigurationTest {
    private KieBaseConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.config = KieServices.Factory.get().newKieBaseConfiguration();
    }

    @Test
    public void testSequentialConfiguration() {
        this.config.setOption((KieBaseOption)SequentialOption.YES);
        Assert.assertEquals((Object)SequentialOption.YES, (Object)this.config.getOption(SequentialOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.sequential"));
        this.config.setProperty("drools.sequential", "false");
        Assert.assertEquals((Object)SequentialOption.NO, (Object)this.config.getOption(SequentialOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.sequential"));
    }

    @Test
    public void testRemoveIdentitiesConfiguration() {
        this.config.setOption((KieBaseOption)RemoveIdentitiesOption.YES);
        Assert.assertEquals((Object)RemoveIdentitiesOption.YES, (Object)this.config.getOption(RemoveIdentitiesOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.removeIdentities"));
        this.config.setProperty("drools.removeIdentities", "false");
        Assert.assertEquals((Object)RemoveIdentitiesOption.NO, (Object)this.config.getOption(RemoveIdentitiesOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.removeIdentities"));
    }

    @Test
    public void testShareAlphaNodesConfiguration() {
        this.config.setOption((KieBaseOption)ShareAlphaNodesOption.YES);
        Assert.assertEquals((Object)ShareAlphaNodesOption.YES, (Object)this.config.getOption(ShareAlphaNodesOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.shareAlphaNodes"));
        this.config.setProperty("drools.shareAlphaNodes", "false");
        Assert.assertEquals((Object)ShareAlphaNodesOption.NO, (Object)this.config.getOption(ShareAlphaNodesOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.shareAlphaNodes"));
    }

    @Test
    public void testShareBetaNodesConfiguration() {
        this.config.setOption((KieBaseOption)ShareBetaNodesOption.YES);
        Assert.assertEquals((Object)ShareBetaNodesOption.YES, (Object)this.config.getOption(ShareBetaNodesOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.shareBetaNodes"));
        this.config.setProperty("drools.shareBetaNodes", "false");
        Assert.assertEquals((Object)ShareBetaNodesOption.NO, (Object)this.config.getOption(ShareBetaNodesOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.shareBetaNodes"));
    }

    @Test
    public void testIndexLeftBetaMemoryConfiguration() {
        this.config.setOption((KieBaseOption)IndexLeftBetaMemoryOption.YES);
        Assert.assertEquals((Object)IndexLeftBetaMemoryOption.YES, (Object)this.config.getOption(IndexLeftBetaMemoryOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.indexLeftBetaMemory"));
        this.config.setProperty("drools.indexLeftBetaMemory", "false");
        Assert.assertEquals((Object)IndexLeftBetaMemoryOption.NO, (Object)this.config.getOption(IndexLeftBetaMemoryOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.indexLeftBetaMemory"));
    }

    @Test
    public void testIndexRightBetaMemoryConfiguration() {
        this.config.setOption((KieBaseOption)IndexRightBetaMemoryOption.YES);
        Assert.assertEquals((Object)IndexRightBetaMemoryOption.YES, (Object)this.config.getOption(IndexRightBetaMemoryOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.indexRightBetaMemory"));
        this.config.setProperty("drools.indexRightBetaMemory", "false");
        Assert.assertEquals((Object)IndexRightBetaMemoryOption.NO, (Object)this.config.getOption(IndexRightBetaMemoryOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.indexRightBetaMemory"));
    }

    @Test
    public void testIndexPrecedenceConfiguration() {
        this.config.setOption((KieBaseOption)IndexPrecedenceOption.PATTERN_ORDER);
        Assert.assertEquals((Object)IndexPrecedenceOption.PATTERN_ORDER, (Object)this.config.getOption(IndexPrecedenceOption.class));
        Assert.assertEquals((Object)"pattern", (Object)this.config.getProperty("drools.indexPrecedence"));
        this.config.setProperty("drools.indexPrecedence", "equality");
        Assert.assertEquals((Object)IndexPrecedenceOption.EQUALITY_PRIORITY, (Object)this.config.getOption(IndexPrecedenceOption.class));
        Assert.assertEquals((Object)"equality", (Object)this.config.getProperty("drools.indexPrecedence"));
    }

    @Test
    public void testAssertBehaviorConfiguration() {
        this.config.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
        Assert.assertEquals((Object)EqualityBehaviorOption.EQUALITY, (Object)this.config.getOption(EqualityBehaviorOption.class));
        Assert.assertEquals((Object)"equality", (Object)this.config.getProperty("drools.equalityBehavior"));
        this.config.setProperty("drools.equalityBehavior", "identity");
        Assert.assertEquals((Object)EqualityBehaviorOption.IDENTITY, (Object)this.config.getOption(EqualityBehaviorOption.class));
        Assert.assertEquals((Object)"identity", (Object)this.config.getProperty("drools.equalityBehavior"));
    }

    @Test
    public void testSequentialAgendaConfiguration() {
        this.config.setOption((KieBaseOption)SequentialAgendaOption.DYNAMIC);
        Assert.assertEquals((Object)SequentialAgendaOption.DYNAMIC, (Object)this.config.getOption(SequentialAgendaOption.class));
        Assert.assertEquals((Object)"dynamic", (Object)this.config.getProperty("drools.sequential.agenda"));
        this.config.setProperty("drools.sequential.agenda", "sequential");
        Assert.assertEquals((Object)SequentialAgendaOption.SEQUENTIAL, (Object)this.config.getOption(SequentialAgendaOption.class));
        Assert.assertEquals((Object)"sequential", (Object)this.config.getProperty("drools.sequential.agenda"));
    }

    @Test
    public void testAlphaThresholdConfiguration() {
        this.config.setOption((KieBaseOption)AlphaThresholdOption.get((int)5));
        Assert.assertEquals((Object)AlphaThresholdOption.get((int)5), (Object)this.config.getOption(AlphaThresholdOption.class));
        Assert.assertEquals((Object)"5", (Object)this.config.getProperty("drools.alphaNodeHashingThreshold"));
        this.config.setProperty("drools.alphaNodeHashingThreshold", "7");
        Assert.assertEquals((Object)AlphaThresholdOption.get((int)7), (Object)this.config.getOption(AlphaThresholdOption.class));
        Assert.assertEquals((Object)"7", (Object)this.config.getProperty("drools.alphaNodeHashingThreshold"));
    }

    @Test
    public void testAlphaRangeIndexThresholdConfiguration() {
        this.config.setOption((KieBaseOption)AlphaRangeIndexThresholdOption.get((int)5));
        Assert.assertEquals((Object)AlphaRangeIndexThresholdOption.get((int)5), (Object)this.config.getOption(AlphaRangeIndexThresholdOption.class));
        Assert.assertEquals((Object)"5", (Object)this.config.getProperty("drools.alphaNodeRangeIndexThreshold"));
        this.config.setProperty("drools.alphaNodeRangeIndexThreshold", "7");
        Assert.assertEquals((Object)AlphaRangeIndexThresholdOption.get((int)7), (Object)this.config.getOption(AlphaRangeIndexThresholdOption.class));
        Assert.assertEquals((Object)"7", (Object)this.config.getProperty("drools.alphaNodeRangeIndexThreshold"));
        this.config.setProperty("drools.alphaNodeRangeIndexThreshold", "");
        Assert.assertEquals((Object)AlphaRangeIndexThresholdOption.get((int)9), (Object)this.config.getOption(AlphaRangeIndexThresholdOption.class));
        Assert.assertEquals((Object)String.valueOf(9), (Object)this.config.getProperty("drools.alphaNodeRangeIndexThreshold"));
    }

    @Test
    public void testBetaRangeIndexenabledConfiguration() {
        this.config.setOption((KieBaseOption)BetaRangeIndexOption.ENABLED);
        Assert.assertEquals((Object)BetaRangeIndexOption.ENABLED, (Object)this.config.getOption(BetaRangeIndexOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.betaNodeRangeIndexEnabled"));
        this.config.setProperty("drools.betaNodeRangeIndexEnabled", "false");
        Assert.assertEquals((Object)BetaRangeIndexOption.DISABLED, (Object)this.config.getOption(BetaRangeIndexOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.betaNodeRangeIndexEnabled"));
    }

    @Test
    public void testPermGenThresholdConfiguration() {
        Assume.assumeTrue((String)"JVM with perm gen", (boolean)MemoryUtil.hasPermGen());
        this.config.setOption((KieBaseOption)PermGenThresholdOption.get((int)85));
        Assert.assertEquals((Object)PermGenThresholdOption.get((int)85), (Object)this.config.getOption(PermGenThresholdOption.class));
        Assert.assertEquals((Object)"85", (Object)this.config.getProperty("drools.permgenThreshold"));
        this.config.setProperty("drools.permgenThreshold", "87");
        Assert.assertEquals((Object)PermGenThresholdOption.get((int)87), (Object)this.config.getOption(PermGenThresholdOption.class));
        Assert.assertEquals((Object)"87", (Object)this.config.getProperty("drools.permgenThreshold"));
    }

    @Test
    public void testCompositeKeyDepthConfiguration() {
        this.config.setOption((KieBaseOption)CompositeKeyDepthOption.get((int)1));
        Assert.assertEquals((Object)CompositeKeyDepthOption.get((int)1), (Object)this.config.getOption(CompositeKeyDepthOption.class));
        Assert.assertEquals((Object)"1", (Object)this.config.getProperty("drools.compositeKeyDepth"));
        this.config.setProperty("drools.compositeKeyDepth", "2");
        Assert.assertEquals((Object)CompositeKeyDepthOption.get((int)2), (Object)this.config.getOption(CompositeKeyDepthOption.class));
        Assert.assertEquals((Object)"2", (Object)this.config.getProperty("drools.compositeKeyDepth"));
    }

    @Test
    public void testConsequenceExceptionHandlerConfiguration() {
        Class<DefaultConsequenceExceptionHandler> handler = DefaultConsequenceExceptionHandler.class;
        this.config.setOption((KieBaseOption)ConsequenceExceptionHandlerOption.get(handler));
        Assert.assertEquals((Object)ConsequenceExceptionHandlerOption.get(handler), (Object)this.config.getOption(ConsequenceExceptionHandlerOption.class));
        Assert.assertEquals((Object)handler.getName(), (Object)this.config.getProperty("drools.consequenceExceptionHandler"));
        this.config.setProperty("drools.consequenceExceptionHandler", handler.getName());
        Assert.assertEquals((Object)handler.getName(), (Object)((ConsequenceExceptionHandlerOption)this.config.getOption(ConsequenceExceptionHandlerOption.class)).getHandler().getName());
        Assert.assertEquals((Object)handler.getName(), (Object)this.config.getProperty("drools.consequenceExceptionHandler"));
    }

    @Test
    public void testEventProcessingConfiguration() {
        this.config.setOption((KieBaseOption)EventProcessingOption.STREAM);
        Assert.assertEquals((Object)EventProcessingOption.STREAM, (Object)this.config.getOption(EventProcessingOption.class));
        Assert.assertEquals((Object)"stream", (Object)this.config.getProperty("drools.eventProcessingMode"));
        this.config.setProperty("drools.eventProcessingMode", "cloud");
        Assert.assertEquals((Object)EventProcessingOption.CLOUD, (Object)this.config.getOption(EventProcessingOption.class));
        Assert.assertEquals((Object)"cloud", (Object)this.config.getProperty("drools.eventProcessingMode"));
    }

    @Test
    public void testMaxThreadsConfiguration() {
        this.config.setOption((KieBaseOption)MaxThreadsOption.get((int)5));
        Assert.assertEquals((Object)MaxThreadsOption.get((int)5), (Object)this.config.getOption(MaxThreadsOption.class));
        Assert.assertEquals((Object)"5", (Object)this.config.getProperty("drools.maxThreads"));
        this.config.setProperty("drools.maxThreads", "8");
        Assert.assertEquals((Object)MaxThreadsOption.get((int)8), (Object)this.config.getOption(MaxThreadsOption.class));
        Assert.assertEquals((Object)"8", (Object)this.config.getProperty("drools.maxThreads"));
    }

    @Test
    public void testMultithreadEvaluationConfiguration() {
        this.config.setOption((KieBaseOption)MultithreadEvaluationOption.YES);
        Assert.assertEquals((Object)MultithreadEvaluationOption.YES, (Object)this.config.getOption(MultithreadEvaluationOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.multithreadEvaluation"));
        this.config.setProperty("drools.multithreadEvaluation", "false");
        Assert.assertEquals((Object)MultithreadEvaluationOption.NO, (Object)this.config.getOption(MultithreadEvaluationOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.multithreadEvaluation"));
    }

    @Test
    public void testRulebaseSetUpdateHandler() {
        Assert.assertEquals((Object)"", (Object)this.config.getProperty("drools.ruleBaseUpdateHandler"));
        this.config.setProperty("drools.ruleBaseUpdateHandler", "somethingElse");
        Assert.assertEquals((Object)"somethingElse", (Object)this.config.getProperty("drools.ruleBaseUpdateHandler"));
        this.config.setProperty("drools.ruleBaseUpdateHandler", null);
        Assert.assertEquals((Object)"", (Object)this.config.getProperty("drools.ruleBaseUpdateHandler"));
        this.config.setProperty("drools.ruleBaseUpdateHandler", "");
        Assert.assertEquals((Object)"", (Object)this.config.getProperty("drools.ruleBaseUpdateHandler"));
    }
}

