/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.kie.util;

import java.util.ArrayList;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.util.ChangeSetBuilder;
import org.drools.compiler.kie.util.KieJarChangeSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;
import org.mockito.Mockito;

public class ChangeSetBuilderTest {
    @Test
    public void testNoChanges() {
        String drl1 = "package org.drools\nrule R1 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        String drl2 = "package org.drools\nrule R2 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        InternalKieModule kieJar1 = this.createKieJar(drl1, drl2);
        InternalKieModule kieJar2 = this.createKieJar(drl1, drl2);
        KieJarChangeSet changes = ChangeSetBuilder.build((InternalKieModule)kieJar1, (InternalKieModule)kieJar2);
        MatcherAssert.assertThat((Object)changes.getChanges().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testModified() {
        String drl1 = "package org.drools\nrule R1 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        String drl2 = "package org.drools\nrule R2 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        String drl3 = "package org.drools\nrule R3 when\n   $m : Message( message == \"Good bye World\" )\nthen\nend\n";
        InternalKieModule kieJar1 = this.createKieJar(drl1, drl2);
        InternalKieModule kieJar2 = this.createKieJar(drl1, drl3);
        KieJarChangeSet changes = ChangeSetBuilder.build((InternalKieModule)kieJar1, (InternalKieModule)kieJar2);
        String modifiedFile = (String)kieJar2.getFileNames().toArray()[1];
        MatcherAssert.assertThat((Object)changes.getChanges().size(), (Matcher)CoreMatchers.is((Object)1));
        ResourceChangeSet cs = (ResourceChangeSet)changes.getChanges().get(modifiedFile);
        MatcherAssert.assertThat((Object)cs, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)cs.getChangeType(), (Matcher)CoreMatchers.is((Object)ChangeType.UPDATED));
        MatcherAssert.assertThat((Object)cs.getChanges().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(cs.getChanges().get(1), (Matcher)CoreMatchers.is((Object)new ResourceChange(ChangeType.ADDED, ResourceChange.Type.RULE, "R3")));
        MatcherAssert.assertThat(cs.getChanges().get(0), (Matcher)CoreMatchers.is((Object)new ResourceChange(ChangeType.REMOVED, ResourceChange.Type.RULE, "R2")));
    }

    @Test
    public void testRemoved() {
        String drl1 = "package org.drools\nrule R1 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        String drl2 = "package org.drools\nrule R2 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        InternalKieModule kieJar1 = this.createKieJar(drl1, drl2);
        InternalKieModule kieJar2 = this.createKieJar(drl1);
        KieJarChangeSet changes = ChangeSetBuilder.build((InternalKieModule)kieJar1, (InternalKieModule)kieJar2);
        String removedFile = (String)kieJar1.getFileNames().toArray()[1];
        MatcherAssert.assertThat((Object)changes.getChanges().size(), (Matcher)CoreMatchers.is((Object)1));
        ResourceChangeSet cs = (ResourceChangeSet)changes.getChanges().get(removedFile);
        MatcherAssert.assertThat((Object)cs, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)cs.getChangeType(), (Matcher)CoreMatchers.is((Object)ChangeType.REMOVED));
    }

    @Test
    public void testModified2() {
        String drl1 = "package org.drools\nrule \"Rule 1\" when\n   $m : Message( message == \"Hello World\" )\nthen\nend\nrule \"An updated rule\" when\n   $m : Message( message == \"Hello World\" )\nthen\nend\nrule \"A removed rule\" when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        String drl1_5 = "package org.drools\nrule \"Rule 1\" when\n   $m : Message( message == \"Hello World\" )\nthen\nend\nrule \"An updated rule\" when\n   $m : Message( message == \"Good Bye World\" )\nthen\nend\nrule \"An added rule\" when\n   $m : Message( message == \"Good Bye World\" )\nthen\nend\n";
        String drl2 = "package org.drools\nrule \"This is the name of rule 3\" when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        String drl3 = "package org.drools\nrule \"Another dumb rule\" when\n   $m : Message( message == \"Good bye World\" )\nthen\nend\n";
        InternalKieModule kieJar1 = this.createKieJar(drl1, drl2);
        InternalKieModule kieJar2 = this.createKieJar(drl1_5, null, drl3);
        KieJarChangeSet changes = ChangeSetBuilder.build((InternalKieModule)kieJar1, (InternalKieModule)kieJar2);
        String modifiedFile = (String)kieJar2.getFileNames().toArray()[0];
        String addedFile = (String)kieJar2.getFileNames().toArray()[1];
        String removedFile = (String)kieJar1.getFileNames().toArray()[1];
        MatcherAssert.assertThat((Object)changes.getChanges().size(), (Matcher)CoreMatchers.is((Object)3));
        ResourceChangeSet cs = (ResourceChangeSet)changes.getChanges().get(removedFile);
        MatcherAssert.assertThat((Object)cs, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)cs.getChangeType(), (Matcher)CoreMatchers.is((Object)ChangeType.REMOVED));
        MatcherAssert.assertThat((Object)cs.getChanges().size(), (Matcher)CoreMatchers.is((Object)0));
        cs = (ResourceChangeSet)changes.getChanges().get(addedFile);
        MatcherAssert.assertThat((Object)cs, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)cs.getChangeType(), (Matcher)CoreMatchers.is((Object)ChangeType.ADDED));
        MatcherAssert.assertThat((Object)cs.getChanges().size(), (Matcher)CoreMatchers.is((Object)0));
        cs = (ResourceChangeSet)changes.getChanges().get(modifiedFile);
        MatcherAssert.assertThat((Object)cs, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)cs.getChangeType(), (Matcher)CoreMatchers.is((Object)ChangeType.UPDATED));
    }

    @Test
    public void testRuleRemoval() throws Exception {
        String drl1 = "package org.drools.mvel.compiler\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String drl2 = "rule R2 when\n   $m : Message( message == \"Hi Universe\" )\nthen\nend\n";
        String drl3 = "rule R3 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        InternalKieModule kieJar1 = this.createKieJar(drl1 + drl2 + drl3);
        InternalKieModule kieJar2 = this.createKieJar(drl1 + drl3);
        KieJarChangeSet changes = ChangeSetBuilder.build((InternalKieModule)kieJar1, (InternalKieModule)kieJar2);
        Assert.assertEquals((long)1L, (long)changes.getChanges().size());
        ResourceChangeSet rcs = (ResourceChangeSet)changes.getChanges().values().iterator().next();
        Assert.assertEquals((long)1L, (long)rcs.getChanges().size());
        Assert.assertEquals((Object)ChangeType.REMOVED, (Object)((ResourceChange)rcs.getChanges().get(0)).getChangeType());
    }

    private InternalKieModule createKieJar(String ... drls) {
        InternalKieModule kieJar = (InternalKieModule)Mockito.mock(InternalKieModule.class);
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "hello-world", "1.0");
        ArrayList<String> drlFs = new ArrayList<String>();
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            String fileName = "src/main/resources/org/pkg1/drlFile" + i + ".drl";
            drlFs.add(fileName);
            Mockito.when((Object)kieJar.getBytes(fileName)).thenReturn((Object)drls[i].getBytes());
        }
        Mockito.when((Object)kieJar.getBytes("META-INF/kmodule.xml")).thenReturn((Object)this.createKieProjectWithPackages(ks, releaseId).toXML().getBytes());
        Mockito.when((Object)kieJar.getFileNames()).thenReturn(drlFs);
        return kieJar;
    }

    private KieModuleModel createKieProjectWithPackages(KieServices ks, ReleaseId releaseId) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase1").setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM).addPackage("org.pkg1");
        KieSessionModel ksession1 = kieBaseModel1.newKieSessionModel("KSession1").setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.REALTIME);
        return kproj;
    }
}

