/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.drools.compiler.compiler.DRLFactory;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.lang.DRLParser;
import org.drools.compiler.lang.dsl.DefaultExpander;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class ErrorsParserTest {
    @Test
    public void testNotBindindShouldBarf() throws Exception {
        DRLParser parser = this.parseResource("not_with_binding_error.drl");
        parser.compilationUnit();
        Assert.assertTrue((boolean)parser.hasErrors());
    }

    @Test
    public void testExpanderErrorsAfterExpansion() throws Exception {
        String name = "expander_post_errors.dslr";
        DefaultExpander expander = new DefaultExpander();
        String expanded = expander.expand(this.getReader(name));
        DRLParser parser = this.parse(name, expanded);
        parser.compilationUnit();
        Assert.assertTrue((boolean)parser.hasErrors());
        Assert.assertEquals((long)1L, (long)parser.getErrors().size());
        DroolsParserException err = (DroolsParserException)((Object)parser.getErrors().get(0));
        Assert.assertEquals((long)6L, (long)err.getLineNumber());
    }

    @Test
    public void testInvalidSyntax_Catches() throws Exception {
        DRLParser parser = this.parseResource("invalid_syntax.drl");
        parser.compilationUnit();
        Assert.assertTrue((boolean)parser.hasErrors());
    }

    @Test
    public void testMultipleErrors() throws Exception {
        DRLParser parser = this.parseResource("multiple_errors.drl");
        parser.compilationUnit();
        Assert.assertTrue((boolean)parser.hasErrors());
        Assert.assertEquals((long)2L, (long)parser.getErrors().size());
    }

    @Test
    public void testPackageGarbage() throws Exception {
        DRLParser parser = this.parseResource("package_garbage.drl");
        parser.compilationUnit();
        Assert.assertTrue((boolean)parser.hasErrors());
    }

    @Test
    public void testEvalWithSemicolon() throws Exception {
        DRLParser parser = this.parseResource("eval_with_semicolon.drl");
        parser.compilationUnit();
        Assert.assertTrue((boolean)parser.hasErrors());
        Assert.assertEquals((long)1L, (long)parser.getErrorMessages().size());
        Assert.assertEquals((Object)"ERR 102", (Object)((DroolsParserException)((Object)parser.getErrors().get(0))).getErrorCode());
    }

    @Test
    public void testLexicalError() throws Exception {
        DRLParser parser = this.parseResource("lex_error.drl");
        parser.compilationUnit();
        Assert.assertTrue((boolean)parser.hasErrors());
    }

    @Test
    public void testTempleteError() throws Exception {
        DRLParser parser = this.parseResource("template_test_error.drl");
        parser.compilationUnit();
        Assert.assertTrue((boolean)parser.hasErrors());
    }

    @Test
    public void testErrorMessageForMisplacedParenthesis() throws Exception {
        DRLParser parser = this.parseResource("misplaced_parenthesis.drl");
        parser.compilationUnit();
        Assert.assertTrue((String)"Parser should have raised errors", (boolean)parser.hasErrors());
        Assert.assertEquals((long)1L, (long)parser.getErrors().size());
        Assert.assertEquals((Object)"ERR 102", (Object)((DroolsParserException)((Object)parser.getErrors().get(0))).getErrorCode());
    }

    @Test
    public void testNPEOnParser() throws Exception {
        DRLParser parser = this.parseResource("npe_on_parser.drl");
        parser.compilationUnit();
        Assert.assertTrue((String)"Parser should have raised errors", (boolean)parser.hasErrors());
        Assert.assertEquals((long)1L, (long)parser.getErrors().size());
        Assert.assertTrue((boolean)((DroolsParserException)((Object)parser.getErrors().get(0))).getErrorCode().equals("ERR 102"));
    }

    @Test
    public void testCommaMisuse() throws Exception {
        DRLParser parser = this.parseResource("comma_misuse.drl");
        try {
            parser.compilationUnit();
            Assert.assertTrue((String)"Parser should have raised errors", (boolean)parser.hasErrors());
        }
        catch (NullPointerException npe) {
            Assert.fail((String)"Should not raise NPE");
        }
    }

    private DRLParser parse(String source, String text) throws Exception {
        return DRLFactory.buildParser((String)text, (LanguageLevelOption)LanguageLevelOption.DRL5);
    }

    private Reader getReader(String name) throws Exception {
        InputStream in = this.getClass().getResourceAsStream(name);
        return new InputStreamReader(in);
    }

    private DRLParser parseResource(String name) throws Exception {
        Reader reader = this.getReader(name);
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return this.parse(name, text.toString());
    }
}

