/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.oopath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.drools.core.phreak.AbstractReactiveObject;
import org.drools.core.phreak.ReactiveSet;
import org.drools.mvel.compiler.TestUtil;
import org.drools.mvel.compiler.oopath.model.Adult;
import org.drools.mvel.compiler.oopath.model.Child;
import org.drools.mvel.compiler.oopath.model.Group;
import org.drools.mvel.compiler.oopath.model.Man;
import org.drools.mvel.compiler.oopath.model.Person;
import org.drools.mvel.compiler.oopath.model.TMDirectory;
import org.drools.mvel.compiler.oopath.model.TMFile;
import org.drools.mvel.compiler.oopath.model.TMFileSet;
import org.drools.mvel.compiler.oopath.model.TMFileWithParentObj;
import org.drools.mvel.compiler.oopath.model.Toy;
import org.drools.mvel.compiler.oopath.model.Woman;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.event.rule.DefaultRuleRuntimeEventListener;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class OOPathTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public OOPathTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testInvalidOOPath() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife.children/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        this.testInvalid("import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife.children/toys )\nthen\n  list.add( $toy.getName() );\nend\n");
    }

    @Test
    public void testInvalidOOPathProperty() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children/toys/wrongProperty )\nthen\n  list.add( $toy.getName() );\nend\n";
        this.testInvalid("import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children/toys/wrongProperty )\nthen\n  list.add( $toy.getName() );\nend\n");
    }

    private void testInvalid(String drl) {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testIndexedAccess() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[0]/toys[1] )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[0]/toys[1] )\nthen\n  list.add( $toy.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        Child debbie = new Child("Debbie", 11);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"ball"});
    }

    @Test
    public void testBackReferenceConstraint() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children/toys[ name.length == ../name.length ] )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children/toys[ name.length == ../name.length ] )\nthen\n  list.add( $toy.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Carl", 12);
        Child debbie = new Child("Debbie", 8);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        debbie.addToy(new Toy("guitar"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"ball", "guitar"});
    }

    @Test
    public void testPrimitives() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Adult( $x : /children[$y : age]/toys[$t : name] )\nthen\n  list.add( $x.getName() + \":\" + $y + \":\" + $t );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Adult( $x : /children[$y : age]/toys[$t : name] )\nthen\n  list.add( $x.getName() + \":\" + $y + \":\" + $t );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Man bob = new Man("Bob", 40);
        Child charles = new Child("Charles", 12);
        charles.addToy(new Toy("t1"));
        charles.addToy(new Toy("t2"));
        bob.addChild(charles);
        Child deb = new Child("Debbie", 8);
        deb.addToy(new Toy("t3"));
        deb.addToy(new Toy("t4"));
        bob.addChild(deb);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(4);
        Assert.assertEquals(Arrays.asList("t2:12:t2", "t1:12:t1", "t4:8:t4", "t3:8:t3"), list);
    }

    @Test
    public void testDoubleAdd() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  Group( $id: name, $p: /members[age >= 20] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  Group( $id: name, $p: /members[age >= 20] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        Group x = new Group("X");
        Group y = new Group("Y");
        ksession.insert((Object)x);
        ksession.insert((Object)y);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Bea"));
        Adult ada = new Adult("Ada", 20);
        Adult bea = new Adult("Bea", 20);
        x.addPerson(ada);
        x.addPerson(bea);
        y.addPerson(ada);
        y.addPerson(bea);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.Bea"));
        x.removePerson(ada);
        x.removePerson(bea);
        y.removePerson(ada);
        y.removePerson(bea);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Bea"));
    }

    @Test
    public void testDoubleRemove() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  Group( $id: name, $p: /members[age >= 20] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  Group( $id: name, $p: /members[age >= 20] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        Adult ada = new Adult("Ada", 20);
        Adult bea = new Adult("Bea", 20);
        Group x = new Group("X");
        Group y = new Group("Y");
        x.addPerson(ada);
        x.addPerson(bea);
        y.addPerson(ada);
        y.addPerson(bea);
        ksession.insert((Object)x);
        ksession.insert((Object)y);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.Bea"));
        x.removePerson(ada);
        x.removePerson(bea);
        y.removePerson(ada);
        y.removePerson(bea);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Bea"));
    }

    @Test
    public void testAddAllRemoveIdx() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  Group( $id: name, $p: /members[age >= 30] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  Group( $id: name, $p: /members[age >= 30] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        Group x = new Group("X");
        Group y = new Group("Y");
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Bea"));
        Adult ada = new Adult("Ada", 29);
        Adult bea = new Adult("Bea", 29);
        List<Person> bothList = Arrays.asList(new Person[]{ada, bea});
        x.getMembers().addAll(bothList);
        y.getMembers().addAll(bothList);
        ksession.insert((Object)x);
        ksession.insert((Object)y);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Bea"));
        ada.setAge(30);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Bea"));
        y.getMembers().remove(1);
        bea.setAge(30);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.Ada"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.Bea"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.Ada"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.Bea"));
    }

    @Test
    public void testMiscListMethods() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  TMDirectory( $id: name, $p: /files[size >= 100] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  TMDirectory( $id: name, $p: /files[size >= 100] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        TMDirectory x = new TMDirectory("X");
        TMDirectory y = new TMDirectory("Y");
        ksession.insert((Object)x);
        ksession.insert((Object)y);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        TMFile file0 = new TMFile("File0", 47);
        TMFile file1 = new TMFile("File1", 47);
        TMFile file2 = new TMFile("File2", 47);
        x.getFiles().add(file2);
        x.getFiles().addAll(0, Arrays.asList(file0, file1));
        y.getFiles().add(0, file2);
        y.getFiles().add(0, file0);
        y.getFiles().add(1, file1);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File2"));
        file0.setSize(999);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File2"));
        y.getFiles().remove(1);
        file1.setSize(999);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File2"));
        file2.setSize(999);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File2"));
        TMFile file0R = new TMFile("File0R", 999);
        x.getFiles().set(0, file0R);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0R"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File2"));
    }

    @Test
    public void testCollectionIteratorRemove() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  TMDirectory( $id: name, $p: /files[size >= 100] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  TMDirectory( $id: name, $p: /files[size >= 100] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        TMDirectory x = new TMDirectory("X");
        TMDirectory y = new TMDirectory("Y");
        TMFile file0 = new TMFile("File0", 999);
        TMFile file1 = new TMFile("File1", 999);
        TMFile file2 = new TMFile("File2", 999);
        x.getFiles().addAll(Arrays.asList(file0, file1, file2));
        y.getFiles().addAll(Arrays.asList(file0, file1, file2));
        ksession.insert((Object)x);
        ksession.insert((Object)y);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File2"));
        Iterator<TMFile> iterator = x.getFiles().iterator();
        iterator.next();
        iterator.remove();
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File2"));
        iterator.next();
        iterator.remove();
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File2"));
        iterator.next();
        iterator.remove();
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File2"));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testListIteratorRemove() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  TMDirectory( $id: name, $p: /files[size >= 100] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  TMDirectory( $id: name, $p: /files[size >= 100] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ksession.addEventListener((RuleRuntimeEventListener)new DefaultRuleRuntimeEventListener(){

            public void objectDeleted(ObjectDeletedEvent event) {
                System.out.println(event.getOldObject() + " -> _");
            }

            public void objectInserted(ObjectInsertedEvent event) {
                System.out.println("_ -> " + event.getObject());
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                System.out.println(event.getOldObject() + " -> " + event.getObject());
            }
        });
        TMDirectory x = new TMDirectory("X");
        TMDirectory y = new TMDirectory("Y");
        TMFile file0 = new TMFile("File0", 999);
        TMFile file1 = new TMFile("File1", 999);
        TMFile file2 = new TMFile("File2", 999);
        x.getFiles().addAll(Arrays.asList(file0, file1, file2));
        y.getFiles().addAll(Arrays.asList(file0, file1, file2));
        ksession.insert((Object)x);
        ksession.insert((Object)y);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File2"));
        ListIterator<TMFile> xIterator = x.getFiles().listIterator(1);
        ListIterator<TMFile> yIterator = y.getFiles().listIterator();
        xIterator.next();
        xIterator.remove();
        yIterator.next();
        yIterator.next();
        yIterator.next();
        yIterator.remove();
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File2"));
        Assert.assertTrue((boolean)xIterator.hasNext());
        Assert.assertTrue((boolean)xIterator.hasPrevious());
        Assert.assertFalse((boolean)yIterator.hasNext());
        Assert.assertTrue((boolean)yIterator.hasPrevious());
        xIterator.next();
        xIterator.remove();
        yIterator.previous();
        yIterator.remove();
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File2"));
        Assert.assertFalse((boolean)xIterator.hasNext());
        Assert.assertTrue((boolean)xIterator.hasPrevious());
        Assert.assertFalse((boolean)yIterator.hasNext());
        Assert.assertTrue((boolean)yIterator.hasPrevious());
        xIterator.previous();
        xIterator.remove();
        yIterator.previous();
        yIterator.remove();
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File2"));
        Assert.assertFalse((boolean)xIterator.hasNext());
        Assert.assertFalse((boolean)xIterator.hasPrevious());
        Assert.assertFalse((boolean)yIterator.hasNext());
        Assert.assertFalse((boolean)yIterator.hasPrevious());
    }

    @Test
    public void testListIteratorMisc() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  TMDirectory( $id: name, $p: /files[size >= 100] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  TMDirectory( $id: name, $p: /files[size >= 100] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ksession.addEventListener((RuleRuntimeEventListener)new DefaultRuleRuntimeEventListener(){

            public void objectDeleted(ObjectDeletedEvent event) {
                System.out.println(event.getOldObject() + " -> _");
            }

            public void objectInserted(ObjectInsertedEvent event) {
                System.out.println("_ -> " + event.getObject());
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                System.out.println(event.getOldObject() + " -> " + event.getObject());
            }
        });
        TMDirectory x = new TMDirectory("X");
        TMDirectory y = new TMDirectory("Y");
        ksession.insert((Object)x);
        ksession.insert((Object)y);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File2"));
        TMFile file0 = new TMFile("File0", 999);
        TMFile file1 = new TMFile("File1", 999);
        TMFile file2 = new TMFile("File2", 999);
        ListIterator<TMFile> xIterator = x.getFiles().listIterator();
        ListIterator<TMFile> yIterator = y.getFiles().listIterator();
        xIterator.add(file0);
        yIterator.add(file2);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File2"));
        xIterator.add(file1);
        yIterator.previous();
        yIterator.add(file1);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File2"));
        xIterator.add(file2);
        yIterator.previous();
        yIterator.add(file0);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File2"));
        System.out.println(x.getFiles());
        System.out.println(y.getFiles());
        xIterator.previous();
        xIterator.set(new TMFile("File2R", 999));
        yIterator.previous();
        yIterator.set(new TMFile("File0R", 999));
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File2R"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0R"));
    }

    @Test
    public void testRemoveIfSupport() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  TMDirectory( $id: name, $p: /files[size >= 100] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  TMDirectory( $id: name, $p: /files[size >= 100] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ksession.addEventListener((RuleRuntimeEventListener)new DefaultRuleRuntimeEventListener(){

            public void objectDeleted(ObjectDeletedEvent event) {
                System.out.println(event.getOldObject() + " -> _");
            }

            public void objectInserted(ObjectInsertedEvent event) {
                System.out.println("_ -> " + event.getObject());
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                System.out.println(event.getOldObject() + " -> " + event.getObject());
            }
        });
        TMDirectory x = new TMDirectory("X");
        TMDirectory y = new TMDirectory("Y");
        ksession.insert((Object)x);
        ksession.insert((Object)y);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File2"));
        TMFile file0 = new TMFile("File0", 1000);
        TMFile file1 = new TMFile("File1", 1001);
        TMFile file2 = new TMFile("File2", 1002);
        x.getFiles().addAll(Arrays.asList(file0, file1, file2));
        y.getFiles().addAll(Arrays.asList(file0, file1, file2));
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File2"));
        x.getFiles().removeIf(f -> f.getSize() % 2 == 0);
        y.getFiles().removeIf(f -> f.getSize() % 2 == 1);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File2"));
    }

    @Test
    public void testMiscSetMethods() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  TMFileSet( $id: name, $p: /files[size >= 100] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\n\nrule R2 when\n  TMFileSet( $id: name, $p: /files[size >= 100] )\nthen\n  insertLogical(      $id + \".\" + $p.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        TMFileSet x = new TMFileSet("X");
        TMFileSet y = new TMFileSet("Y");
        ksession.insert((Object)x);
        ksession.insert((Object)y);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        TMFile file0 = new TMFile("File0", 47);
        TMFile file1 = new TMFile("File1", 47);
        TMFile file2 = new TMFile("File2", 47);
        x.getFiles().add(file2);
        x.getFiles().addAll(Arrays.asList(file0, file1));
        y.getFiles().add(file2);
        y.getFiles().add(file0);
        y.getFiles().add(file1);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File2"));
        file0.setSize(999);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File2"));
        y.getFiles().remove((Object)file1);
        file1.setSize(999);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File2"));
        file2.setSize(999);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File0"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("X.File2"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File0"));
        Assert.assertFalse((boolean)this.factsCollection(ksession).contains("Y.File1"));
        Assert.assertTrue((boolean)this.factsCollection(ksession).contains("Y.File2"));
    }

    @Test
    public void testDeclarationOutsideOOPath() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.Set duplicateNames; \n\nrule DIFF_FILES_BUT_WITH_SAME_FILENAME when\n  $dir1 : TMFileSet( $ic1 : /files )\n  TMFileSet( this == $dir1, $ic2 : /files[name == $ic1.name], $ic2 != $ic1 )\nthen\n  duplicateNames.add( $ic1.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.Set duplicateNames; \n\nrule DIFF_FILES_BUT_WITH_SAME_FILENAME when\n  $dir1 : TMFileSet( $ic1 : /files )\n  TMFileSet( this == $dir1, $ic2 : /files[name == $ic1.name], $ic2 != $ic1 )\nthen\n  duplicateNames.add( $ic1.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        HashSet duplicateNames = new HashSet();
        ksession.setGlobal("duplicateNames", duplicateNames);
        TMFileSet x = new TMFileSet("X");
        TMFile file0 = new TMFile("File0", 47);
        TMFile file1 = new TMFile("File1", 47);
        TMFile file2 = new TMFile("File0", 47);
        x.getFiles().addAll(Arrays.asList(file0, file1, file2));
        ksession.insert((Object)x);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)duplicateNames.contains("File0"));
        Assert.assertFalse((boolean)duplicateNames.contains("File1"));
    }

    @Test
    public void testDereferencedDeclarationOutsideOOPath() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.Set duplicateNames; \n\nrule DIFF_FILES_BUT_WITH_SAME_FILENAME when\n  $dir1 : TMFileSet( $ic1 : /files )\n  TMFileSet( this == $dir1, $ic2 : /files[this != $ic1], $ic2.name == $ic1.name )\nthen\n  duplicateNames.add( $ic1.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.Set duplicateNames; \n\nrule DIFF_FILES_BUT_WITH_SAME_FILENAME when\n  $dir1 : TMFileSet( $ic1 : /files )\n  TMFileSet( this == $dir1, $ic2 : /files[this != $ic1], $ic2.name == $ic1.name )\nthen\n  duplicateNames.add( $ic1.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        HashSet duplicateNames = new HashSet();
        ksession.setGlobal("duplicateNames", duplicateNames);
        TMFileSet x = new TMFileSet("X");
        TMFile file0 = new TMFile("File0", 47);
        TMFile file1 = new TMFile("File1", 47);
        TMFile file2 = new TMFile("File0", 47);
        x.getFiles().addAll(Arrays.asList(file0, file1, file2));
        ksession.insert((Object)x);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)duplicateNames.contains("File0"));
        Assert.assertFalse((boolean)duplicateNames.contains("File1"));
    }

    @Test
    public void testDeclarationInsideOOPath() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.Set duplicateNames; \n\nrule DIFF_FILES_BUT_WITH_SAME_FILENAME when\n  $dir1 : TMFileSet( $ic1 : /files )\n  TMFileSet( this == $dir1, $ic2 : /files[name == $ic1.name, this != $ic1] )\nthen\n  duplicateNames.add( $ic1.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.Set duplicateNames; \n\nrule DIFF_FILES_BUT_WITH_SAME_FILENAME when\n  $dir1 : TMFileSet( $ic1 : /files )\n  TMFileSet( this == $dir1, $ic2 : /files[name == $ic1.name, this != $ic1] )\nthen\n  duplicateNames.add( $ic1.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        HashSet duplicateNames = new HashSet();
        ksession.setGlobal("duplicateNames", duplicateNames);
        TMFileSet x = new TMFileSet("X");
        TMFile file0 = new TMFile("File0", 47);
        TMFile file1 = new TMFile("File1", 47);
        TMFile file2 = new TMFile("File0", 47);
        x.getFiles().addAll(Arrays.asList(file0, file1, file2));
        ksession.insert((Object)x);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)duplicateNames.contains("File0"));
        Assert.assertFalse((boolean)duplicateNames.contains("File1"));
    }

    @Test
    public void testCompileErrorOnDoubleOOPathInPattern() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.Set duplicateNames; \n\nrule DIFF_FILES_BUT_WITH_SAME_FILENAME when\n  $dir1 : TMFileSet( $ic1 : /files, /files[name == $ic1.name, this != $ic1] )\nthen\n  duplicateNames.add( $ic1.getName() );\nend\n";
        TestUtil.assertDrlHasCompilationError("import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.Set duplicateNames; \n\nrule DIFF_FILES_BUT_WITH_SAME_FILENAME when\n  $dir1 : TMFileSet( $ic1 : /files, /files[name == $ic1.name, this != $ic1] )\nthen\n  duplicateNames.add( $ic1.getName() );\nend\n", 1, this.kieBaseTestConfiguration);
    }

    @Test
    public void testOOPathWithLocalDeclaration() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.Set duplicateNames; \n\nrule DIFF_FILES_BUT_WITH_SAME_FILENAME when\n  $ic1 : TMFileWithParentObj( $curName : name,\n                              $ic2: /parent#TMFileSet/files[name == $curName, this != $ic1 ] )\nthen\n  duplicateNames.add( $ic1.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.Set duplicateNames; \n\nrule DIFF_FILES_BUT_WITH_SAME_FILENAME when\n  $ic1 : TMFileWithParentObj( $curName : name,\n                              $ic2: /parent#TMFileSet/files[name == $curName, this != $ic1 ] )\nthen\n  duplicateNames.add( $ic1.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        HashSet duplicateNames = new HashSet();
        ksession.setGlobal("duplicateNames", duplicateNames);
        TMFileSet x = new TMFileSet("X");
        TMFileWithParentObj file0 = new TMFileWithParentObj(0L, "File0", 47, (Object)x);
        TMFileWithParentObj file1 = new TMFileWithParentObj(1L, "File1", 47, (Object)x);
        TMFileWithParentObj file2 = new TMFileWithParentObj(2L, "File0", 47, (Object)x);
        x.getFiles().addAll(Arrays.asList(file0, file1, file2));
        ksession.insert((Object)x);
        ksession.insert((Object)file0);
        ksession.insert((Object)file1);
        ksession.insert((Object)file2);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)duplicateNames.contains("File0"));
        Assert.assertFalse((boolean)duplicateNames.contains("File1"));
    }

    @Test
    public void testOOPathWithLocalInnerDeclaration() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nimport " + TMFileSetQuater.class.getCanonicalName() + ";\nglobal java.util.Set duplicateNames; \n\nrule DIFF_FILES_BUT_WITH_SAME_FILENAME when\n  $ic1 : TMFileWithParentObj( $curName : name, $curId : id, \n                               $ic2: /parent#TMFileSetQuater/files[name == $curName, id != $curId ] )\nthen\n  duplicateNames.add( $ic1.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        HashSet duplicateNames = new HashSet();
        ksession.setGlobal("duplicateNames", duplicateNames);
        TMFileSetQuater x = new TMFileSetQuater("X");
        TMFileWithParentObj file0 = new TMFileWithParentObj(0L, "File0", 47, (Object)x);
        TMFileWithParentObj file1 = new TMFileWithParentObj(1L, "File1", 47, (Object)x);
        TMFileWithParentObj file2 = new TMFileWithParentObj(2L, "File0", 47, (Object)x);
        x.getFiles().addAll(Arrays.asList(file0, file1, file2));
        ksession.insert((Object)x);
        ksession.insert((Object)file0);
        ksession.insert((Object)file1);
        ksession.insert((Object)file2);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)duplicateNames.contains("File0"));
        Assert.assertFalse((boolean)duplicateNames.contains("File1"));
    }

    private List<?> factsCollection(KieSession ksession) {
        ArrayList res = new ArrayList();
        res.addAll(ksession.getObjects());
        return res;
    }

    @Test
    public void testWith2Peers() {
        String header = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\n";
        String drl1 = "rule R1 when\n  Man( $m: /wife[age == 25] )\nthen\n  list.add($m.getName());\nend\n\n";
        String drl2 = "rule R2 when\n  Man( $m: /wife[age == 26] )\nthen\n  list.add($m.getName());\nend\n\n";
        String drl3 = "rule R3 when\n  Man( $m: /wife[age == 27] )\nthen\n  list.add($m.getName());\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{header + drl1 + drl2 + drl3});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Man bob = new Man("John", 25);
        bob.setWife(new Woman("Jane", 25));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Jane", list.get(0));
        list.clear();
        bob.getWife().setAge(26);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Jane", list.get(0));
        list.clear();
        bob.getWife().setAge(27);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Jane", list.get(0));
        list.clear();
        bob.getWife().setAge(28);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testWithExists() {
        String header = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\n";
        String drl1 = "rule R1 when\n  exists( Man( $m: /wife[age == 25] ) )\nthen\n  list.add(\"Found\");\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{header + drl1});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Man bob = new Man("John", 25);
        bob.setWife(new Woman("Jane", 25));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Found", list.get(0));
        list.clear();
    }

    @Test
    public void testNotReactivePeer() {
        String drl1 = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R1 when\n  not String()\n  $a : Man( name == \"Mario\" )\nthen\n  list.add(\"Found\");\n  insert($a.getName());\nend\n\nrule R2 when\n  not String()\n  $a : Man( $c: /children[age == 6], name == \"Mario\" )\nthen\n  list.add(\"Found\");\n  insert($a.getName());\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Man mario = new Man("Mario", 40);
        mario.addChild(new Child("Sofia", 6));
        ksession.insert((Object)mario);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testConstraintExternalToOopath() {
        String drl = "import " + Parent.class.getCanonicalName() + ";\nimport " + Son.class.getCanonicalName() + ";\nglobal java.util.List list\n\nrule R when\n  Parent( $child : /children, $child.name == \"joe\" )\nthen\n  list.add( $child.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Son joe = new Son("joe");
        Son jack = new Son("jack");
        Parent parent = new Parent(Arrays.asList(joe, jack));
        ksession.insert((Object)parent);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"joe", list.get(0));
    }

    public class Parent {
        private List<Son> children;

        public Parent(List<Son> children) {
            this.children = children;
        }

        public List<Son> getChildren() {
            return this.children;
        }

        public void setChildren(List<Son> children) {
            this.children = children;
        }
    }

    public class Son {
        private String name;

        public Son(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class TMFileSetQuater
    extends AbstractReactiveObject {
        private final String name;
        private final Set<TMFileWithParentObj> members = new ReactiveSet();

        public TMFileSetQuater(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Set<TMFileWithParentObj> getFiles() {
            return this.members;
        }
    }
}

