/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.concurrency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import org.assertj.core.api.Assertions;
import org.drools.mvel.integrationtests.concurrency.AbstractConcurrentTest;
import org.drools.mvel.integrationtests.facts.BeanA;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class SharedSessionParallelTest
extends AbstractConcurrentTest {
    @Parameterized.Parameters(name="Enforced jitting={0}, KieBase type={1}")
    public static List<Object[]> getTestParameters() {
        List<Boolean[]> baseParams = Arrays.asList({false}, {true});
        Collection kbParams = TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Boolean[] baseParam : baseParams) {
            for (Object[] kbParam : kbParams) {
                if (baseParam[0].booleanValue() && ((KieBaseTestConfiguration)kbParam[0]).isExecutableModel()) continue;
                params.add(new Object[]{baseParam[0], kbParam[0]});
            }
        }
        return params;
    }

    public SharedSessionParallelTest(boolean enforcedJitting, KieBaseTestConfiguration kieBaseTestConfiguration) {
        super(enforcedJitting, false, false, false, kieBaseTestConfiguration);
    }

    @Test(timeout=60000L)
    public void testNoExceptions() throws InterruptedException {
        String drl = "rule R1 when String() then end";
        int repetitions = 100;
        int numberOfObjects = 1000;
        int countOfThreads = 100;
        for (int i = 0; i < 100; ++i) {
            KieSession kieSession = this.getKieBase("rule R1 when String() then end").newKieSession();
            this.parallelTest(100, counter -> {
                try {
                    for (int j = 0; j < 1000; ++j) {
                        kieSession.insert((Object)"test_1000");
                    }
                    kieSession.fireAllRules();
                    return true;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
            kieSession.dispose();
        }
    }

    @Test(timeout=40000L)
    public void testCheckOneThreadOnly() throws InterruptedException {
        int threadCount = 100;
        List list = Collections.synchronizedList(new ArrayList());
        String drl = "import " + BeanA.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R1 when     BeanA($n : seed) then     list.add(\"\" + $n);end";
        KieSession kieSession = this.getKieBase(drl).newKieSession();
        CountDownLatch latch = new CountDownLatch(100);
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            kieSession.setGlobal("list", (Object)list);
            kieSession.insert((Object)new BeanA(counter));
            latch.countDown();
            if (counter == 0) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return false;
                }
                return kieSession.fireAllRules() == 100;
            }
            return true;
        };
        this.parallelTest(100, exec);
        kieSession.dispose();
        Assertions.assertThat(list).hasSize(100);
        for (int i = 0; i < 100; ++i) {
            Assertions.assertThat(list).contains((Object[])new String[]{"" + i});
        }
    }

    @Test(timeout=40000L)
    public void testCorrectFirings() throws InterruptedException {
        int threadCount = 100;
        String drl = "import " + BeanA.class.getCanonicalName() + ";\nglobal java.util.List globalList;\nrule R1 when     BeanA($n : seed) then     globalList.add(\"\" + $n);end";
        KieSession kieSession = this.getKieBase(drl).newKieSession();
        List list = Collections.synchronizedList(new ArrayList());
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            kieSession.setGlobal("globalList", (Object)list);
            kieSession.insert((Object)new BeanA(counter));
            kieSession.fireAllRules();
            return true;
        };
        this.parallelTest(100, exec);
        kieSession.dispose();
        this.checkList(100, list);
    }

    @Test(timeout=40000L)
    public void testCorrectFirings2() throws InterruptedException {
        int threadCount = 100;
        String drl = "import " + BeanA.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R1 when     BeanA($n : seed, seed == 0) then     list.add(\"\" + $n);end";
        KieSession kieSession = this.getKieBase(drl).newKieSession();
        List list = Collections.synchronizedList(new ArrayList());
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            kieSession.setGlobal("list", (Object)list);
            kieSession.insert((Object)new BeanA(counter % 2));
            kieSession.fireAllRules();
            return true;
        };
        this.parallelTest(100, exec);
        kieSession.dispose();
        Assertions.assertThat(list).contains((Object[])new String[]{"0"});
        Assertions.assertThat(list).doesNotContain((Object[])new String[]{"1"});
        int expectedListSize = 50;
        Assertions.assertThat(list).hasSize(50);
    }

    @Test(timeout=40000L)
    public void testLongRunningRule() throws InterruptedException {
        int threadCount = 100;
        int seed = 300;
        int objectCount = 1000;
        String longRunningDrl = "import " + BeanA.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule longRunning when     $bean : BeanA($n : seed, seed > " + 100 + ") then     modify($bean) { setSeed($n-1) };    list.add(\"\" + $bean.getSeed());end";
        String listDrl = "global java.util.List list2;\nrule listRule when     BeanA($n : seed, seed < 100) then     list2.add(\"\" + $n);end";
        KieSession kieSession = this.getKieBase(longRunningDrl, "global java.util.List list2;\nrule listRule when     BeanA($n : seed, seed < 100) then     list2.add(\"\" + $n);end").newKieSession();
        CyclicBarrier barrier = new CyclicBarrier(100);
        List list = Collections.synchronizedList(new ArrayList());
        List list2 = Collections.synchronizedList(new ArrayList());
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            try {
                if (counter == 0) {
                    kieSession.setGlobal("list", (Object)list);
                    kieSession.setGlobal("list2", (Object)list2);
                    kieSession.insert((Object)new BeanA(300));
                    barrier.await();
                    kieSession.fireAllRules();
                    return true;
                }
                barrier.await();
                for (int i = 0; i < 1000; ++i) {
                    kieSession.insert((Object)new BeanA(counter));
                }
                kieSession.fireAllRules();
                return true;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
        this.parallelTest(100, exec);
        kieSession.dispose();
        this.checkList(100, 300, list);
        this.checkList(1, 100, list2, 99000);
    }

    @Test(timeout=40000L)
    public void testLongRunningRule2() throws InterruptedException {
        int threadCount = 100;
        int seed = 1000;
        String waitingRule = "rule waitingRule when     String( this == \"wait\" ) then end";
        String longRunningDrl = "import " + BeanA.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule longRunning when     $bean : BeanA($n : seed, seed > 0 ) then     modify($bean) { setSeed($n-1) };    list.add(\"\" + $bean.getSeed());end";
        KieSession kieSession = this.getKieBase(longRunningDrl, "rule waitingRule when     String( this == \"wait\" ) then end").newKieSession();
        CyclicBarrier barrier = new CyclicBarrier(100);
        List list = Collections.synchronizedList(new ArrayList());
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            try {
                if (counter == 0) {
                    kieSession.setGlobal("list", (Object)list);
                    kieSession.insert((Object)"wait");
                    kieSession.insert((Object)new BeanA(1000));
                    barrier.await();
                    kieSession.fireAllRules();
                    return true;
                }
                barrier.await();
                kieSession.insert((Object)new BeanA(1000));
                kieSession.fireAllRules();
                return true;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
        this.parallelTest(100, exec);
        kieSession.dispose();
        this.checkList(0, 1000, list, 100000);
    }

    @Test(timeout=40000L)
    public void testLongRunningRule3() throws InterruptedException {
        int threadCount = 10;
        int seed = 60;
        int objectCount = 1000;
        String longRunningDrl = "import " + BeanA.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule longRunning when     $bean : BeanA($n : seed, seed > " + 10 + ") then     modify($bean) { setSeed($n-1) };    list.add(\"\" + $bean.getSeed());end";
        String listDrl = "global java.util.List list2;\nrule listRule when     BeanA($n : seed, seed < 10) then     list2.add(\"\" + $n);end";
        KieSession kieSession = this.getKieBase(longRunningDrl, "global java.util.List list2;\nrule listRule when     BeanA($n : seed, seed < 10) then     list2.add(\"\" + $n);end").newKieSession();
        CyclicBarrier barrier = new CyclicBarrier(10);
        List list = Collections.synchronizedList(new ArrayList());
        List list2 = Collections.synchronizedList(new ArrayList());
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            try {
                if (counter % 2 == 0) {
                    kieSession.setGlobal("list", (Object)list);
                    kieSession.setGlobal("list2", (Object)list2);
                    kieSession.insert((Object)new BeanA(60));
                    barrier.await();
                    kieSession.fireAllRules();
                    return true;
                }
                barrier.await();
                for (int i = 0; i < 1000; ++i) {
                    kieSession.insert((Object)new BeanA(counter));
                }
                kieSession.fireAllRules();
                return true;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
        this.parallelTest(10, exec);
        kieSession.dispose();
        int listExpectedSize = 250;
        int list2ExpectedSize = 5000;
        for (int i = 0; i < 10; ++i) {
            if (i % 2 != 1) continue;
            Assertions.assertThat(list2).contains((Object[])new String[]{"" + i});
        }
        Assertions.assertThat(list).hasSize(250);
        Assertions.assertThat(list2).hasSize(5000);
    }

    @Test(timeout=40000L)
    public void testCountdownBean() throws InterruptedException {
        int threadCount = 100;
        int seed = 1000;
        String drl = "import " + BeanA.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule countdown when     $bean : BeanA($n : seed, seed >  0 ) then     modify($bean) { setSeed($n-1) };    list.add(\"\" + $bean.getSeed());end";
        KieSession kieSession = this.getKieBase(drl).newKieSession();
        CyclicBarrier barrier = new CyclicBarrier(100);
        List list = Collections.synchronizedList(new ArrayList());
        BeanA bean = new BeanA(1000);
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            try {
                if (counter == 0) {
                    kieSession.setGlobal("list", (Object)list);
                    kieSession.insert((Object)bean);
                }
                barrier.await();
                kieSession.fireAllRules();
                return true;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
        this.parallelTest(100, exec);
        kieSession.dispose();
        this.checkList(1000, list);
        Assertions.assertThat((Object)bean).hasFieldOrPropertyWithValue("seed", (Object)0);
    }

    @Test(timeout=40000L)
    public void testCountdownBean2() throws InterruptedException {
        int threadCount = 100;
        int seed = 1000;
        String drl = "import " + BeanA.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule countdown when     $bean : BeanA($n : seed, seed >  0 ) then     modify($bean) { setSeed($n-1) };    list.add(\"\" + $bean.getSeed());end";
        KieSession kieSession = this.getKieBase(drl).newKieSession();
        List list = Collections.synchronizedList(new ArrayList());
        BeanA[] beans = new BeanA[100];
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            BeanA bean;
            beans[counter] = bean = new BeanA(1000);
            try {
                kieSession.setGlobal("list", (Object)list);
                kieSession.insert((Object)bean);
                kieSession.fireAllRules();
                return true;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
        this.parallelTest(100, exec);
        kieSession.dispose();
        this.checkList(0, 1000, list, 100000);
        for (BeanA bean : beans) {
            Assertions.assertThat((Object)bean).hasFieldOrPropertyWithValue("seed", (Object)0);
        }
    }

    @Test(timeout=60000L)
    public void testOneRulePerThread() throws InterruptedException {
        int threadCount = 1000;
        String[] drls = new String[1000];
        for (int i = 0; i < 1000; ++i) {
            drls[i] = "import " + BeanA.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R" + i + " when     $bean : BeanA( seed == " + i + " ) then     list.add(\"" + i + "\");end";
        }
        KieSession kieSession = this.getKieBase(drls).newKieSession();
        List list = Collections.synchronizedList(new ArrayList());
        AbstractConcurrentTest.TestExecutor exec = counter -> {
            kieSession.setGlobal("list", (Object)list);
            kieSession.insert((Object)new BeanA(counter));
            kieSession.fireAllRules();
            return true;
        };
        this.parallelTest(1000, exec);
        kieSession.dispose();
        this.checkList(1000, list);
    }

    private void checkList(int end, List list) {
        this.checkList(0, end, list);
    }

    private void checkList(int start, int end, List list) {
        int expectedSize = end - start;
        this.checkList(start, end, list, expectedSize);
    }

    private void checkList(int start, int end, List list, int expectedSize) {
        Assertions.assertThat((List)list).hasSize(expectedSize);
        for (int i = start; i < end; ++i) {
            Assertions.assertThat((List)list).contains(new Object[]{"" + i});
        }
    }
}

