/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class ExceptionTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ExceptionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReturnValueException() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + TestException.class.getCanonicalName() + ";\nimport " + Cheese.class.getCanonicalName() + ";\nfunction String throwException( ) {\n    throw new TestException( \"this should throw an exception\" );\n}\n\nrule \"Throw ReturnValue Exception\"\n    when\n        Cheese( type == ( throwException( ) ) )\n    then\n\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"exception-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Cheese brie = new Cheese("brie", 12);
            Assertions.assertThatThrownBy(() -> {
                ksession.insert((Object)brie);
                ksession.fireAllRules();
            }).hasRootCauseInstanceOf(TestException.class);
        }
        finally {
            ksession.dispose();
        }
    }

    public static class TestException
    extends RuntimeException {
        public TestException(String message) {
            super(message);
        }
    }
}

