/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.kie.builder;

import java.util.Collection;
import java.util.List;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;

@RunWith(value=Parameterized.class)
public class DslExpansionTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DslExpansionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testDSLExpansion_MessageImplNPE() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "dsl-test", "1.0");
        KieModuleModel kproj = ks.newKieModuleModel();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML()).writePomXML(KieBuilderImpl.generatePomXml((AFReleaseId)releaseId)).write("src/main/resources/KBase1/test-dsl.dsl", this.createDSL()).write("src/main/resources/KBase1/test-rule.dslr", this.createDRL());
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        List messages = kieBuilder.getResults().getMessages();
        if (!messages.isEmpty()) {
            for (Message m : messages) {
                System.out.println(m.getText());
            }
        }
        Assert.assertTrue((boolean)messages.isEmpty());
    }

    @Test
    public void testDSLExpansion_NoExpansion() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "dsl-test", "1.0");
        KieModuleModel kproj = ks.newKieModuleModel();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML()).writePomXML(KieBuilderImpl.generatePomXml((AFReleaseId)releaseId)).write("src/main/resources/KBase1/test-dsl.dsl", this.createDSL()).write("src/main/resources/KBase1/test-rule.drl", this.createDRL());
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        List messages = kieBuilder.getResults().getMessages();
        if (!messages.isEmpty()) {
            for (Message m : messages) {
                System.out.println(m.getText());
            }
        }
        Assert.assertFalse((boolean)messages.isEmpty());
    }

    private String createDSL() {
        return "[when]There is a smurf=Smurf()\n";
    }

    private String createDRL() {
        return "package org.kie.test\ndeclare Smurf\n    name : String\nend\nrule Smurfs\nwhen\n    There is a smurf\nthen\n    >System.out.println(\"Smurfs rock!\");\nend\n";
    }
}

