/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.kie.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.builder.model.ListenerModel;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class WireListenerTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final List<ObjectInsertedEvent> insertEvents = new ArrayList<ObjectInsertedEvent>();
    private static final List<ObjectUpdatedEvent> updateEvents = new ArrayList<ObjectUpdatedEvent>();
    private static final List<ObjectDeletedEvent> retractEvents = new ArrayList<ObjectDeletedEvent>();

    public WireListenerTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testWireListener() throws Exception {
        insertEvents.clear();
        updateEvents.clear();
        retractEvents.clear();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "listener-test", "1.0");
        this.build(ks, releaseId);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieSession ksession = kieContainer.newKieSession();
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)insertEvents.size());
        Assert.assertEquals((long)1L, (long)updateEvents.size());
        Assert.assertEquals((long)1L, (long)retractEvents.size());
    }

    private void build(KieServices ks, ReleaseId releaseId) throws IOException {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieSessionModel ksession1 = kproj.newKieBaseModel("KBase1").newKieSessionModel("KSession1").setDefault(true);
        ksession1.newListenerModel(RecordingWorkingMemoryEventListener.class.getName(), ListenerModel.Kind.RULE_RUNTIME_EVENT_LISTENER);
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML()).writePomXML(KieBuilderImpl.generatePomXml((AFReleaseId)releaseId)).write("src/main/resources/KBase1/rules.drl", this.createDRL());
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertTrue((boolean)kieBuilder.getResults().getMessages().isEmpty());
    }

    private String createDRL() {
        return "package org.kie.test\ndeclare Account\n    balance : int\nend\nrule OpenAccount when\nthen\n    insert( new Account(100) );\nend\nrule PayTaxes when\n    $account : Account( $balance : balance > 0 ) \nthen\n    modify( $account ) { setBalance( $balance - 200 ) }\nend\nrule CloseAccountWithNegeativeBalance when\n    $account : Account( balance < 0 ) \nthen\n    retract( $account );\nend\n";
    }

    public static class RecordingWorkingMemoryEventListener
    implements RuleRuntimeEventListener {
        public void objectInserted(ObjectInsertedEvent event) {
            insertEvents.add(event);
        }

        public void objectUpdated(ObjectUpdatedEvent event) {
            updateEvents.add(event);
        }

        public void objectDeleted(ObjectDeletedEvent event) {
            retractEvents.add(event);
        }
    }
}

