/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.model.AFact;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class ExistsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ExistsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExistsIterativeModifyBug() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + AFact.class.getCanonicalName() + "\nglobal java.util.List list \nrule xxx \nwhen \n  $f1 : AFact() \n    exists AFact(this != $f1, eval(field2 == $f1.getField2())) \n    eval( !$f1.getField1().equals(\"1\") ) \nthen \n  list.add($f1); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"exists-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            AFact a1 = new AFact("2", "2");
            AFact a2 = new AFact("1", "2");
            AFact a3 = new AFact("1", "2");
            FactHandle fa1 = ksession.insert((Object)a1);
            FactHandle fa2 = ksession.insert((Object)a2);
            FactHandle fa3 = ksession.insert((Object)a3);
            a1.setField2("1");
            ksession.update(fa1, (Object)a1);
            a1.setField2("2");
            ksession.update(fa1, (Object)a1);
            a2.setField2("1");
            ksession.update(fa2, (Object)a2);
            a2.setField2("2");
            ksession.update(fa2, (Object)a2);
            ksession.update(fa3, (Object)a3);
            a3.setField2("1");
            ksession.update(fa3, (Object)a3);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeSharingNotExists() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List results;\n\nrule rule1\nwhen\n       not Cheese( type == Cheese.STILTON )\nthen\n       results.add( \"rule1\" );\nend\n\nrule rule2\nwhen\n       exists Cheese( type == Cheese.STILTON )\nthen\n       results.add( \"rule2\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"exists-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)"rule1", list.get(0));
            ksession.insert((Object)new Cheese("stilton", 10));
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)"rule2", list.get(1));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastMemoryEntryExistsBug() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + AFact.class.getCanonicalName() + "\nglobal java.util.List list \nrule x1 \nwhen \n    $s : String( this == 'x1' ) \n    exists AFact( this != null ) \nthen \n  list.add(\"fired x1\"); \nend  \nrule x2 \nwhen \n    $s : String( this == 'x2' ) \n    exists AFact( field1 == $s, this != null ) \nthen \n  list.add(\"fired x2\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"exists-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"x1");
            ksession.insert((Object)"x2");
            AFact a1 = new AFact("x1", null);
            AFact a2 = new AFact("x2", null);
            FactHandle fa1 = ksession.insert((Object)a1);
            FactHandle fa2 = ksession.insert((Object)a2);
            ksession.update(fa1, (Object)a1);
            ksession.update(fa2, (Object)a2);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExistsWithOrAndSubnetwork() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nglobal java.util.List list \nrule \"Rule Result\" salience 100 when\n        exists (\n            String()\n            or ( Integer() and Long() )\n        )\n    then\n        list.add(\"ok\");\nend\n\nrule Init when\nthen\n    insert(\"test\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"exists-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.operators;\nglobal java.util.List list \nrule \"Rule Result\" salience 100 when\n        exists (\n            String()\n            or ( Integer() and Long() )\n        )\n    then\n        list.add(\"ok\");\nend\n\nrule Init when\nthen\n    insert(\"test\");\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)"ok", list.get(0));
        }
        finally {
            ksession.dispose();
        }
    }
}

