/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NodeMemories;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.spi.Tuple;
import org.drools.testcoverage.common.model.AFact;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class NotTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public NotTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastMemoryEntryNotBug() {
        String drl = "package org.drools.compiler.integrationtests.operators \nimport " + AFact.class.getCanonicalName() + "\nglobal java.util.List list \nrule x1 \nwhen \n    $s : String( this == 'x1' ) \n    not AFact( this != null ) \nthen \n  list.add(\"fired x1\"); \nend  \nrule x2 \nwhen \n    $s : String( this == 'x2' ) \n    not AFact( field1 == $s, this != null ) \nthen \n  list.add(\"fired x2\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"not-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"x1");
            ksession.insert((Object)"x2");
            AFact a1 = new AFact("x1", null);
            AFact a2 = new AFact("x2", null);
            FactHandle fa1 = ksession.insert((Object)a1);
            FactHandle fa2 = ksession.insert((Object)a2);
            ksession.update(fa1, (Object)a1);
            ksession.update(fa2, (Object)a2);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNegatedConstaintInNot() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\n\nrule R1 when\n    not( Person( !(age > 18) ) )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"negated-not-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Person("Mario", 45));
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingRootBlockerEquality() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nimport " + Cheese.class.getCanonicalName() + ";\n\nrule R1 when\n    Cheese($type : type)\n    not( Person( likes == $type, salary == null ) )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"not-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Cheese cheese = new Cheese("cheddar");
            Person p1 = new Person("John");
            p1.setLikes("cheddar");
            p1.setSalary(null);
            Person p2 = new Person("Paul");
            p2.setLikes("cheddar");
            p2.setSalary(null);
            Person p3 = new Person("George");
            p3.setLikes("cheddar");
            p3.setSalary(null);
            ksession.insert((Object)cheese);
            InternalFactHandle handle1 = (InternalFactHandle)ksession.insert((Object)p1);
            InternalFactHandle handle2 = (InternalFactHandle)ksession.insert((Object)p2);
            InternalFactHandle handle3 = (InternalFactHandle)ksession.insert((Object)p3);
            Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
            InternalFactHandle blockerHandle = this.getBlockerFactHandle(ksession);
            Person blockerFact = (Person)blockerHandle.getObject();
            blockerFact.setAge(40);
            ksession.update((FactHandle)blockerHandle, (Object)blockerFact, new String[]{"age"});
            Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
            blockerFact.setSalary(new BigDecimal(1000));
            ksession.update((FactHandle)blockerHandle, (Object)blockerFact, new String[]{"salary"});
            Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
            ArrayList<InternalFactHandle> handleList = new ArrayList<InternalFactHandle>();
            handleList.add(handle1);
            handleList.add(handle2);
            handleList.add(handle3);
            handleList.remove(blockerHandle);
            for (InternalFactHandle handle : handleList) {
                Person p = (Person)handle.getObject();
                p.setSalary(new BigDecimal(1000));
                ksession.update((FactHandle)handle, (Object)p, new String[]{"salary"});
            }
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    private InternalFactHandle getBlockerFactHandle(KieSession ksession) {
        ObjectTypeNode otn = NotTest.getObjectTypeNode(ksession.getKieBase(), Person.class);
        BetaNode notNode = (BetaNode)((AlphaNode)otn.getSinks()[0]).getSinks()[0];
        StatefulKnowledgeSessionImpl ksessionImpl = (StatefulKnowledgeSessionImpl)ksession;
        NodeMemories nodeMemories = ksessionImpl.getNodeMemories();
        BetaMemory betaMemory = (BetaMemory)nodeMemories.getNodeMemory((MemoryFactory)notNode, (InternalWorkingMemory)ksessionImpl);
        TupleMemory rightTupleMemory = betaMemory.getRightTupleMemory();
        Tuple[] tuples = (Tuple[])rightTupleMemory.toArray();
        for (int i = 0; i < tuples.length; ++i) {
            RightTupleImpl tuple = (RightTupleImpl)tuples[i];
            if (tuple.getBlocked() == null) continue;
            return tuple.getFactHandle();
        }
        Assert.fail((String)"Cannot find blocker in BetaMemory");
        return null;
    }

    public static ObjectTypeNode getObjectTypeNode(KieBase kbase, Class<?> nodeClass) {
        List nodes = ((KnowledgeBaseImpl)kbase).getRete().getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (n.getObjectType().getClassType() != nodeClass) continue;
            return n;
        }
        return null;
    }
}

