/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.command;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.PropagationList;
import org.drools.core.phreak.SynchronizedPropagationList;
import org.junit.Ignore;
import org.junit.Test;

public class PropagationListTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void test() {
        int OBJECT_NR = 1000000;
        int THREAD_NR = 8;
        ExecutorService executor = Executors.newFixedThreadPool(8, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        try {
            long[] results = new long[10];
            int counter = 0;
            while (counter < results.length) {
                int i;
                Checker checker = new Checker(8);
                SynchronizedPropagationList propagationList = new SynchronizedPropagationList(null);
                ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(executor);
                long start = System.nanoTime();
                for (i = 0; i < 8; ++i) {
                    ecs.submit(this.getTask(1000000, checker, (PropagationList)propagationList, i));
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                for (i = 0; i < 160; ++i) {
                    propagationList.flush();
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                boolean success = true;
                for (int i2 = 0; i2 < 8; ++i2) {
                    try {
                        success = (Boolean)ecs.take().get() != false && success;
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                propagationList.flush();
                results[counter++] = System.nanoTime() - start;
                System.out.println("Threads DONE!");
            }
            this.analyzeResults(results);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void analyzeResults(long[] results) {
        long min = results[0];
        long max = results[0];
        long total = results[0];
        for (long result : results) {
            if (result < min) {
                min = result;
            }
            if (result > max) {
                max = result;
            }
            total += result;
        }
        System.out.println("min = " + min);
        System.out.println("max = " + max);
        System.out.println("avg = " + (total - min - max) / (long)(results.length - 2));
    }

    private Callable<Boolean> getTask(final int OBJECT_NR, final Checker checker, final PropagationList propagationList, final int i) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                for (int j = 0; j < OBJECT_NR; ++j) {
                    propagationList.addEntry((PropagationEntry)new TestEntry(checker, i, j));
                }
                return true;
            }
        };
    }

    public static class Checker {
        private final int[] counters;

        public Checker(int nr) {
            this.counters = new int[nr];
        }

        public void check(TestEntry entry) {
            if (this.counters[entry.i] == entry.j) {
                if (entry.j % 10000 == 0) {
                    // empty if block
                }
            } else {
                throw new RuntimeException("ERROR for thread " + entry.i + " expected " + this.counters[entry.i] + " but was " + entry.j);
            }
            int n = entry.i;
            this.counters[n] = this.counters[n] + 1;
        }
    }

    public static class TestEntry
    extends PropagationEntry.AbstractPropagationEntry {
        final Checker checker;
        final int i;
        final int j;

        public TestEntry(Checker checker, int i, int j) {
            this.checker = checker;
            this.i = i;
            this.j = j;
        }

        public void execute(InternalWorkingMemory wm) {
            this.checker.check(this);
        }

        public String toString() {
            return "[" + this.i + ", " + this.j + "]";
        }
    }
}

