/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.StockTick;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class NamedConsequencesTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public NamedConsequencesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testNamedConsequences() {
        List<String> results = this.executeTestWithCondition("do[t1]");
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("cheddar"));
        Assert.assertTrue((boolean)results.contains("stilton"));
    }

    private List<String> executeTestWithCondition(String conditionElement) {
        String drl = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    " + conditionElement + "\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.getType() );\nthen[t1]\n    results.add( $a.getType() );\nend\n";
        return this.executeTestWithDRL(drl);
    }

    private List<String> executeTestWithDRL(String drl) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList<String> results = new ArrayList<String>();
        ksession.setGlobal("results", results);
        Cheese stilton = new Cheese("stilton", 5);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese brie = new Cheese("brie", 5);
        ksession.insert((Object)stilton);
        ksession.insert((Object)cheddar);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        return results;
    }

    @Test
    public void testNonCompilingBreakingConsequences() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    break[t1]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.getType() );\nthen[t1]\n    results.add( $a.getType() );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testNonCompilingDuplicatedNamedConsequence() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    do[t1]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.getType() );\nthen[t1]\n    results.add( $a.getType() );\nthen[t1]\n    results.add( $a.getType() );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testOutOfScopeNamedConsequences() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    do[t1]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.getType() );\nthen[t1]\n    results.add( $b.getType() );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testAllowedIfDo() {
        List<String> results = this.executeTestWithCondition("if ( price < 10 ) do[t1]");
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("cheddar"));
        Assert.assertTrue((boolean)results.contains("stilton"));
    }

    @Test
    public void testNotAllowedIfDo() {
        List<String> results = this.executeTestWithCondition("if ( price > 10 ) do[t1]");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("cheddar"));
    }

    @Test
    public void testAllowedIfBreak() {
        List<String> results = this.executeTestWithCondition("if ( price < 10 ) break[t1]");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("stilton"));
    }

    @Test
    public void testNotAllowedIfBreak() {
        List<String> results = this.executeTestWithCondition("if ( price > 10 ) break[t1]");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("cheddar"));
    }

    @Test
    public void testNamedConsequencesOutsideOR() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    ( $a: Cheese ( type == \"stilton\" )\n    or\n    $a: Cheese ( type == \"gorgonzola\" ) )\n    do[t1]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.getType() );\nthen[t1]\n    results.add( $a.getType() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("cheddar"));
        Assert.assertTrue((boolean)results.contains("stilton"));
    }

    @Ignore(value="Moved to EdgeCaseNonExecModelTest")
    @Test
    public void testNamedConsequencesInsideOR1() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    ( $a: Cheese ( type == \"stilton\" ) do[t1]\n    or\n    $b: Cheese ( type == \"gorgonzola\" ) )\n    $c: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $c.getType() );\nthen[t1]\n    results.add( $a.getType() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("cheddar"));
        Assert.assertTrue((boolean)results.contains("stilton"));
    }

    @Ignore(value="Moved to EdgeCaseNonExecModelTest")
    @Test
    public void testNamedConsequencesInsideOR2() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    ( $a: Cheese ( type == \"stilton\" )\n    or\n    $b: Cheese ( type == \"gorgonzola\" ) do[t1] )\n    $c: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $c.getType() );\nthen[t1]\n    results.add( $b.getType() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("cheddar"));
    }

    @Test
    public void testOutOfScopeNamedConsequencesWithOr1() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    ( $a: Cheese ( type == \"stilton\" )\n    or\n    $b: Cheese ( type == \"gorgonzola\" ) do[t1] )\n    $c: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $c.getType() );\nthen[t1]\n    results.add( $a.getType() );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testOutOfScopeNamedConsequencesWithOr2() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    ( $a: Cheese ( type == \"stilton\" )\n    or\n    $b: Cheese ( type == \"gorgonzola\" ) do[t1] )\n    $c: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $c.getType() );\nthen[t1]\n    results.add( $c.getType() );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testNonCompilingIFAfterOR() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    ( $a: Cheese ( type == \"stilton\" )\n    or\n    $a: Cheese ( type == \"gorgonzola\" ) )\n    if ( price > 10 ) do[t1]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.getType() );\nthen[t1]\n    results.add( $a.getType() );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testIfElse1() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    if ( price > 10 ) do[t1] else do[t2]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.getType() );\nthen[t1]\n    results.add( $a.getType() );\nthen[t2]\n    results.add( $a.getType().toUpperCase() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("cheddar"));
        Assert.assertTrue((boolean)results.contains("STILTON"));
    }

    @Test
    public void testIfElseWithConstant() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    if ( price > Cheese.BASE_PRICE ) do[t1] else do[t2]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.getType() );\nthen[t1]\n    results.add( $a.getType() );\nthen[t2]\n    results.add( $a.getType().toUpperCase() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("cheddar"));
        Assert.assertTrue((boolean)results.contains("STILTON"));
    }

    @Test
    public void testIfElseWithMvelAccessor() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 dialect \"mvel\" when\n    $a: Cheese ( type == \"stilton\" )\n    if ( $a.price > Cheese.BASE_PRICE ) do[t1] else do[t2]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.getType() );\nthen[t1]\n    results.add( $a.getType() );\nthen[t2]\n    results.add( $a.getType().toUpperCase() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("cheddar"));
        Assert.assertTrue((boolean)results.contains("STILTON"));
    }

    @Test
    public void testIfElse2() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    if ( price < 10 ) do[t1] else do[t2]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.getType() );\nthen[t2]\n    results.add( $a.getType() );\nthen[t1]\n    results.add( $a.getType().toUpperCase() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("cheddar"));
        Assert.assertTrue((boolean)results.contains("STILTON"));
    }

    @Test
    public void testIfElseBreak() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    if ( price > 10 ) do[t1] else break[t2]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.getType() );\nthen[t1]\n    results.add( $a.getType() );\nthen[t2]\n    results.add( $a.getType().toUpperCase() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("STILTON"));
    }

    @Test
    public void testNestedIfElseBreak() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    if ( type.startsWith(\"a\") ) do[t0] else if ( price > 10 ) do[t1] else break[t2]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.getType() );\nthen[t0]\n    results.add( \"WRONG!\" );\nthen[t1]\n    results.add( $a.getType() );\nthen[t2]\n    results.add( $a.getType().toUpperCase() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("STILTON"));
    }

    @Test
    public void testIfWithModify() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    if ( price > 10 ) break[t1]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    modify( $a ) { setPrice(15) };\nthen[t1]\n    results.add( $a.getType() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("stilton"));
    }

    @Test
    public void testEndlessIfWithModify() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    if ( price > 10 ) do[t1]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    modify( $a ) { setPrice(15) };\n    results.add( \"modify\" );\n    if (results.size() > 10) throw new RuntimeException();\nthen[t1]\n    results.add( $a.getType() );\n    if (results.size() > 10) throw new RuntimeException();\nend\n";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeTestWithDRL(str)).isInstanceOf(RuntimeException.class)).hasMessageContaining("Exception executing consequence for rule \"R1\"");
    }

    @Test
    public void testIfWithModify2() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    if ( price < 10 ) break[t1]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $a.getType() );\nthen[t1]\n    modify( $a ) { setPrice(15) };\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("stilton"));
    }

    @Test
    public void testIfWithModify3() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\", price < 10 )\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    modify( $a ) { setPrice(15) };\nend\nrule R2 when\n    $a: Cheese ( type == \"stilton\" )\n    if ( price > 10 ) break[t1]\n    $b: Cheese ( type == \"cheddar\" )\nthen\nthen[t1]\n    results.add( $a.getType() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("stilton"));
    }

    @Test
    public void testIfElseWithModify() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    if ( price < 10 ) do[t1] else break[t2]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    modify( $a ) { setPrice(15) };\nthen[t1]\n    results.add( $a.getType() );\nthen[t2]\n    results.add( $a.getType().toUpperCase() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("STILTON"));
    }

    @Test
    public void testEndlessIfElseWithModify() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    if ( price < 10 ) do[t1] else do[t2]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    modify( $a ) { setPrice(15) };\n    results.add( \"modify\" );\n    if (results.size() > 10) throw new RuntimeException();\nthen[t1]\n    results.add( $a.getType() );\nthen[t2]\n    results.add( $a.getType().toUpperCase() );\n    if (results.size() > 10) throw new RuntimeException();\nend\n";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeTestWithDRL(str)).isInstanceOf(RuntimeException.class)).hasMessageContaining("Exception executing consequence for rule \"R1\"");
    }

    @Test
    public void testNamedConsequenceAfterNotPattern() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( type == \"stilton\" )\n    not Cheese ( type == \"brie\" )\n    do[t1]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.getType() );\nthen[t1]\n    results.add( $a.getType() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton", 5));
        ksession.insert((Object)new Cheese("cheddar", 7));
        ksession.fireAllRules();
        Assert.assertTrue((boolean)results.contains("stilton"));
        Assert.assertTrue((boolean)results.contains("cheddar"));
    }

    @Test
    public void testMultipleIfAfterEval() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 when\n    $a: Cheese ( )\n    eval( $a.getType().equals(\"stilton\") )\n    if ( $a.getPrice() > 10 ) do[t1]\n    if ( $a.getPrice() < 10 ) do[t2]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.getType() );\nthen[t1]\n    results.add( $a.getType().toUpperCase() );\nthen[t2]\n    results.add( $a.getType() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("cheddar"));
        Assert.assertTrue((boolean)results.contains("stilton"));
    }

    @Test
    public void testMultipleIfElseInARow() {
        String str = "global java.util.List results;declare UnBlocker end \n\ndeclare Car\n  colour\t: String \n  price \t: int\n  horsepower \t: int\n  abs \t\t: boolean\nend\n\nrule \"Init\" \nwhen \nthen \n  insert( \n\tnew Car( \"red\", 1200, 170, true ) \n  ); \nend\n\nrule \"Car\" \nwhen \n  $car: Car( abs == true ) \n  if ( colour == \"red\" ) do[red]   else if ( colour != \"red\" ) do[notRed]\n  if ( price < 1000 ) do[cheap]   else do[notCheap]\n UnBlocker() \nthen\n  results.add( \"Found a Car\" ); \nthen[red]\n  results.add( \"Car is red\" );   insert( new UnBlocker() ); \nthen[notRed]\n  results.add( \"Car is NOT red\" ); \nthen[cheap]\n  results.add( \"Car is cheap\" ); \nthen[notCheap]\n  results.add( \"Car is NOT cheap\" ); \nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("Found a Car"));
        Assert.assertTrue((boolean)results.contains("Car is red"));
        Assert.assertTrue((boolean)results.contains("Car is NOT cheap"));
    }

    @Test
    public void testDynamicSalience() {
        String str = "import " + Fact.class.getCanonicalName() + ";\nglobal java.util.List results;\nrule R1 salience( -$id ) when\n    fact : Fact( status == Fact.Status.UNKNOWN, $id : id)\n    count : Long() from accumulate ( $s:Fact(this != fact, status==Fact.Status.NO, id < fact.id), count( $s ) )    if (count.intValue() > 1) break[yes]\nthen\n    results.add(\"n\" + $id);    fact.setStatus(Fact.Status.NO);\n    update(fact);\nthen[yes]\n    results.add(\"y\" + $id);    fact.setStatus(Fact.Status.YES);\n    update(fact);\nend\n    \nrule R2 salience 1 when\n    fact : Fact( status == Fact.Status.NO, $id : id )\n    Fact( status == Fact.Status.YES, id > $id )\nthen\n    delete(fact);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        for (int i = 1; i < 7; ++i) {
            ksession.insert((Object)new Fact(i));
        }
        ksession.fireAllRules();
        Assert.assertEquals(Arrays.asList("n1", "n2", "y3", "n4", "n5", "y6"), results);
    }

    @Test
    public void testNamedConsequenceOnEvents() {
        String drl = "import " + StockTick.class.getCanonicalName() + ";\nglobal java.util.List list;\ndeclare StockTick \n    @role( event )    @timestamp( time )\nend\nrule R when\n    $s1 : StockTick( company == \"XXX\" )\n    $s2 : StockTick( price > $s1.price ) do[t1]\n    $s3 : StockTick( price < $s1.price )\nthen\n    list.add( \"t0:\" + $s3.getCompany() );\nthen[t1]\n    list.add( \"t1:\" + $s2.getCompany() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new StockTick(1L, "XXX", 10.0, 0L));
        ksession.insert((Object)new StockTick(2L, "YYY", 15.0, 1L));
        ksession.insert((Object)new StockTick(3L, "ZZZ", 5.0, 2L));
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList("t1:YYY", "t0:ZZZ")));
    }

    @Test(timeout=10000L)
    public void testNoLoop() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R no-loop when\n    $p1 : Person( name == \"Mario\" ) do[t1]\n    $p2 : Person( age > $p1.age )\nthen\n    list.add(\"t0\");\n    modify($p2) { setAge(30); }\nthen[t1]\n    list.add(\"t1\");\n    modify($p1) { setAge(35); }\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALLOWED");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person mario = new Person("Mario", 40);
        Person mark = new Person("Mark", 37);
        ksession.insert((Object)mario);
        ksession.insert((Object)mark);
        ksession.fireAllRules();
        Assert.assertEquals((long)35L, (long)mario.getAge());
        Assert.assertEquals((long)30L, (long)mark.getAge());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"t1", list.get(0));
        Assert.assertEquals((Object)"t0", list.get(1));
    }

    @Test
    public void testMVELBreak() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 dialect \"mvel\" when\n    $a: Cheese ( type == \"stilton\" )\n    $b: Cheese ( type == \"cheddar\" )\n    if ( 200 < 400 ) break[t1]\nthen\n    results.add( $b.type );\nthen[t1]\n    results.add( $a.type.toUpperCase() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        System.out.println(results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("STILTON"));
    }

    @Test
    public void testMVELNoBreak() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 dialect \"mvel\" when\n    $a: Cheese ( type == \"stilton\" )\n    $b: Cheese ( type == \"cheddar\" )\n    if ( 200 > 400 ) break[t1]\nthen\n    results.add( $b.type );\nthen[t1]\n    results.add( $a.type.toUpperCase() );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        System.out.println(results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("cheddar"));
    }

    @Test
    public void testMvelInsertWithNamedConsequence() {
        String drl2 = "package org.drools.compiler\nglobal java.util.concurrent.atomic.AtomicInteger counter\ndeclare Output\n    feedback: String\nend\nrule \"Move to next\" dialect \"mvel\"\n   when\n          $i: Integer()\n          if ($i == 1) break[nextStep1]\n   then\n           insert(new Output(\"defualt\"));\n   then[nextStep1]\n           insert(new Output(\"step 1\"));\nend\n\nrule \"Produce output\"\n    when\n        $output: Output()\n    then\n        System.out.println($output);\n        retract($output);        counter.incrementAndGet();\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        KieSession kSession = kbase.newKieSession();
        AtomicInteger counter = new AtomicInteger(0);
        kSession.setGlobal("counter", (Object)counter);
        FactHandle messageHandle = kSession.insert((Object)1);
        kSession.fireAllRules();
        kSession.delete(messageHandle);
        kSession.insert((Object)2);
        kSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)counter.get());
    }

    @Test
    public void testDeleteWithBreakingBranch() throws Exception {
        String drl = "global java.util.List list;\nrule R when\n  Integer()\n  if (true) break[branch]\n  not Integer()\nthen\n  list.add(\"main\");\nthen[branch]\n  list.add(\"branch\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle fh = ksession.insert((Object)1);
        ksession.fireAllRules();
        ksession.delete(fh);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"branch", list.get(0));
    }

    @Test
    public void testQueryWithBreakingBranch() throws Exception {
        String drl = "import " + ListHolder.class.getCanonicalName() + ";\nquery q(ListHolder $listHolder)\n    $listHolder := ListHolder()\n    $i : Integer()\nend\n\nrule R when\n    q($listHolder;)\n    $s : String() from $listHolder.list\n    if (1==2) break[branch]\nthen\n    $listHolder.getList().add(\"ok\");\nthen[branch]\n    $listHolder.getList().add(\"ko\");\nend\n\nrule Init when then insert(1); end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList<String> list = new ArrayList<String>();
        list.add("test");
        ksession.insert((Object)new ListHolder(list));
        ksession.fireAllRules();
        Assert.assertEquals((Object)"ok", list.get(1));
    }

    @Test
    public void testInheritance() {
        String str = "dialect \"mvel\"\nimport org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R0 when\n    $a: Cheese ( )\nthen\nend\n\nrule R1 extends R0 when\n    eval( $a.getType().equals(\"stilton\") )\n    if ( $a.getPrice() > 10 ) do[t1]\n    if ( $a.getPrice() < 10 ) do[t2]\n    $b: Cheese ( type == \"cheddar\" )\nthen\n    results.add( $b.type );\nthen[t1]\n    results.add( $a.type.toUpperCase() );\nthen[t2]\n    results.add( $a.type );\nend\n";
        List<String> results = this.executeTestWithDRL(str);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("cheddar"));
        Assert.assertTrue((boolean)results.contains("stilton"));
    }

    @Test
    public void testWrongConsequenceName() {
        String str = "import org.drools.mvel.compiler.Cheese;\n global java.util.List results;\n\nrule R1 dialect \"mvel\" when\n    $a: Cheese ( type == \"stilton\" )\n    $b: Cheese ( type == \"cheddar\" )\n    if ( 200 < 400 ) break[t2]\nthen\n    results.add( $b.getType() );\nthen[t1]\n    results.add( $a.getType().toUpperCase() );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    public static class ListHolder {
        private final List<String> list;

        public ListHolder(List<String> list) {
            this.list = list;
        }

        public List<String> getList() {
            return this.list;
        }
    }

    public static class Fact {
        private final int id;
        private Status status = Status.UNKNOWN;

        public Fact(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public static enum Status {
            UNKNOWN,
            NO,
            YES;

        }
    }
}

