/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.List;
import org.drools.core.WorkingMemory;
import org.drools.core.audit.WorkingMemoryFileLogger;
import org.drools.core.audit.WorkingMemoryInMemoryLogger;
import org.drools.core.audit.event.ActivationLogEvent;
import org.drools.core.audit.event.LogEvent;
import org.drools.core.event.ProcessNodeLeftEventImpl;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Message;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.WorkflowProcessInstance;

@RunWith(value=Parameterized.class)
public class WorkingMemoryLoggerTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public WorkingMemoryLoggerTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testOutOfMemory() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"empty.drl"});
        for (int i = 0; i < 10000; ++i) {
            KieSession session = kbase.newKieSession();
            WorkingMemoryFileLogger logger = new WorkingMemoryFileLogger((WorkingMemory)session);
            session.fireAllRules();
            session.dispose();
        }
    }

    @Test
    public void testLogAllBoundVariables() throws Exception {
        String drl = "import " + Message.class.getCanonicalName() + "\nrule \"Hello World\" no-loop\n    when\n        $messageInstance : Message( $myMessage : message )\n    then\n        update($messageInstance);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        WorkingMemoryInMemoryLogger logger = new WorkingMemoryInMemoryLogger((WorkingMemory)ksession);
        Message message = new Message();
        message.setMessage("Hello World");
        ksession.insert((Object)message);
        ksession.fireAllRules();
        for (LogEvent logEvent : logger.getLogEvents()) {
            if (!(logEvent instanceof ActivationLogEvent)) continue;
            Assert.assertTrue((boolean)((ActivationLogEvent)logEvent).getDeclarations().contains("$messageInstance"));
            Assert.assertTrue((boolean)((ActivationLogEvent)logEvent).getDeclarations().contains("$myMessage"));
        }
    }

    @Test
    public void testRetraction() throws Exception {
        String drl = "import " + AnyType.class.getCanonicalName() + ";\nrule \"retract\" when\n    $any : AnyType( $typeId :typeId, typeName in (\"Standard\", \"Extended\") )\n    $any_c1 : AnyType( typeId == $typeId, typeName not in (\"Standard\", \"Extended\") ) \r\nthen\n    delete($any);\n    $any.setTypeId(null);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        WorkingMemoryInMemoryLogger logger = new WorkingMemoryInMemoryLogger((WorkingMemory)ksession);
        ksession.insert((Object)new AnyType(1, "Standard"));
        ksession.insert((Object)new AnyType(1, "Extended"));
        ksession.insert((Object)new AnyType(1, "test"));
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testWorkingMemoryLoggerWithUnbalancedBranches() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Logger.drl"});
        KieSession wm = kbase.newKieSession();
        try {
            wm.fireAllRules();
            wm.insert((Object)new Cheese("a", 10));
            wm.insert((Object)new Cheese("b", 11));
            wm.fireAllRules();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"No exception should be raised ");
        }
    }

    @Test
    public void testLogEvents() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        KieSession ksession = kbase.newKieSession();
        WorkingMemoryInMemoryLogger logger = new WorkingMemoryInMemoryLogger((WorkingMemory)ksession);
        logger.afterNodeLeft((ProcessNodeLeftEvent)new ProcessNodeLeftEventImpl((NodeInstance)new EmtpyNodeInstance(), (KieRuntime)ksession));
        List logEvents = logger.getLogEvents();
        Assert.assertEquals((long)logEvents.size(), (long)1L);
        Assert.assertTrue((boolean)((LogEvent)logEvents.get(0)).toString().startsWith("AFTER PROCESS NODE EXITED"));
    }

    static class EmtpyWorkflowProcessInstance
    implements WorkflowProcessInstance {
        EmtpyWorkflowProcessInstance() {
        }

        public String getProcessId() {
            return "emtpy.process";
        }

        public Process getProcess() {
            return null;
        }

        public long getId() {
            return 1L;
        }

        public String getProcessName() {
            return null;
        }

        public int getState() {
            return 1;
        }

        public long getParentProcessInstanceId() {
            return -1L;
        }

        public void signalEvent(String type, Object event) {
        }

        public String[] getEventTypes() {
            return null;
        }

        public Collection<NodeInstance> getNodeInstances() {
            return null;
        }

        public NodeInstance getNodeInstance(long nodeInstanceId) {
            return null;
        }

        public Object getVariable(String name) {
            return null;
        }

        public void setVariable(String name, Object value) {
        }
    }

    public static class EmtpyNodeInstance
    implements NodeInstance {
        public long getId() {
            return 0L;
        }

        public long getNodeId() {
            return 0L;
        }

        public Node getNode() {
            return null;
        }

        public String getNodeName() {
            return "empty.node";
        }

        public WorkflowProcessInstance getProcessInstance() {
            return new EmtpyWorkflowProcessInstance();
        }

        public NodeInstanceContainer getNodeInstanceContainer() {
            return null;
        }

        public Object getVariable(String variableName) {
            return null;
        }

        public void setVariable(String variableName, Object value) {
        }
    }

    public static class AnyType {
        private Integer typeId = 1;
        private String typeName = "test";

        public String getTypeName() {
            return this.typeName;
        }

        public Integer getTypeId() {
            return (int)this.typeId;
        }

        public void setTypeId(Integer id) {
            this.typeId = id;
        }

        public AnyType() {
            this.typeId = 1;
            this.typeName = "test";
        }

        public AnyType(Integer id, String type) {
            this.typeId = id;
            this.typeName = type;
        }
    }
}

