/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.waltz;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.mvel.integrationtests.waltz.Line;
import org.drools.mvel.integrationtests.waltz.Stage;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public abstract class Waltz {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public Waltz(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Test(timeout=60000L)
    public void testWaltz() {
        try {
            KieBase kBase = this.readKnowledegBase();
            for (int i = 0; i < 50; ++i) {
                KieSession kSession = kBase.newKieSession();
                this.loadLines(kSession, "waltz50.dat");
                long start = System.currentTimeMillis();
                Stage stage = new Stage(1);
                kSession.insert((Object)stage);
                kSession.fireAllRules();
                kSession.dispose();
                long end = System.currentTimeMillis();
                System.out.println(end - start);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    public KieBase readKnowledegBase() {
        return KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"waltz.drl"});
    }

    private void loadLines(KieSession kSession, String filename) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(Waltz.class.getResourceAsStream(filename)));
        Pattern pat = Pattern.compile(".*make line \\^p1 ([0-9]*) \\^p2 ([0-9]*).*");
        String line = reader.readLine();
        while (line != null) {
            Matcher m = pat.matcher(line);
            if (m.matches()) {
                Line l = new Line(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
                kSession.insert((Object)l);
            }
            line = reader.readLine();
        }
        reader.close();
    }
}

