/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.drools.testcoverage.common.util.TimeUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.definition.type.Expires;
import org.kie.api.definition.type.Role;
import org.kie.api.definition.type.Timestamp;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class CepJavaTypeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public CepJavaTypeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @Test
    public void testJavaTypeAnnotatedWithRole_WindowTime() {
        String drl = "package org.drools.compiler.integrationtests\n\nimport " + Event.class.getCanonicalName() + ";\n\nrule \"CEP Window Time\"\nwhen\n    Event() over window:time (1d)\nthen\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isEmpty();
    }

    @Test
    public void testJavaTypeAnnotatedWithRole_WindowLength() {
        String drl = "package org.drools.compiler.integrationtests\n\nimport " + Event.class.getCanonicalName() + ";\n\nrule \"CEP Window Length\"\nwhen\n    Event() over window:length (10)\nthen\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testEventWithShortExpiration() throws InterruptedException {
        String drl = "import " + MyMessage.class.getCanonicalName() + "\nrule \"Rule A Start\"\nwhen\n  MyMessage ( name == \"ATrigger\" )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-java-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new MyMessage("ATrigger"));
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
            TimeUtil.sleepMillis((long)2L);
            Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
            while (ksession.getObjects().size() != 0) {
                TimeUtil.sleepMillis((long)30L);
                Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
            }
        }
        finally {
            ksession.dispose();
        }
    }

    @Role(value=Role.Type.EVENT)
    @Timestamp(value="Ts")
    @Expires(value="1ms")
    public static class MyMessage {
        String name;
        long ts;

        public MyMessage(String n) {
            this.name = n;
            this.ts = System.currentTimeMillis();
        }

        public void setName(String n) {
            this.name = n;
        }

        public String getName() {
            return this.name;
        }

        public void setTs(long t) {
            this.ts = t;
        }

        public long getTs() {
            return this.ts;
        }
    }

    @Role(value=Role.Type.EVENT)
    public static class Event {
    }
}

