/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.kproject.memory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.drools.compiler.compiler.io.File;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.core.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class MemoryFileTest {
    @Test
    public void testFileCreation() throws IOException {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder mres = fs.getFolder("src/main/java/org/domain");
        File f1 = mres.getFile("MyClass.java");
        f1.create((InputStream)new ByteArrayInputStream("ABC".getBytes()));
        mres.create();
        f1 = mres.getFile("MyClass.java");
        Assert.assertTrue((boolean)f1.exists());
        f1.create((InputStream)new ByteArrayInputStream("ABC".getBytes()));
        f1 = mres.getFile("MyClass.java");
        Assert.assertTrue((boolean)f1.exists());
        Assert.assertEquals((Object)"ABC", (Object)StringUtils.toString((InputStream)f1.getContents()));
        f1.create((InputStream)new ByteArrayInputStream("ABC".getBytes()));
        f1.setContents((InputStream)new ByteArrayInputStream("DEF".getBytes()));
        Assert.assertEquals((Object)"DEF", (Object)StringUtils.toString((InputStream)f1.getContents()));
    }

    @Test
    public void testFileRemoval() throws IOException {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder mres = fs.getFolder("src/main/java/org/domain");
        mres.create();
        File f1 = mres.getFile("MyClass.java");
        f1.create((InputStream)new ByteArrayInputStream("ABC".getBytes()));
        Assert.assertTrue((boolean)f1.exists());
        Assert.assertEquals((Object)"ABC", (Object)StringUtils.toString((InputStream)f1.getContents()));
        fs.remove(f1);
        f1 = mres.getFile("MyClass.java");
        Assert.assertFalse((boolean)f1.exists());
        try {
            f1.getContents();
            Assert.fail((String)"Should throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testFilePath() {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder mres = fs.getFolder("src/main/java/org/domain");
        File f1 = mres.getFile("MyClass.java");
        Assert.assertEquals((Object)"src/main/java/org/domain/MyClass.java", (Object)f1.getPath().toPortableString());
    }

    @Test
    public void testRelativeToParentFilePath() {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder mres = fs.getFolder("src/main/java/org/domain");
        Folder f2 = fs.getFolder("src/main/java/org/domain/f1/f2/");
        File f1 = mres.getFile("MyClass.java");
        Assert.assertEquals((Object)"../../MyClass.java", (Object)f1.getPath().toRelativePortableString(f2.getPath()));
    }

    @Test
    public void testRelativeToBranchFilePath() {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder mres = fs.getFolder("src/main/java/org/domain");
        Folder f2 = fs.getFolder("src/main/resources/org/domain/");
        File f1 = mres.getFile("MyClass.java");
        Assert.assertEquals((Object)"../../../java/org/domain/MyClass.java", (Object)f1.getPath().toRelativePortableString(f2.getPath()));
    }
}

