/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import org.drools.mvel.compiler.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class DateComparisonTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DateComparisonTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testDateComparisonThan() throws Exception {
        String str = "";
        str = str + "package org.drools.mvel.compiler;\n";
        str = str + "global java.util.List results;\n";
        str = str + "rule \"test date greater than\"\n";
        str = str + "     when\n";
        str = str + "         $c : Cheese(type == \"Yesterday\")\n";
        str = str + "         Cheese(type == \"Tomorrow\",  usedBy > ($c.usedBy))\n";
        str = str + "     then\n";
        str = str + "         results.add( \"test date greater than\" );\n";
        str = str + "end\n";
        str = str + "rule \"test date less than\"\n";
        str = str + "    when\n";
        str = str + "        $c : Cheese(type == \"Tomorrow\")\n";
        str = str + "        Cheese(type == \"Yesterday\", usedBy < ($c.usedBy));\n";
        str = str + "    then\n";
        str = str + "        results.add( \"test date less than\" );\n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese yesterday = new Cheese("Yesterday");
        yesterday.setUsedBy(this.yesterday());
        Cheese tomorrow = new Cheese("Tomorrow");
        tomorrow.setUsedBy(this.tomorrow());
        ksession.insert((Object)yesterday);
        ksession.insert((Object)tomorrow);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("test date greater than"));
        Assert.assertTrue((boolean)results.contains("test date less than"));
    }

    @Test
    public void testDateComparisonAfter() throws Exception {
        String str = "";
        str = str + "package org.drools.mvel.compiler;\n";
        str = str + "global java.util.List results;\n";
        str = str + "rule \"test date greater than\"\n";
        str = str + "     when\n";
        str = str + "         $c : Cheese(type == \"Yesterday\")\n";
        str = str + "         Cheese(type == \"Tomorrow\", $c.usedBy before usedBy)\n";
        str = str + "     then\n";
        str = str + "         results.add( \"test date greater than\" );\n";
        str = str + "end\n";
        str = str + "rule \"test date less than\"\n";
        str = str + "    when\n";
        str = str + "        $c : Cheese(type == \"Tomorrow\")\n";
        str = str + "        Cheese(type == \"Yesterday\", $c.usedBy after usedBy);\n";
        str = str + "    then\n";
        str = str + "        results.add( \"test date less than\" );\n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese yesterday = new Cheese("Yesterday");
        yesterday.setUsedBy(this.yesterday());
        Cheese tomorrow = new Cheese("Tomorrow");
        tomorrow.setUsedBy(this.tomorrow());
        ksession.insert((Object)yesterday);
        ksession.insert((Object)tomorrow);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("test date greater than"));
        Assert.assertTrue((boolean)results.contains("test date less than"));
    }

    @Test
    public void testDateComparisonAfterWithThisBinding() throws Exception {
        String str = "";
        str = str + "package org.drools.mvel.compiler;\n";
        str = str + "global java.util.List results;\n";
        str = str + "rule \"test date greater than\"\n";
        str = str + "     when\n";
        str = str + "         Cheese(type == \"Yesterday\", $c: this)\n";
        str = str + "         Cheese(type == \"Tomorrow\", $c.usedBy before usedBy)\n";
        str = str + "     then\n";
        str = str + "         results.add( \"test date greater than\" );\n";
        str = str + "end\n";
        str = str + "rule \"test date less than\"\n";
        str = str + "    when\n";
        str = str + "        Cheese(type == \"Tomorrow\", $c: this)\n";
        str = str + "        Cheese(type == \"Yesterday\", $c.usedBy after usedBy);\n";
        str = str + "    then\n";
        str = str + "        results.add( \"test date less than\" );\n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese yesterday = new Cheese("Yesterday");
        yesterday.setUsedBy(this.yesterday());
        Cheese tomorrow = new Cheese("Tomorrow");
        tomorrow.setUsedBy(this.tomorrow());
        ksession.insert((Object)yesterday);
        ksession.insert((Object)tomorrow);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("test date greater than"));
        Assert.assertTrue((boolean)results.contains("test date less than"));
    }

    private Date yesterday() {
        GregorianCalendar c = new GregorianCalendar();
        c.set(5, c.get(5) - 1);
        return c.getTime();
    }

    private Date tomorrow() {
        GregorianCalendar c = new GregorianCalendar();
        c.set(5, c.get(5) + 1);
        return c.getTime();
    }
}

