/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.File;
import java.util.Collection;
import org.drools.mvel.compiler.Message;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.Resource;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.io.ResourceFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class KieLoggersTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public KieLoggersTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testKieConsoleLogger() throws Exception {
        String drl = "package org.drools.integrationtests\nimport org.drools.mvel.compiler.Message;\nrule \"Hello World\"\n    when\n        m : Message( myMessage : message )\n    then\nend";
        Resource dt = ResourceFactory.newByteArrayResource((byte[])drl.getBytes()).setTargetPath("org/drools/integrationtests/hello.drl");
        KieSession ksession = this.getKieSession(dt);
        KieRuntimeLogger logger = KieServices.Factory.get().getLoggers().newConsoleLogger((KieRuntimeEventManager)ksession);
        ksession.insert((Object)new Message("Hello World"));
        int fired = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired);
        logger.close();
    }

    @Test
    public void testDeclarativeKieConsoleLogger() throws Exception {
        String drl = "package org.drools.integrationtests\nimport org.drools.mvel.compiler.Message;\nrule \"Hello World\"\n    when\n        m : Message( myMessage : message )\n    then\nend";
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("KBase1").newKieSessionModel("KSession1").setConsoleLogger("logger");
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        kfs.write("src/main/resources/KBase1/rule.drl", drl);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieModule kieModule = kieBuilder.getKieModule();
        KieContainer kieContainer = ks.newKieContainer(kieModule.getReleaseId());
        KieSession ksession = kieContainer.newKieSession("KSession1");
        ksession.insert((Object)new Message("Hello World"));
        int fired = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired);
        KieRuntimeLogger logger = ksession.getLogger();
        Assert.assertNotNull((Object)logger);
        logger.close();
    }

    @Test
    public void testKieConsoleLoggerStateless() throws Exception {
        String drl = "package org.drools.integrationtests\nimport org.drools.mvel.compiler.Message;\nrule \"Hello World\"\n    when\n        m : Message( myMessage : message )\n    then\nend";
        Resource dt = ResourceFactory.newByteArrayResource((byte[])drl.getBytes()).setTargetPath("org/drools/integrationtests/hello.drl");
        StatelessKieSession ksession = this.getStatelessKieSession(dt);
        KieRuntimeLogger logger = KieServices.Factory.get().getLoggers().newConsoleLogger((KieRuntimeEventManager)ksession);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        ksession.execute((Object)new Message("Hello World"));
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)ArgumentMatchers.any(AfterMatchFiredEvent.class));
        logger.close();
    }

    @Test
    public void testDeclarativeKieConsoleLoggerStateless() throws Exception {
        String drl = "package org.drools.integrationtests\nimport org.drools.mvel.compiler.Message;\nrule \"Hello World\"\n    when\n        m : Message( myMessage : message )\n    then\nend";
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("KBase1").newKieSessionModel("KSession1").setType(KieSessionModel.KieSessionType.STATELESS).setConsoleLogger("logger");
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        kfs.write("src/main/resources/KBase1/rule.drl", drl);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieModule kieModule = kieBuilder.getKieModule();
        KieContainer kieContainer = ks.newKieContainer(kieModule.getReleaseId());
        StatelessKieSession ksession = kieContainer.newStatelessKieSession("KSession1");
        ksession.execute((Object)new Message("Hello World"));
        KieRuntimeLogger logger = ksession.getLogger();
        Assert.assertNotNull((Object)logger);
        logger.close();
    }

    @Test
    public void testKieFileLogger() throws Exception {
        String drl = "package org.drools.integrationtests\nimport org.drools.mvel.compiler.Message;\nrule \"Hello World\"\n    when\n        m : Message( myMessage : message )\n    then\nend";
        Resource dt = ResourceFactory.newByteArrayResource((byte[])drl.getBytes()).setTargetPath("org/drools/integrationtests/hello.drl");
        KieSession ksession = this.getKieSession(dt);
        String fileName = "target/testKieFileLogger";
        File file = new File(fileName + ".log");
        if (file.exists()) {
            file.delete();
        }
        KieRuntimeLogger logger = KieServices.Factory.get().getLoggers().newFileLogger((KieRuntimeEventManager)ksession, fileName);
        ksession.insert((Object)new Message("Hello World"));
        int fired = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired);
        logger.close();
        file = new File(fileName + ".log");
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((file.length() > 0L ? 1 : 0) != 0);
        file.delete();
    }

    @Test
    public void testKieFileLoggerWithImmediateFlushing() throws Exception {
        String drl = "package org.drools.integrationtests\nimport org.drools.mvel.compiler.Message;\nrule \"Hello World\"\n    when\n        m : Message( myMessage : message )\n    then\nend";
        Resource dt = ResourceFactory.newByteArrayResource((byte[])drl.getBytes()).setTargetPath("org/drools/integrationtests/hello.drl");
        KieSession ksession = this.getKieSession(dt);
        String fileName = "target/testKieFileLogger";
        File file = new File(fileName + ".log");
        if (file.exists()) {
            file.delete();
        }
        KieRuntimeLogger logger = KieServices.Factory.get().getLoggers().newFileLogger((KieRuntimeEventManager)ksession, fileName, 0);
        ksession.insert((Object)new Message("Hello World"));
        int fired = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired);
        file = new File(fileName + ".log");
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((file.length() > 0L ? 1 : 0) != 0);
        logger.close();
        file.delete();
    }

    @Test
    public void testDeclarativeKieFileLogger() throws Exception {
        String drl = "package org.drools.integrationtests\nimport org.drools.mvel.compiler.Message;\nrule \"Hello World\"\n    when\n        m : Message( myMessage : message )\n    then\nend";
        String fileName = "target/testKieFileLogger";
        File file = new File(fileName + ".log");
        if (file.exists()) {
            file.delete();
        }
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("KBase1").newKieSessionModel("KSession1").setFileLogger(fileName);
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        kfs.write("src/main/resources/KBase1/rule.drl", drl);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        KieModule kieModule = kieBuilder.getKieModule();
        KieContainer kieContainer = ks.newKieContainer(kieModule.getReleaseId());
        KieSession ksession = kieContainer.newKieSession("KSession1");
        ksession.insert((Object)new Message("Hello World"));
        int fired = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired);
        ksession.dispose();
        file = new File(fileName + ".log");
        Assert.assertTrue((boolean)file.exists());
        file.delete();
    }

    private KieSession getKieSession(Resource dt) {
        KieServices ks = this.populateKieFileSystem(dt);
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        return ksession;
    }

    private StatelessKieSession getStatelessKieSession(Resource dt) {
        KieServices ks = this.populateKieFileSystem(dt);
        StatelessKieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newStatelessKieSession();
        return ksession;
    }

    private KieServices populateKieFileSystem(Resource dt) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write(dt);
        KieBuilder kb = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertTrue((boolean)kb.getResults().getMessages().isEmpty());
        return ks;
    }
}

