/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.bind.JAXBContext;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.core.QueryResultsImpl;
import org.drools.core.QueryResultsRowImpl;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.MemoryFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteDumper;
import org.drools.core.runtime.rule.impl.FlatQueryResults;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.DomainObject;
import org.drools.mvel.compiler.InsertedObject;
import org.drools.mvel.compiler.Interval;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Worker;
import org.drools.mvel.compiler.oopath.model.Thing;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.QueryListenerOption;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.LiveQuery;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.Row;
import org.kie.api.runtime.rule.Variable;
import org.kie.api.runtime.rule.ViewChangedEventListener;

@RunWith(value=Parameterized.class)
public class QueryTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    @Rule
    public TestName testName = new TestName();

    public QueryTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Before
    public void before() {
        System.out.println("] " + this.testName.getMethodName());
    }

    private static QueryResults getQueryResults(KieSession session, String queryName, Object ... arguments) throws Exception {
        QueryResultsImpl results = (QueryResultsImpl)session.getQueryResults(queryName, arguments);
        FlatQueryResults flatResults = new FlatQueryResults(results);
        Assert.assertEquals((String)"Query results size", (long)results.size(), (long)flatResults.size());
        Assert.assertEquals((String)"Query results identifiers", (long)results.getIdentifiers().length, (long)flatResults.getIdentifiers().length);
        TreeSet<String> resultIds = new TreeSet<String>(Arrays.asList(results.getIdentifiers()));
        TreeSet<String> flatIds = new TreeSet<String>(Arrays.asList(flatResults.getIdentifiers()));
        Assert.assertArrayEquals((String)"Flat query results identifiers", (Object[])resultIds.toArray(), (Object[])flatIds.toArray());
        FlatQueryResults copyFlatResults = (FlatQueryResults)QueryTest.roundTrip(flatResults);
        String[] identifiers = results.getIdentifiers();
        Iterator copyFlatIter = copyFlatResults.iterator();
        for (int i = 0; i < results.size(); ++i) {
            QueryResultsRowImpl row = results.get(i);
            Assert.assertTrue((String)"Round-tripped flat query results contain less rows than original query results", (boolean)copyFlatIter.hasNext());
            QueryResultsRow copyRow = (QueryResultsRow)copyFlatIter.next();
            for (String id : identifiers) {
                Object obj = row.get(id);
                if (obj != null) {
                    Object copyObj = copyRow.get(id);
                    Assert.assertTrue((String)("Flat query result [" + i + "] does not contain result: '" + id + "': " + obj + "/" + copyObj), (obj != null && obj.equals(copyObj) ? 1 : 0) != 0);
                }
                FactHandle fh = row.getFactHandle(id);
                FactHandle copyFh = copyRow.getFactHandle(id);
                if (fh == null) continue;
                Assert.assertNotNull((String)("Flat query result [" + i + "] does not contain facthandle: '" + ((InternalFactHandle)fh).getId() + "'"), (Object)copyFh);
                String fhStr = fh.toExternalForm();
                fhStr = fhStr.substring(0, fhStr.lastIndexOf(":"));
                String copyFhStr = copyFh.toExternalForm();
                copyFhStr = copyFhStr.substring(0, copyFhStr.lastIndexOf(":"));
                Assert.assertEquals((String)("Unequal fact handles for fact handle '" + ((InternalFactHandle)fh).getId() + "':"), (Object)fhStr, (Object)copyFhStr);
            }
        }
        TreeSet<String> copyFlatIds = new TreeSet<String>(Arrays.asList(copyFlatResults.getIdentifiers()));
        Assert.assertArrayEquals((String)"Flat query results identifiers", (Object[])flatIds.toArray(), (Object[])copyFlatIds.toArray());
        return copyFlatResults;
    }

    private static <T> T roundTrip(Object obj) throws Exception {
        Class[] classes = new Class[]{obj.getClass()};
        JAXBContext ctx = QueryTest.getJaxbContext(classes);
        String xmlOut = QueryTest.marshall(ctx, obj);
        return QueryTest.unmarshall(ctx, xmlOut);
    }

    private static <T> T unmarshall(JAXBContext ctx, String xmlIn) throws Exception {
        ByteArrayInputStream xmlStrInputStream = new ByteArrayInputStream(xmlIn.getBytes(Charset.forName("UTF-8")));
        Object out = ctx.createUnmarshaller().unmarshal((InputStream)xmlStrInputStream);
        return (T)out;
    }

    private static String marshall(JAXBContext ctx, Object obj) throws Exception {
        StringWriter writer = new StringWriter();
        ctx.createMarshaller().marshal(obj, (Writer)writer);
        return writer.getBuffer().toString();
    }

    private static JAXBContext getJaxbContext(Class<?> ... classes) throws Exception {
        ArrayList jaxbClassList = new ArrayList();
        jaxbClassList.addAll(Arrays.asList(classes));
        jaxbClassList.add(Cheese.class);
        jaxbClassList.add(InsertedObject.class);
        jaxbClassList.add(Person.class);
        Class[] jaxbClasses = jaxbClassList.toArray(new Class[jaxbClassList.size()]);
        return JAXBContext.newInstance((Class[])jaxbClasses);
    }

    @Test
    public void testQuery2() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Query.drl"});
        KieSession session = kbase.newKieSession();
        session.fireAllRules();
        QueryResults results = QueryTest.getQueryResults(session, "assertedobjquery", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)new InsertedObject("value1"), (Object)((QueryResultsRow)results.iterator().next()).get("assertedobj"));
    }

    @Test
    public void testQueryWithParams() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_QueryWithParams.drl"});
        KieSession session = kbase.newKieSession();
        session.fireAllRules();
        String queryName = "assertedobjquery";
        Object[] arguments = new String[]{"value1"};
        QueryResultsImpl resultsImpl = (QueryResultsImpl)session.getQueryResults(queryName, arguments);
        QueryResults results = QueryTest.getQueryResults(session, queryName, arguments);
        Assert.assertEquals((long)1L, (long)results.size());
        InsertedObject value = new InsertedObject("value1");
        Assert.assertEquals((Object)value, (Object)((QueryResultsRow)results.iterator().next()).get("assertedobj"));
        results = QueryTest.getQueryResults(session, "assertedobjquery", "value3");
        Assert.assertEquals((long)0L, (long)results.size());
        results = QueryTest.getQueryResults(session, "assertedobjquery2", null, "value2");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)new InsertedObject("value2"), (Object)((QueryResultsRow)results.iterator().next()).get("assertedobj"));
        results = QueryTest.getQueryResults(session, "assertedobjquery2", "value3", "value2");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)new InsertedObject("value2"), (Object)((QueryResultsRow)results.iterator().next()).get("assertedobj"));
    }

    @Test
    public void testQueryWithMultipleResultsOnKnowledgeApi() throws Exception {
        String str = "";
        str = str + "package org.drools.mvel.compiler.test  \n";
        str = str + "import org.drools.mvel.compiler.Cheese \n";
        str = str + "query cheeses \n";
        str = str + "    stilton : Cheese(type == 'stilton') \n";
        str = str + "    cheddar : Cheese(type == 'cheddar', price == stilton.price) \n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession session = kbase.newKieSession();
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        Cheese stilton3 = new Cheese("stilton", 3);
        Cheese cheddar3 = new Cheese("cheddar", 3);
        HashSet set = new HashSet();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(stilton1);
        list.add(cheddar1);
        set.add(list);
        list = new ArrayList();
        list.add(stilton2);
        list.add(cheddar2);
        set.add(list);
        list = new ArrayList();
        list.add(stilton3);
        list.add(cheddar3);
        set.add(list);
        session.insert((Object)stilton1);
        session.insert((Object)stilton2);
        session.insert((Object)stilton3);
        session.insert((Object)cheddar1);
        session.insert((Object)cheddar2);
        session.insert((Object)cheddar3);
        QueryResults results = QueryTest.getQueryResults(session, "cheeses", new Object[0]);
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((long)2L, (long)results.getIdentifiers().length);
        HashSet<ArrayList<Object>> newSet = new HashSet<ArrayList<Object>>();
        for (QueryResultsRow result : results) {
            list = new ArrayList();
            list.add(result.get("stilton"));
            list.add(result.get("cheddar"));
            newSet.add(list);
        }
        Assert.assertEquals(set, newSet);
        FlatQueryResults flatResults = new FlatQueryResults(((StatefulKnowledgeSessionImpl)session).getQueryResults("cheeses", new Object[0]));
        newSet = new HashSet();
        for (QueryResultsRow result : flatResults) {
            list = new ArrayList();
            list.add(result.get("stilton"));
            list.add(result.get("cheddar"));
            newSet.add(list);
        }
        Assert.assertEquals(set, newSet);
    }

    @Test
    public void testTwoQuerries() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_TwoQuerries.drl"});
        KieSession session = kbase.newKieSession();
        Cheese stilton = new Cheese("stinky", 5);
        session.insert((Object)stilton);
        Person per1 = new Person("stinker", "smelly feet", 70);
        Person per2 = new Person("skunky", "smelly armpits", 40);
        session.insert((Object)per1);
        session.insert((Object)per2);
        QueryResults results = QueryTest.getQueryResults(session, "find stinky cheeses", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        results = QueryTest.getQueryResults(session, "find pensioners", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testDoubleQueryWithExists() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DoubleQueryWithExists.drl"});
        KieSession session = kbase.newKieSession();
        Person p1 = new Person("p1", "stilton", 20);
        p1.setStatus("europe");
        FactHandle c1FactHandle = session.insert((Object)p1);
        Person p2 = new Person("p2", "stilton", 30);
        p2.setStatus("europe");
        FactHandle c2FactHandle = session.insert((Object)p2);
        Person p3 = new Person("p3", "stilton", 40);
        p3.setStatus("europe");
        FactHandle c3FactHandle = session.insert((Object)p3);
        session.fireAllRules();
        QueryResults results = session.getQueryResults("2 persons with the same status", new Object[0]);
        Assert.assertEquals((long)2L, (long)results.size());
        p3.setStatus("america");
        session.update(c3FactHandle, (Object)p3);
        session.fireAllRules();
        results = session.getQueryResults("2 persons with the same status", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        p2.setStatus("america");
        session.update(c2FactHandle, (Object)p2);
        session.fireAllRules();
        results = session.getQueryResults("2 persons with the same status", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        p1.setStatus("america");
        session.update(c1FactHandle, (Object)p1);
        session.fireAllRules();
        results = QueryTest.getQueryResults(session, "2 persons with the same status", new Object[0]);
        Assert.assertEquals((long)2L, (long)results.size());
        p2.setStatus("europe");
        session.update(c2FactHandle, (Object)p2);
        session.fireAllRules();
        results = QueryTest.getQueryResults(session, "2 persons with the same status", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        p1.setStatus("europe");
        session.update(c1FactHandle, (Object)p1);
        session.fireAllRules();
        results = session.getQueryResults("2 persons with the same status", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        p3.setStatus("europe");
        session.update(c3FactHandle, (Object)p3);
        session.fireAllRules();
        results = session.getQueryResults("2 persons with the same status", new Object[0]);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testQueryWithCollect() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Query.drl"});
        KieSession session = kbase.newKieSession();
        session.fireAllRules();
        QueryResults results = QueryTest.getQueryResults(session, "collect objects", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        QueryResultsRow row = (QueryResultsRow)results.iterator().next();
        List list = (List)row.get("$list");
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testDroolsQueryCleanup() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_QueryMemoryLeak.drl"});
        KieSession ksession = kbase.newKieSession();
        String workerId = "B1234";
        Worker worker = new Worker();
        worker.setId(workerId);
        FactHandle handle = ksession.insert((Object)worker);
        ksession.fireAllRules();
        Assert.assertNotNull((Object)handle);
        QueryResults retractedWorker = null;
        for (int i = 0; i < 100; ++i) {
            retractedWorker = ksession.getQueryResults("getWorker", new Object[]{workerId});
        }
        Assert.assertNotNull(retractedWorker);
        StatefulKnowledgeSessionImpl sessionImpl = (StatefulKnowledgeSessionImpl)ksession;
        Collection entryPointNodes = sessionImpl.getKnowledgeBase().getRete().getEntryPointNodes().values();
        EntryPointNode defaultEntryPointNode = null;
        for (EntryPointNode epNode : entryPointNodes) {
            if (!epNode.getEntryPoint().getEntryPointId().equals("DEFAULT")) continue;
            defaultEntryPointNode = epNode;
            break;
        }
        Assert.assertNotNull(defaultEntryPointNode);
        Map obnodes = defaultEntryPointNode.getObjectTypeNodes();
        ClassObjectType key = new ClassObjectType(DroolsQuery.class);
        ObjectTypeNode droolsQueryNode = (ObjectTypeNode)obnodes.get(key);
        Iterator it = ((ObjectTypeNode.ObjectTypeNodeMemory)sessionImpl.getNodeMemory((MemoryFactory)droolsQueryNode)).iterator();
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testQueriesWithVariableUnification() throws Exception {
        String str = "";
        str = str + "package org.drools.mvel.compiler.test  \n";
        str = str + "import org.drools.mvel.compiler.Person \n";
        str = str + "query peeps( String $name, String $likes, int $age ) \n";
        str = str + "    $p : Person( $name := name, $likes := likes, $age := age ) \n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("yoda", "stilton", 300);
        Person p3 = new Person("luke", "brie", 300);
        Person p4 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        QueryResults results = QueryTest.getQueryResults(ksession, "peeps", Variable.v, Variable.v, Variable.v);
        Assert.assertEquals((long)4L, (long)results.size());
        ArrayList<String> names = new ArrayList<String>();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)4L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("luke"));
        Assert.assertTrue((boolean)names.contains("yoda"));
        Assert.assertTrue((boolean)names.contains("bobba"));
        Assert.assertTrue((boolean)names.contains("darth"));
        results = QueryTest.getQueryResults(ksession, "peeps", Variable.v, Variable.v, 300);
        Assert.assertEquals((long)3L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)3L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("luke"));
        Assert.assertTrue((boolean)names.contains("yoda"));
        Assert.assertTrue((boolean)names.contains("bobba"));
        results = QueryTest.getQueryResults(ksession, "peeps", Variable.v, "stilton", 300);
        Assert.assertEquals((long)1L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)1L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("yoda"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.v, "stilton", Variable.v});
        Assert.assertEquals((long)2L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)2L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("yoda"));
        Assert.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{"darth", Variable.v, Variable.v});
        Assert.assertEquals((long)1L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)1L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("darth"));
    }

    @Test
    public void testQueriesWithVariableUnificationOnPatterns() throws Exception {
        String str = "";
        str = str + "package org.drools.mvel.compiler.test  \n";
        str = str + "import org.drools.mvel.compiler.Person \n";
        str = str + "query peeps( Person $p, String $name, String $likes, int $age ) \n";
        str = str + "    $p := Person( $name := name, $likes := likes, $age := age ) \n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("yoda", "stilton", 300);
        Person p3 = new Person("luke", "brie", 300);
        Person p4 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        QueryResults results = ksession.getQueryResults("peeps", new Object[]{Variable.v, Variable.v, Variable.v, Variable.v});
        Assert.assertEquals((long)4L, (long)results.size());
        ArrayList<String> names = new ArrayList<String>();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)4L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("luke"));
        Assert.assertTrue((boolean)names.contains("yoda"));
        Assert.assertTrue((boolean)names.contains("bobba"));
        Assert.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{p1, Variable.v, Variable.v, Variable.v});
        Assert.assertEquals((long)1L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)1L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("darth"));
    }

    @Test
    public void testQueriesWithVariableUnificationOnNestedFields() throws Exception {
        String str = "";
        str = str + "package org.drools.mvel.compiler.test  \n";
        str = str + "import org.drools.mvel.compiler.Person \n";
        str = str + "query peeps( String $name, String $likes, String $street) \n";
        str = str + "    $p : Person( $name := name, $likes := likes, $street := address.street ) \n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Person p1 = new Person("darth", "stilton", 100);
        p1.setAddress(new Address("s1"));
        Person p2 = new Person("yoda", "stilton", 300);
        p2.setAddress(new Address("s2"));
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        QueryResults results = QueryTest.getQueryResults(ksession, "peeps", Variable.v, Variable.v, Variable.v);
        Assert.assertEquals((long)2L, (long)results.size());
        ArrayList<String> names = new ArrayList<String>();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertTrue((boolean)names.contains("yoda"));
        Assert.assertTrue((boolean)names.contains("darth"));
        results = QueryTest.getQueryResults(ksession, "peeps", Variable.v, Variable.v, "s1");
        Assert.assertEquals((long)1L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertTrue((boolean)names.contains("darth"));
    }

    @Test
    public void testOpenQuery() throws Exception {
        String str = "";
        str = str + "package org.drools.mvel.compiler.test  \n";
        str = str + "import org.drools.mvel.compiler.Cheese \n";
        str = str + "query cheeses(String $type1, String $type2) \n";
        str = str + "    stilton : Cheese(type == $type1, $sprice : price) \n";
        str = str + "    cheddar : Cheese(type == $type2, $cprice : price == stilton.price) \n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        Cheese stilton3 = new Cheese("stilton", 3);
        Cheese cheddar3 = new Cheese("cheddar", 3);
        FactHandle s1Fh = ksession.insert((Object)stilton1);
        ksession.insert((Object)stilton2);
        ksession.insert((Object)stilton3);
        ksession.insert((Object)cheddar1);
        ksession.insert((Object)cheddar2);
        FactHandle c3Fh = ksession.insert((Object)cheddar3);
        final ArrayList updated = new ArrayList();
        final ArrayList removed = new ArrayList();
        final ArrayList added = new ArrayList();
        ViewChangedEventListener listener = new ViewChangedEventListener(){

            public void rowUpdated(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar"), row.get("$sprice"), row.get("$cprice"), row.get("$type1"), row.get("$type2")};
                updated.add(array);
            }

            public void rowDeleted(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar"), row.get("$sprice"), row.get("$cprice"), row.get("$type1"), row.get("$type2")};
                removed.add(array);
            }

            public void rowInserted(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar"), row.get("$sprice"), row.get("$cprice"), row.get("$type1"), row.get("$type2")};
                added.add(array);
            }
        };
        LiveQuery query = ksession.openLiveQuery("cheeses", new Object[]{"stilton", "cheddar"}, listener);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)added.size());
        Assert.assertEquals((long)0L, (long)removed.size());
        Assert.assertEquals((long)0L, (long)updated.size());
        Assert.assertSame((Object)stilton1, (Object)((Object[])added.get(2))[0]);
        Assert.assertSame((Object)cheddar1, (Object)((Object[])added.get(2))[1]);
        Assert.assertEquals((Object)1, (Object)((Object[])added.get(2))[2]);
        Assert.assertEquals((Object)1, (Object)((Object[])added.get(2))[3]);
        Assert.assertEquals((Object)"stilton", (Object)((Object[])added.get(2))[4]);
        Assert.assertEquals((Object)"cheddar", (Object)((Object[])added.get(2))[5]);
        Assert.assertEquals((Object)3, (Object)((Object[])added.get(0))[3]);
        Assert.assertEquals((Object)2, (Object)((Object[])added.get(1))[3]);
        Assert.assertEquals((Object)1, (Object)((Object[])added.get(2))[3]);
        cheddar3.setPrice(4);
        ksession.update(c3Fh, (Object)cheddar3);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)added.size());
        Assert.assertEquals((long)1L, (long)removed.size());
        Assert.assertEquals((long)0L, (long)updated.size());
        Assert.assertEquals((Object)4, (Object)((Object[])removed.get(0))[3]);
        cheddar3.setPrice(3);
        ksession.update(c3Fh, (Object)cheddar3);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)1L, (long)removed.size());
        Assert.assertEquals((long)0L, (long)updated.size());
        Assert.assertEquals((Object)3, (Object)((Object[])added.get(3))[3]);
        cheddar3.setOldPrice(0);
        ksession.update(c3Fh, (Object)cheddar3);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)1L, (long)removed.size());
        Assert.assertEquals((long)1L, (long)updated.size());
        Assert.assertEquals((Object)3, (Object)((Object[])updated.get(0))[3]);
        ksession.retract(s1Fh);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)2L, (long)removed.size());
        Assert.assertEquals((long)1L, (long)updated.size());
        Assert.assertEquals((Object)1, (Object)((Object[])removed.get(1))[3]);
        query.close();
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)4L, (long)removed.size());
        Assert.assertEquals((long)1L, (long)updated.size());
        Assert.assertEquals((Object)2, (Object)((Object[])removed.get(3))[3]);
        Assert.assertEquals((Object)3, (Object)((Object[])removed.get(2))[3]);
        ksession.update(c3Fh, (Object)cheddar3);
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)4L, (long)removed.size());
        Assert.assertEquals((long)1L, (long)updated.size());
    }

    @Test
    public void testStandardQueryListener() throws IOException, ClassNotFoundException {
        this.runQueryListenerTest(QueryListenerOption.STANDARD);
    }

    @Test
    public void testNonCloningQueryListener() throws IOException, ClassNotFoundException {
        this.runQueryListenerTest(QueryListenerOption.LIGHTWEIGHT);
    }

    public void runQueryListenerTest(QueryListenerOption option) throws IOException, ClassNotFoundException {
        String str = "";
        str = str + "package org.drools.mvel.integrationtests\n";
        str = str + "import " + Cheese.class.getCanonicalName() + " \n";
        str = str + "query cheeses(String $type) \n";
        str = str + "    $cheese : Cheese(type == $type) \n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        for (int i = 0; i < 10000; ++i) {
            ksession.insert((Object)new Cheese(i % 2 == 0 ? "stilton" : "brie"));
        }
        for (int i = 0; i < 100; ++i) {
            QueryResults queryResults = ksession.getQueryResults("cheeses", new Object[]{"stilton"});
            ArrayList<Cheese> cheeses = new ArrayList<Cheese>();
            for (QueryResultsRow row : queryResults) {
                cheeses.add((Cheese)row.get("$cheese"));
            }
            Assert.assertEquals((long)5000L, (long)cheeses.size());
        }
    }

    @Test
    public void testQueryWithEval() throws IOException, ClassNotFoundException {
        String str = "package org.drools.mvel.integrationtests\nimport " + DomainObject.class.getCanonicalName() + " \nquery queryWithEval \n    $do: DomainObject()\n    not DomainObject( id == $do.id, eval(interval.isAfter($do.getInterval())))\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        DomainObject do1 = new DomainObject();
        do1.setId(1L);
        do1.setInterval(new Interval(10L, 5L));
        DomainObject do2 = new DomainObject();
        do2.setId(1L);
        do2.setInterval(new Interval(20L, 5L));
        ksession.insert((Object)do1);
        ksession.insert((Object)do2);
        QueryResults results = ksession.getQueryResults("queryWithEval", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)do2, (Object)((QueryResultsRow)results.iterator().next()).get("$do"));
        ksession.dispose();
    }

    @Test
    public void testQueryWithIncompatibleArgs() {
        String drl = "global java.util.List list; query foo( String $s, String $s, String $s ) end rule React \nwhen\n  $i : Integer()   foo( $i, $x, $i ; ) then\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertEquals((long)2L, (long)errors.size());
    }

    @Test
    public void testQueryWithSyntaxError() {
        String drl = "global java.util.List list; query foo( Integer $i ) end rule React \nwhen\n  $i : Integer()   foo( $i ) then\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertEquals((long)1L, (long)errors.size());
    }

    @Test
    public void testQueryWithWrongParamNumber() {
        String drl = "global java.util.List list; query foo( Integer $i ) end rule React \nwhen\n  $i : Integer()   $j : Integer()   foo( $i, $j ; ) then\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertEquals((long)1L, (long)errors.size());
    }

    @Test
    public void testGlobalsInQueries() {
        String drl = "\npackage com.sample\n\nglobal java.lang.String AString;\nglobal java.util.List list;\n\ndeclare AThing\n     name: String @key\nend\n\nrule init\n     when\n     then\n         insert( new AThing( AString ) );\n         insert( new AThing( 'Holla' ) );\nend\n\nquery test( String $in ) \n     AThing( $in; )\nend\n\nrule spot\n     when\n         test( \"Hello\"; )\n         AThing( \"Hello\"; )\n         test( AString; )\n         AThing( AString; )     then\n         list.add( AString + \" World\" );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("AString", (Object)"Hello");
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assert.assertEquals(Arrays.asList("Hello World"), list);
    }

    @Test
    public void testQueryWithClassArg() {
        String drl = "global java.util.List list; declare Foo end query bar( Class $c )   Class( this.getName() == $c.getName() ) end query bar2( Class $c )   Class( this == $c ) end rule Init when then insert( Foo.class ); end rule React1 when   bar( Foo.class ; ) then   list.add( 'aa' ); end  rule React2 when\n  bar2( Foo.class ; ) then   list.add( 'bb' ); end";
        ArrayList list = new ArrayList();
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kbase.newKieSession();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assert.assertEquals(Arrays.asList("aa", "bb"), list);
    }

    @Test
    public void testPassGlobalToNestedQuery() {
        String drl = "global java.util.List list;\nglobal Integer number;\n\nquery findString( String $out )\n    findStringWithLength( number, $out; )\nend\nquery findStringWithLength( int $in, String $out )\n    $out := String( $in := length )\nend\n\nrule R when\n    findString( $s; )\nthen\n    list.add( $s );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.setGlobal("number", (Object)3);
        ks.insert((Object)"Hi");
        ks.insert((Object)"Bye");
        ks.insert((Object)"Hello");
        ks.fireAllRules();
        Assert.assertEquals(Arrays.asList("Bye"), list);
    }

    @Test
    public void testQueryWithAccessorAsArgument() throws Exception {
        String str = "import org.drools.mvel.compiler.Person\nglobal java.util.List persons;\n\nquery contains(String $s, String $c)\n    $s := String( this.contains( $c ) )\nend\n\nrule R when\n    $p : Person()\n    contains( $p.name, \"a\"; )\nthen\n    persons.add( $p );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList personsWithA = new ArrayList();
        ksession.setGlobal("persons", personsWithA);
        ksession.insert((Object)"Mark");
        ksession.insert((Object)"Edson");
        ksession.insert((Object)"Mario");
        ksession.insert((Object)new Person("Mark"));
        ksession.insert((Object)new Person("Edson"));
        ksession.insert((Object)new Person("Mario"));
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)personsWithA.size());
        for (Person p : personsWithA) {
            Assert.assertTrue((p.getName().equals("Mark") || p.getName().equals("Mario") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQueryWithExpressionAsArgument() throws Exception {
        String str = "import org.drools.mvel.compiler.Person\nglobal java.util.List persons;\n\nquery checkLength(String $s, int $l)\n    $s := String( length == $l )\nend\n\nrule R when\n    $i : Integer()\n    $p : Person()\n    checkLength( $p.name, 1 + $i + $p.age; )\nthen\n    persons.add( $p );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("persons", list);
        ksession.insert((Object)1);
        ksession.insert((Object)"Mark");
        ksession.insert((Object)"Edson");
        ksession.insert((Object)"Mario");
        ksession.insert((Object)new Person("Mark", 2));
        ksession.insert((Object)new Person("Edson", 3));
        ksession.insert((Object)new Person("Mario", 4));
        ksession.fireAllRules();
        System.out.println(list);
        Assert.assertEquals((long)2L, (long)list.size());
        for (Person p : list) {
            Assert.assertTrue((p.getName().equals("Mark") || p.getName().equals("Edson") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNotExistingDeclarationInQuery() {
        String drl = "import org.drools.compiler.Person\nglobal java.util.List persons;\n\nquery checkLength(String $s, int $l)\n    $s := String( length == $l )\nend\n\nrule R when\n    $i : Integer()\n    $p : Person()\n    checkLength( $p.name, 1 + $x + $p.age; )\nthen\n    persons.add( $p );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testQueryInSubnetwork() {
        String str = "query myquery(Integer $i)\n   $i := Integer()\nend\n\nrule R when\n   String()\n   accumulate (myquery($i;);\n      $result_count : count(1)\n   )\n   eval($result_count > 0)\nthen\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        FactHandle iFH = ksession.insert((Object)1);
        FactHandle sFH = ksession.insert((Object)"");
        ksession.fireAllRules();
        ksession.update(iFH, (Object)1);
        ksession.delete(sFH);
        ksession.fireAllRules();
    }

    @Test
    public void testOpenQueryNoParams() throws Exception {
        String str = "";
        str = str + "package org.drools.mvel.compiler.test  \n";
        str = str + "import org.drools.mvel.compiler.Cheese \n";
        str = str + "query cheeses \n";
        str = str + "    stilton : Cheese(type == 'stilton') \n";
        str = str + "    cheddar : Cheese(type == 'cheddar', price == stilton.price) \n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        Cheese stilton3 = new Cheese("stilton", 3);
        Cheese cheddar3 = new Cheese("cheddar", 3);
        FactHandle s1Fh = ksession.insert((Object)stilton1);
        ksession.insert((Object)stilton2);
        ksession.insert((Object)stilton3);
        ksession.insert((Object)cheddar1);
        ksession.insert((Object)cheddar2);
        FactHandle c3Fh = ksession.insert((Object)cheddar3);
        final ArrayList updated = new ArrayList();
        final ArrayList removed = new ArrayList();
        final ArrayList added = new ArrayList();
        ViewChangedEventListener listener = new ViewChangedEventListener(){

            public void rowUpdated(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar")};
                updated.add(array);
            }

            public void rowDeleted(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar")};
                removed.add(array);
            }

            public void rowInserted(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar")};
                added.add(array);
            }
        };
        LiveQuery query = ksession.openLiveQuery("cheeses", null, listener);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)added.size());
        Assert.assertEquals((long)0L, (long)removed.size());
        Assert.assertEquals((long)0L, (long)updated.size());
        cheddar3.setPrice(4);
        ksession.update(c3Fh, (Object)cheddar3);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)added.size());
        Assert.assertEquals((long)1L, (long)removed.size());
        Assert.assertEquals((long)0L, (long)updated.size());
        cheddar3.setPrice(3);
        ksession.update(c3Fh, (Object)cheddar3);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)1L, (long)removed.size());
        Assert.assertEquals((long)0L, (long)updated.size());
        cheddar3.setOldPrice(0);
        ksession.update(c3Fh, (Object)cheddar3);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)1L, (long)removed.size());
        Assert.assertEquals((long)1L, (long)updated.size());
        ksession.retract(s1Fh);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)2L, (long)removed.size());
        Assert.assertEquals((long)1L, (long)updated.size());
        query.close();
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)4L, (long)removed.size());
        Assert.assertEquals((long)1L, (long)updated.size());
        ksession.update(c3Fh, (Object)cheddar3);
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)4L, (long)removed.size());
        Assert.assertEquals((long)1L, (long)updated.size());
    }

    @Test
    public void testQueryWithOptionalOr() {
        String str = "package org.test\nimport " + Question.class.getCanonicalName() + "\nimport " + QuestionVisible.class.getCanonicalName() + "\nquery QuestionsKnowledge\n    $question: Question()\n    $visible: QuestionVisible(question == $question) or not QuestionVisible(question == $question)\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Question question = new Question();
        ksession.insert((Object)question);
        QueryResults results = ksession.getQueryResults("QuestionsKnowledge", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        QueryResultsRow row = (QueryResultsRow)results.iterator().next();
        Assert.assertSame((Object)question, (Object)row.get("$question"));
        QuestionVisible questionVisible = new QuestionVisible(question);
        ksession.insert((Object)questionVisible);
        results = ksession.getQueryResults("QuestionsKnowledge", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        row = (QueryResultsRow)results.iterator().next();
        Assert.assertSame((Object)question, (Object)row.get("$question"));
        Assert.assertSame((Object)questionVisible, (Object)row.get("$visible"));
    }

    @Test
    public void testQueryWithFrom() {
        String drl = "import org.drools.mvel.compiler.oopath.model.Thing;\nquery isContainedIn( Thing $x, Thing $y )\n    $y := Thing() from $x.children\nor\n    ( $z := Thing() from $x.children and isContainedIn( $z, $y; ) )\nend\n";
        Thing smartphone = new Thing("smartphone");
        List<String> itemList = Arrays.asList("display", "keyboard", "processor");
        itemList.stream().map(item -> new Thing((String)item)).forEach(thing -> smartphone.addChild((Thing)thing));
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.Thing;\nquery isContainedIn( Thing $x, Thing $y )\n    $y := Thing() from $x.children\nor\n    ( $z := Thing() from $x.children and isContainedIn( $z, $y; ) )\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ReteDumper.dumpRete((KieSession)ksession);
        ksession.insert((Object)smartphone);
        QueryResults queryResults = ksession.getQueryResults("isContainedIn", new Object[]{smartphone, Variable.v});
        List resultList = StreamSupport.stream(queryResults.spliterator(), false).map(row -> ((Thing)row.get("$y")).getName()).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(resultList).as("Query does not contain all items", new Object[0])).containsAll(itemList);
        ksession.dispose();
    }

    public static class QuestionVisible {
        private final Question question;

        public QuestionVisible(Question question) {
            this.question = question;
        }

        public Question getQuestion() {
            return this.question;
        }
    }

    public static class Question {
    }
}

