/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.test.model.Cheese;
import org.drools.core.test.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;

@RunWith(value=Parameterized.class)
public class BasicUpdateTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final String UPDATE_TEST_DRL = "org/drools/mvel/integrationtests/session/update_test.drl";
    private KieSession ksession;

    public BasicUpdateTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Before
    public void setUp() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{UPDATE_TEST_DRL});
        this.ksession = kbase.newKieSession();
    }

    @After
    public void tearDown() {
        this.ksession.dispose();
    }

    @Test
    public void updateTheOnlyFactTest() {
        Person person = new Person("George", 18);
        FactHandle factPerson = this.ksession.insert((Object)person);
        Assertions.assertThat((Iterable)this.ksession.getObjects()).hasSize(1);
        Assertions.assertThat(this.ksession.getObjects().iterator().next()).isInstanceOf(Person.class);
        Person personToBeVerified = (Person)this.ksession.getObjects().iterator().next();
        this.verifyPerson(person, personToBeVerified, 18, "George", true);
        this.ksession.update(factPerson, (Object)new Person("Henry", 21));
        this.verifyFactsPresentInSession(1, Person.class);
        personToBeVerified = (Person)this.ksession.getObjects().iterator().next();
        this.verifyPerson(person, personToBeVerified, 21, "Henry", false);
    }

    @Test(expected=NullPointerException.class)
    public void updateWithNullTest() {
        Person person = new Person("George", 18);
        FactHandle factPerson = this.ksession.insert((Object)person);
        this.verifyFactsPresentInSession(1, Person.class);
        this.ksession.update(factPerson, null);
    }

    @Test
    public void updateWithDifferentClassGetQueryResultsTest() {
        Person person = new Person("George", 18);
        FactHandle fact = this.ksession.insert((Object)person);
        this.verifyFactsWithQuery(Person.class, "persons", person);
        Cheese cheese = new Cheese("Camembert", 2);
        this.ksession.update(fact, (Object)cheese);
        this.verifyWithQueryNoPersonsPresentInFacts();
        this.verifyFactsPresentInSession(1, Cheese.class);
        Cheese cheeseToBeVerified = (Cheese)this.ksession.getObjects().iterator().next();
        this.verifyCheese(cheeseToBeVerified, 2, "Camembert");
        cheeseToBeVerified = this.verifyFactPresentInSession(fact, Cheese.class);
        this.verifyCheese(cheeseToBeVerified, 2, "Camembert");
    }

    @Test
    public void updateWithDifferentClassGetObjectsTest() {
        Person person = new Person("George", 18);
        FactHandle factPerson = this.ksession.insert((Object)person);
        Person personToBeVerified = this.verifyFactsPresentInSession(1, Person.class).get(0);
        Assertions.assertThat((Object)personToBeVerified).isEqualTo((Object)person);
        Cheese cheese = new Cheese("Camembert", 50);
        this.ksession.update(factPerson, (Object)cheese);
        this.verifyFactsPresentInSession(1, Cheese.class);
        Cheese cheeseToBeVerified = (Cheese)this.ksession.getObjects().iterator().next();
        this.verifyCheese(cheeseToBeVerified, 50, "Camembert");
    }

    @Test
    public void updateFireRulesTest() {
        Person george = new Person("George", 17);
        Person henry = new Person("Henry", 25);
        FactHandle georgeFact = this.ksession.insert((Object)george);
        this.ksession.insert((Object)henry);
        this.verifyFactsWithQuery(Person.class, "persons", george, henry);
        ArrayList drivers = new ArrayList();
        this.ksession.setGlobal("drivers", drivers);
        Assertions.assertThat((int)this.ksession.fireAllRules()).isEqualTo(1);
        this.verifyList(drivers, george, henry);
        george.setAge(18);
        this.ksession.update(georgeFact, (Object)george);
        this.verifyFactsWithQuery(Person.class, "persons", george, henry);
        Assertions.assertThat((int)this.ksession.fireAllRules()).isEqualTo(1);
        this.verifyList(drivers, null, george, henry);
    }

    @Test
    public void updateFactOnRuleFireTest() {
        Cheese camembert = new Cheese("Camembert", 19);
        Cheese cheddar = new Cheese("Cheddar", 45);
        this.ksession.insert((Object)camembert);
        this.ksession.insert((Object)cheddar);
        this.verifyFactsWithQuery(Cheese.class, "cheeseTypes", camembert, cheddar);
        ArrayList expensiveCheese = new ArrayList();
        this.ksession.setGlobal("expensiveCheese", expensiveCheese);
        int firedRules = this.ksession.fireAllRules();
        Assertions.assertThat((int)firedRules).isEqualTo(2);
        this.verifyList(expensiveCheese, camembert, cheddar);
        this.verifyFactsWithQuery(Cheese.class, "cheeseTypes", camembert, cheddar);
        Assertions.assertThat((int)camembert.getPrice()).isEqualTo(21);
        Assertions.assertThat((int)cheddar.getPrice()).isEqualTo(45);
    }

    private <T> void verifyFactsWithQuery(Class<T> expectedClassOfFacts, String queryToGetFacts, T ... factsToVerify) {
        QueryResults results = this.ksession.getQueryResults(queryToGetFacts, new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        QueryResultsRow resultsRow = (QueryResultsRow)results.iterator().next();
        Assertions.assertThat((Object)resultsRow.get("$" + queryToGetFacts)).isInstanceOf(List.class);
        List objects = (List)resultsRow.get("$" + queryToGetFacts);
        Assertions.assertThat((List)objects).hasSize(factsToVerify.length);
        Assertions.assertThat((List)objects).hasOnlyElementsOfType(expectedClassOfFacts);
        Assertions.assertThat((List)objects).containsAll(Arrays.asList(factsToVerify));
    }

    private void verifyWithQueryNoPersonsPresentInFacts() {
        QueryResults results = this.ksession.getQueryResults("persons", new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        results = this.ksession.getQueryResults("persons", new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        QueryResultsRow resultsRow = (QueryResultsRow)results.iterator().next();
        Assertions.assertThat((Object)resultsRow.get("$persons")).isInstanceOf(List.class);
        List persons = (List)resultsRow.get("$persons");
        Assertions.assertThat((List)persons).isEmpty();
    }

    private <T> List<T> verifyFactsPresentInSession(int expectedCountOfFacts, Class<T> expectedClassOfFacts) {
        if (expectedCountOfFacts >= 1) {
            Assertions.assertThat((Iterable)this.ksession.getObjects()).hasSize(expectedCountOfFacts);
            Assertions.assertThat((Iterable)this.ksession.getObjects()).hasOnlyElementsOfType(expectedClassOfFacts);
            return new ArrayList(this.ksession.getObjects());
        }
        Assertions.assertThat((Iterable)this.ksession.getObjects()).isEmpty();
        return null;
    }

    private <T> T verifyFactPresentInSession(FactHandle factToVerify, Class<T> expectedClassOfFact) {
        Assertions.assertThat((Object)this.ksession.getObject(factToVerify)).isNotNull();
        Assertions.assertThat((Object)this.ksession.getObject(factToVerify)).isInstanceOf(expectedClassOfFact);
        return (T)this.ksession.getObject(factToVerify);
    }

    private void verifyCheese(Cheese cheeseToBeVerified, int price, String type) {
        Assertions.assertThat((int)cheeseToBeVerified.getPrice()).isEqualTo(price);
        Assertions.assertThat((String)cheeseToBeVerified.getType()).isEqualTo(type);
    }

    private void verifyPerson(Person original, Person personToBeVerified, int age, String name, boolean shouldBeEqual) {
        if (original != null) {
            if (shouldBeEqual) {
                Assertions.assertThat((Object)personToBeVerified).isEqualTo((Object)original);
            } else {
                Assertions.assertThat((Object)personToBeVerified).isNotEqualTo((Object)original);
            }
        }
        Assertions.assertThat((int)personToBeVerified.getAge()).isEqualTo(age);
        Assertions.assertThat((String)personToBeVerified.getName()).isEqualTo(name);
    }

    private <T> void verifyList(List<T> list, T entryNotToContain, T ... entriesToContain) {
        Assertions.assertThat(list).isNotEmpty();
        Assertions.assertThat(list).hasSize(entriesToContain.length);
        Assertions.assertThat(list).containsAll(Arrays.asList(entriesToContain));
        if (entryNotToContain != null) {
            Assertions.assertThat(list).doesNotContain(new Object[]{entryNotToContain});
        }
    }
}

