/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.concurrency;

import java.util.Collection;
import org.drools.compiler.integrationtests.concurrency.Album;
import org.drools.compiler.integrationtests.concurrency.BaseConcurrencyTest;
import org.drools.compiler.integrationtests.concurrency.Bus;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.test.testcategory.TurtleTestCategory;

@RunWith(value=Parameterized.class)
@Category(value={TurtleTestCategory.class})
public class MVELNumberClassFieldReaderConcurrencyTest
extends BaseConcurrencyTest {
    public MVELNumberClassFieldReaderConcurrencyTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        super(kieBaseTestConfiguration);
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Override
    protected String getDrl() {
        return "package com.example.reproducer\nimport " + Bus.class.getCanonicalName() + ";\ndialect \"mvel\"\nrule R1\n    when\n        $i : Integer()\n        $bus1 : Bus( name.concat(karaoke.dvd[\"POWER PLANT\"].artist).length == $i )\n    then\nend\n";
    }

    @Override
    protected void insertFacts(KieSession kSession) {
        Bus bus1 = new Bus("red", 30);
        bus1.getKaraoke().getDvd().put("POWER PLANT", new Album("POWER PLANT", "GAMMA RAY"));
        bus1.getKaraoke().getDvd().put("Somewhere Out In Space", new Album("Somewhere Out In Space", "GAMMA RAY"));
        kSession.insert((Object)bus1);
        kSession.insert((Object)50);
    }
}

