/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class GeneratedBeansTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public GeneratedBeansTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testGeneratedBeans1() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_GeneratedBeans.drl"});
        FactType cheeseFact = kbase.getFactType("org.drools.generatedbeans", "Cheese");
        Object cheese = cheeseFact.newInstance();
        cheeseFact.set(cheese, "type", (Object)"stilton");
        Assert.assertEquals((Object)"stilton", (Object)cheeseFact.get(cheese, "type"));
        FactType personType = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object ps = personType.newInstance();
        personType.set(ps, "age", (Object)42);
        Map personMap = personType.getAsMap(ps);
        Assert.assertEquals((Object)42, personMap.get("age"));
        personMap.put("age", 43);
        personType.setFromMap(ps, personMap);
        Assert.assertEquals((Object)43, (Object)personType.get(ps, "age"));
        Assert.assertEquals((Object)"stilton", (Object)cheeseFact.getField("type").get(cheese));
        KieSession ksession = kbase.newKieSession();
        Object cg = cheeseFact.newInstance();
        ksession.setGlobal("cg", cg);
        ArrayList result = new ArrayList();
        ksession.setGlobal("list", result);
        ksession.insert(cheese);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)5, result.get(0));
        FactType personFact = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object person = personFact.newInstance();
        personFact.getField("likes").set(person, cheese);
        personFact.getField("age").set(person, (Object)7);
        ksession.insert(person);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)person, result.get(1));
    }

    @Test
    public void testGeneratedBeans2() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_GeneratedBeans2.drl"});
        FactType cheeseFact = kbase.getFactType("org.drools.generatedbeans", "Cheese");
        Object cheese = cheeseFact.newInstance();
        cheeseFact.set(cheese, "type", (Object)"stilton");
        Assert.assertEquals((Object)"stilton", (Object)cheeseFact.get(cheese, "type"));
        Object cheese2 = cheeseFact.newInstance();
        cheeseFact.set(cheese2, "type", (Object)"stilton");
        Assert.assertEquals((Object)cheese, (Object)cheese2);
        FactType personType = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object ps = personType.newInstance();
        personType.set(ps, "name", (Object)"mark");
        personType.set(ps, "last", (Object)"proctor");
        personType.set(ps, "age", (Object)42);
        Object ps2 = personType.newInstance();
        personType.set(ps2, "name", (Object)"mark");
        personType.set(ps2, "last", (Object)"proctor");
        personType.set(ps2, "age", (Object)30);
        Assert.assertEquals((Object)ps, (Object)ps2);
        personType.set(ps2, "last", (Object)"little");
        Assert.assertFalse((boolean)ps.equals(ps2));
        KieSession wm = kbase.newKieSession();
        Object cg = cheeseFact.newInstance();
        wm.setGlobal("cg", cg);
        ArrayList result = new ArrayList();
        wm.setGlobal("list", result);
        wm.insert(cheese);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)5, result.get(0));
        FactType personFact = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object person = personFact.newInstance();
        personFact.getField("likes").set(person, cheese);
        personFact.getField("age").set(person, (Object)7);
        wm.insert(person);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)person, result.get(1));
    }

    @Test
    public void testGeneratedBeansSerializable() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_GeneratedBeansSerializable.drl"});
        FactType cheeseFact = kbase.getFactType("org.drools.generatedbeans", "Cheese");
        Assert.assertTrue((String)"Generated beans must be serializable", (boolean)Serializable.class.isAssignableFrom(cheeseFact.getFactClass()));
        Object cheese = cheeseFact.newInstance();
        cheeseFact.set(cheese, "type", (Object)"stilton");
        Object cheese2 = cheeseFact.newInstance();
        cheeseFact.set(cheese2, "type", (Object)"brie");
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert(cheese);
        ksession.insert(cheese2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)2L, (long)((Number)results.get(0)).intValue());
    }
}

