/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.core.ClockType;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.mvel.compiler.StockTick;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;

@RunWith(value=Parameterized.class)
public class LengthSlidingWindowTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public LengthSlidingWindowTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)false);
    }

    @Test
    public void testSlidingWindowWithAlphaConstraint() {
        String drl = "import " + StockTick.class.getCanonicalName() + "\nglobal java.util.List list;\ndeclare StockTick @role( event ) end\nrule R\nwhen \n   accumulate( StockTick( company == \"RHT\", $price : price ) over window:length( 3 ); $total : sum($price) )\nthen \n    list.add($total);\nend \n";
        this.checkPrice(drl, 30.0);
    }

    @Test
    public void testSlidingWindowWithBetaConstraint() {
        String drl = "import " + StockTick.class.getCanonicalName() + "\nglobal java.util.List list;\ndeclare StockTick @role( event ) end\nrule R\nwhen \n   $s : String()   accumulate( StockTick( company == $s, $price : price ) over window:length( 3 ); $total : sum($price) )\nthen \n    list.add($total);\nend \n";
        this.checkPrice(drl, 10.0);
    }

    @Test
    public void testSlidingWindowWithDeclaration() {
        String drl = "import " + StockTick.class.getCanonicalName() + "\nglobal java.util.List list;\ndeclare StockTick @role( event ) end\ndeclare window RhtStocksWindow\n    StockTick() over window:length( 3 )\nend\nrule R\nwhen \n   accumulate( StockTick( company == \"RHT\", $price : price ) from window RhtStocksWindow; $total : sum($price) )\nthen \n    list.add($total);\nend \n";
        this.checkPrice(drl, 10.0);
    }

    private void checkPrice(String drl, double expectedPrice) {
        KieSessionConfiguration sessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"RHT");
        ksession.insert((Object)new StockTick(1L, "RHT", 10.0));
        ksession.insert((Object)new StockTick(2L, "RHT", 10.0));
        ksession.insert((Object)new StockTick(3L, "ABC", 20.0));
        ksession.insert((Object)new StockTick(4L, "RHT", 10.0));
        ksession.insert((Object)new StockTick(5L, "XYZ", 20.0));
        ksession.insert((Object)new StockTick(6L, "XYZ", 20.0));
        ksession.insert((Object)new StockTick(7L, "RHT", 10.0));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((double)expectedPrice, (double)((Double)list.get(0)), (double)0.01);
    }

    @Test
    public void testCompilationFailureWithUnknownWindow() {
        String drl = "import " + StockTick.class.getCanonicalName() + "\nglobal java.util.List list;\ndeclare StockTick @role( event ) end\ndeclare window RhtStocksWindow\n    StockTick() over window:length( 3 )\nend\nrule R\nwhen \n   accumulate( StockTick( company == \"RHT\", $price : price ) from window AbcStocksWindow; $total : sum($price) )\nthen \n    list.add($total);\nend \n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertEquals((long)1L, (long)kieBuilder.getResults().getMessages().size());
    }
}

