/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.StockTick;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;

@Ignore
public class PhreakConcurrencyTest
extends CommonTestMethodBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleConcurrentEPs() {
        int i;
        boolean PARALLEL = true;
        int EP_NR = 10;
        StringBuilder sb = new StringBuilder();
        sb.append("import org.drools.mvel.compiler.StockTick;\n");
        for (i = 0; i < 10; ++i) {
            sb.append("global java.util.List results").append(i).append(";\n");
        }
        sb.append("declare StockTick\n    @role( event )\nend\n");
        for (i = 0; i < 10; ++i) {
            sb.append("rule \"R" + i + "\"\nwhen\n    $name : String( this.startsWith(\"A\") )\n    $st : StockTick( company == $name, price > 10 ) from entry-point EP" + i + "\nthen\n    results" + i + ".add( $st );\nend\n");
        }
        KieBase kbase = this.loadKnowledgeBaseFromString(sb.toString());
        KieSession ksession = kbase.newKieSession();
        boolean success = true;
        ExecutorService executor = Executors.newFixedThreadPool(10, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        try {
            int i2;
            ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(executor);
            for (i2 = 0; i2 < 10; ++i2) {
                ecs.submit(new EPManipulator(ksession, i2));
            }
            for (i2 = 0; i2 < 10; ++i2) {
                try {
                    success = (Boolean)ecs.take().get() != false && success;
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        finally {
            executor.shutdownNow();
        }
        Assert.assertTrue((boolean)success);
        Assert.assertEquals((long)10L, (long)ksession.fireAllRules());
        for (int i3 = 0; i3 < 10; ++i3) {
            Assert.assertEquals((long)1L, (long)((List)ksession.getGlobal("results" + i3)).size());
        }
        ksession.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testMultipleConcurrentEPs2() {
        String str = "global java.util.List results\n\nrule \"R0\" when\n    $s : String( ) from entry-point EP0\n    $i : Integer( toString().equals($s) ) from entry-point EP1\n    $l : Long( intValue() == $i ) from entry-point EP2\nthen\n    results.add( $s );\nend\n\nrule \"R1\" when\n    $s : String( ) from entry-point EP1\n    $i : Integer( toString().equals($s) ) from entry-point EP2\n    $l : Long( intValue() == $i ) from entry-point EP0\nthen\n    results.add( $s );\nend\n\nrule \"R2\" when\n    $s : String( ) from entry-point EP2\n    $i : Integer( toString().equals($s) ) from entry-point EP0\n    $l : Long( intValue() == $i ) from entry-point EP1\nthen\n    results.add( $s );\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        boolean success = true;
        ExecutorService executor = Executors.newFixedThreadPool(3, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        try {
            int i;
            ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(executor);
            for (i = 0; i < 3; ++i) {
                ecs.submit(new EPManipulator2(ksession, i));
            }
            for (i = 0; i < 3; ++i) {
                try {
                    success = (Boolean)ecs.take().get() != false && success;
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Assert.assertTrue((boolean)success);
            ksession.fireAllRules();
            System.out.println(results);
            Assert.assertEquals((long)3L, (long)results.size());
            for (String s : results) {
                Assert.assertEquals((Object)"2", (Object)s);
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    private KieSession getKieSessionWith3Segments() {
        String str = "global java.util.List results\nrule R1 when\n   String( this == \"1\") from entry-point EP1\n   String( this == \"2\") from entry-point EP2\n   String( this == \"3\") from entry-point EP3\n   String( this == \"4\") from entry-point EP4\n   String( this == \"5\") from entry-point EP5\n   String( this == \"6\") from entry-point EP6\n   String( this == \"7\") from entry-point EP7\n   String( this == \"8\") from entry-point EP8\n   String( this == \"9\") from entry-point EP9\nthen\n   results.add(\"R1\");\nend\n\nrule R2 when\n   String( this == \"1\") from entry-point EP1\n   String( this == \"2\") from entry-point EP2\n   String( this == \"3\") from entry-point EP3\n   eval(true)\n   String( this == \"4\") from entry-point EP4\n   String( this == \"5\") from entry-point EP5\n   String( this == \"6\") from entry-point EP6\n   String( this == \"7\") from entry-point EP7\n   String( this == \"8\") from entry-point EP8\n   String( this == \"9\") from entry-point EP9\nthen\n   results.add(\"R2\");\nend\n\nrule R3 when\n   String( this == \"1\") from entry-point EP1\n   String( this == \"2\") from entry-point EP2\n   String( this == \"3\") from entry-point EP3\n   eval(true)\n   String( this == \"4\") from entry-point EP4\n   String( this == \"5\") from entry-point EP5\n   String( this == \"6\") from entry-point EP6\n   eval(true)\n   String( this == \"7\") from entry-point EP7\n   String( this == \"8\") from entry-point EP8\n   String( this == \"9\") from entry-point EP9\nthen\n   results.add(\"R3\");\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        return kbase.newKieSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleConcurrentEPs3() {
        KieSession ksession = this.getKieSessionWith3Segments();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        EPManipulator3[] epManipulators = new EPManipulator3[9];
        for (int i = 0; i < 9; ++i) {
            epManipulators[i] = new EPManipulator3(ksession, i + 1);
        }
        for (int deleteIndex = 0; deleteIndex < 11; ++deleteIndex) {
            boolean success = true;
            ExecutorService executor = Executors.newFixedThreadPool(9, r -> {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            });
            try {
                int i;
                ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(executor);
                for (i = 0; i < 9; ++i) {
                    ecs.submit(epManipulators[i].setDeleteIndex(deleteIndex % 10));
                }
                for (i = 1; i < 10; ++i) {
                    try {
                        success = (Boolean)ecs.take().get() != false && success;
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                Assert.assertTrue((boolean)success);
                new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
                try {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (Throwable throwable) {
                    ksession.halt();
                    if (deleteIndex % 10 == 0) {
                        Assert.assertEquals((long)3L, (long)results.size());
                        Assert.assertTrue((boolean)results.containsAll(Arrays.asList("R1", "R2", "R3")));
                    } else if (!results.isEmpty()) {
                        Assert.fail((String)("Results should be empty with deleteIndex = " + deleteIndex + "; got " + results.size() + " items"));
                    }
                    results.clear();
                    throw throwable;
                }
                ksession.halt();
                if (deleteIndex % 10 == 0) {
                    Assert.assertEquals((long)3L, (long)results.size());
                    Assert.assertTrue((boolean)results.containsAll(Arrays.asList("R1", "R2", "R3")));
                } else if (!results.isEmpty()) {
                    Assert.fail((String)("Results should be empty with deleteIndex = " + deleteIndex + "; got " + results.size() + " items"));
                }
                results.clear();
                continue;
            }
            finally {
                executor.shutdownNow();
            }
        }
        ksession.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleConcurrentEPs4() {
        KieSession ksession = this.getKieSessionWith3Segments();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        EPManipulator4[] epManipulators = new EPManipulator4[9];
        CyclicBarrier barrier = new CyclicBarrier(9, new SegmentChecker(epManipulators));
        for (int i = 0; i < 9; ++i) {
            epManipulators[i] = new EPManipulator4(ksession, i + 1, barrier);
        }
        new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
        try {
            for (int deleteIndex = 0; deleteIndex < 11; ++deleteIndex) {
                boolean success = true;
                ExecutorService executor = Executors.newFixedThreadPool(9, r -> {
                    Thread t = new Thread(r);
                    t.setDaemon(true);
                    return t;
                });
                try {
                    int i;
                    ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(executor);
                    for (i = 0; i < 9; ++i) {
                        ecs.submit(epManipulators[i].setDeleteIndex(deleteIndex % 10));
                    }
                    for (i = 0; i < 9; ++i) {
                        try {
                            success = (Boolean)ecs.take().get() != false && success;
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    Assert.assertTrue((boolean)success);
                    continue;
                }
                finally {
                    executor.shutdownNow();
                }
            }
        }
        finally {
            ksession.halt();
            ksession.dispose();
        }
    }

    @Test
    public void testFactLeak() throws InterruptedException {
        for (int i = 0; i < 100; ++i) {
            this.doFactLeak();
            System.gc();
            Thread.sleep(200L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFactLeak() throws InterruptedException {
        int j;
        String drl = "package org.drools.test; \nglobal " + ConcurrentLinkedQueue.class.getCanonicalName() + " list; \nrule Intx when\n $x : Integer() from entry-point \"x\" \nthen\n list.add( $x );end";
        int N = 1100;
        KieBase kb = this.loadKnowledgeBaseFromString(drl);
        KieSession ks = kb.newKieSession();
        ConcurrentLinkedQueue list = new ConcurrentLinkedQueue();
        AtomicInteger counter = new AtomicInteger(0);
        ks.setGlobal("list", list);
        new Thread(() -> ((KieSession)ks).fireUntilHalt()).start();
        try {
            for (j = 0; j < N; ++j) {
                ks.getEntryPoint("x").insert((Object)new Integer(j));
            }
            int count = 0;
            while (list.size() != N && count++ != 1000) {
                Thread.sleep(200L);
            }
        }
        finally {
            ks.halt();
            if (list.size() != N) {
                for (j = 0; j < N; ++j) {
                    if (list.contains(new Integer(j))) continue;
                    System.out.println("missed: " + j);
                }
            }
            Assert.assertEquals((long)N, (long)list.size());
            ks.dispose();
        }
    }

    public static class SegmentChecker
    implements Runnable {
        private final EPManipulator4[] epManipulators;
        private PathMemory[] pathMemories;

        public SegmentChecker(EPManipulator4[] epManipulators) {
            this.epManipulators = epManipulators;
        }

        @Override
        public void run() {
            System.out.println("Sync point");
            if (this.pathMemories == null) {
                this.initPathMemories();
            }
            String s = "";
            for (int i = 0; i < this.epManipulators.length; ++i) {
                s = this.epManipulators[i].isInserted() ? "1" + s : "0" + s;
            }
            System.out.println("Inserted facts mask = " + s);
            SegmentMemory s0 = this.pathMemories[0].getSegmentMemories()[0];
            SegmentMemory s1 = this.pathMemories[0].getSegmentMemories()[1];
            SegmentMemory s2 = this.pathMemories[1].getSegmentMemories()[1];
            SegmentMemory s3 = this.pathMemories[1].getSegmentMemories()[2];
            SegmentMemory s4 = this.pathMemories[2].getSegmentMemories()[2];
            long s0Mask = 1L;
            long s1Mask = 0L;
            long s2Mask = 0L;
            long s3Mask = 0L;
            long s4Mask = 0L;
            if (this.epManipulators[0].isInserted()) {
                s0Mask |= 2L;
            }
            if (this.epManipulators[1].isInserted()) {
                s0Mask |= 4L;
            }
            if (this.epManipulators[2].isInserted()) {
                s0Mask |= 8L;
            }
            if (this.epManipulators[3].isInserted()) {
                s1Mask |= 1L;
                s2Mask |= 2L;
            }
            if (this.epManipulators[4].isInserted()) {
                s1Mask |= 2L;
                s2Mask |= 4L;
            }
            if (this.epManipulators[5].isInserted()) {
                s1Mask |= 4L;
                s2Mask |= 8L;
            }
            if (this.epManipulators[6].isInserted()) {
                s1Mask |= 8L;
                s3Mask |= 1L;
                s4Mask |= 2L;
            }
            if (this.epManipulators[7].isInserted()) {
                s1Mask |= 0x10L;
                s3Mask |= 2L;
                s4Mask |= 4L;
            }
            if (this.epManipulators[8].isInserted()) {
                s1Mask |= 0x20L;
                s3Mask |= 4L;
                s4Mask |= 8L;
            }
            Assert.assertEquals((long)s0Mask, (long)s0.getLinkedNodeMask());
            Assert.assertEquals((long)s1Mask, (long)s1.getLinkedNodeMask());
            Assert.assertEquals((long)s2Mask, (long)s2.getLinkedNodeMask());
            Assert.assertEquals((long)s3Mask, (long)s3.getLinkedNodeMask());
            Assert.assertEquals((long)s4Mask, (long)s4.getLinkedNodeMask());
            long p0Mask = 0L;
            long p1Mask = 0L;
            long p2Mask = 0L;
            if ((s0Mask & 0xFL) == 15L) {
                Assert.assertTrue((boolean)s0.isSegmentLinked());
                p0Mask |= 1L;
                p1Mask |= 1L;
                p2Mask |= 1L;
            } else {
                Assert.assertFalse((boolean)s0.isSegmentLinked());
            }
            if ((s1Mask & 0x3FL) == 63L) {
                Assert.assertTrue((boolean)s1.isSegmentLinked());
                p0Mask |= 2L;
            } else {
                Assert.assertFalse((boolean)s1.isSegmentLinked());
            }
            if ((s2Mask & 0xEL) == 14L) {
                Assert.assertTrue((boolean)s2.isSegmentLinked());
                p1Mask |= 2L;
                p2Mask |= 2L;
            } else {
                Assert.assertFalse((boolean)s2.isSegmentLinked());
            }
            if ((s3Mask & 7L) == 7L) {
                Assert.assertTrue((boolean)s3.isSegmentLinked());
                p1Mask |= 4L;
            } else {
                Assert.assertFalse((boolean)s3.isSegmentLinked());
            }
            if ((s4Mask & 0xEL) == 14L) {
                Assert.assertTrue((boolean)s4.isSegmentLinked());
                p2Mask |= 4L;
            } else {
                Assert.assertFalse((boolean)s4.isSegmentLinked());
            }
            Assert.assertEquals((Object)(p0Mask == 3L ? 1 : 0), (Object)this.pathMemories[0].isRuleLinked());
            Assert.assertEquals((Object)(p1Mask == 7L ? 1 : 0), (Object)this.pathMemories[1].isRuleLinked());
            Assert.assertEquals((Object)(p2Mask == 7L ? 1 : 0), (Object)this.pathMemories[2].isRuleLinked());
        }

        private void initPathMemories() {
            this.pathMemories = new PathMemory[3];
            NamedEntryPoint ep = (NamedEntryPoint)this.epManipulators[8].getEntryPoiny();
            InternalWorkingMemory wm = ep.getInternalWorkingMemory();
            ObjectTypeNode otn = (ObjectTypeNode)ep.getEntryPointNode().getObjectTypeNodes().values().iterator().next();
            AlphaNode alpha = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
            ObjectSink[] sinks = alpha.getObjectSinkPropagator().getSinks();
            for (int i = 0; i < sinks.length; ++i) {
                BetaNode beta = (BetaNode)sinks[i];
                RuleTerminalNode rtn = (RuleTerminalNode)beta.getSinkPropagator().getSinks()[0];
                this.pathMemories[i] = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
            }
        }
    }

    public static class EPManipulator4
    implements Callable<Boolean> {
        private static final Random RANDOM = new Random();
        private final KieSession ksession;
        private final int index;
        private final CyclicBarrier barrier;
        private int deleteIndex;
        private FactHandle fh = null;
        private final EntryPoint ep;

        public EPManipulator4(KieSession ksession, int index, CyclicBarrier barrier) {
            this.ksession = ksession;
            this.index = index;
            this.barrier = barrier;
            this.ep = ksession.getEntryPoint("EP" + index);
        }

        @Override
        public Boolean call() throws Exception {
            for (int i = 0; i < 100; ++i) {
                Thread.sleep(RANDOM.nextInt(100));
                if (this.fh == null) {
                    this.fh = this.ep.insert((Object)("" + this.index));
                } else if (RANDOM.nextInt(100) < 70) {
                    this.ep.delete(this.fh);
                    this.fh = null;
                } else {
                    this.ep.update(this.fh, (Object)("" + this.index));
                }
                if (i % 10 != 9) continue;
                if (!this.barrier.isBroken()) {
                    this.barrier.await();
                    continue;
                }
                Assert.fail((String)"This is not a bug in phreak synchronization, but a for some reason the barrier is broken, run the test again");
                return false;
            }
            if (this.index == this.deleteIndex) {
                if (this.fh != null) {
                    this.ep.delete(this.fh);
                    this.fh = null;
                }
            } else if (this.fh == null) {
                this.fh = this.ep.insert((Object)("" + this.index));
            }
            return true;
        }

        public EPManipulator4 setDeleteIndex(int deleteIndex) {
            this.deleteIndex = deleteIndex;
            return this;
        }

        public boolean isInserted() {
            return this.fh != null;
        }

        public CyclicBarrier getBarrier() {
            return this.barrier;
        }

        public EntryPoint getEntryPoiny() {
            return this.ep;
        }
    }

    public static class EPManipulator3
    implements Callable<Boolean> {
        private static final Random RANDOM = new Random(0L);
        private final KieSession ksession;
        private final int index;
        private int deleteIndex;
        private FactHandle fh = null;

        public EPManipulator3(KieSession ksession, int index) {
            this.ksession = ksession;
            this.index = index;
        }

        @Override
        public Boolean call() throws Exception {
            EntryPoint ep = this.ksession.getEntryPoint("EP" + this.index);
            InternalWorkingMemory wm = ((NamedEntryPoint)ep).getInternalWorkingMemory();
            ObjectTypeNode otn = (ObjectTypeNode)((NamedEntryPoint)ep).getEntryPointNode().getObjectTypeNodes().values().iterator().next();
            AlphaNode alpha = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
            BetaNode beta = (BetaNode)alpha.getObjectSinkPropagator().getSinks()[0];
            BetaMemory memory = (BetaMemory)wm.getNodeMemory((MemoryFactory)beta);
            memory.getSegmentMemory();
            for (int i = 0; i < 100; ++i) {
                Thread.sleep(RANDOM.nextInt(100));
                if (this.fh == null) {
                    this.fh = ep.insert((Object)("" + this.index));
                    continue;
                }
                if (RANDOM.nextInt(100) < 70) {
                    ep.delete(this.fh);
                    this.fh = null;
                    continue;
                }
                ep.update(this.fh, (Object)("" + this.index));
            }
            if (this.index == this.deleteIndex) {
                if (this.fh != null) {
                    ep.delete(this.fh);
                    this.fh = null;
                }
            } else if (this.fh == null) {
                this.fh = ep.insert((Object)("" + this.index));
            }
            return true;
        }

        public EPManipulator3 setDeleteIndex(int deleteIndex) {
            this.deleteIndex = deleteIndex;
            return this;
        }
    }

    public static class EPManipulator2
    implements Callable<Boolean> {
        private final KieSession ksession;
        private final int index;

        public EPManipulator2(KieSession ksession, int index) {
            this.ksession = ksession;
            this.index = index;
        }

        @Override
        public Boolean call() throws Exception {
            EntryPoint ep = this.ksession.getEntryPoint("EP" + this.index);
            FactHandle[] fhs = new FactHandle[15];
            for (int j = 0; j < 3; ++j) {
                int i;
                for (i = 0; i < 5; ++i) {
                    fhs[i * 3] = ep.insert((Object)("" + i));
                    fhs[i * 3 + 1] = ep.insert((Object)new Long(i));
                    fhs[i * 3 + 2] = ep.insert((Object)new Integer(i));
                }
                for (i = 0; i < 5; ++i) {
                    if (i == this.index + j) continue;
                    ep.delete(fhs[i * 3]);
                    ep.delete(fhs[i * 3 + 1]);
                    ep.delete(fhs[i * 3 + 2]);
                }
            }
            return true;
        }
    }

    public static class EPManipulator
    implements Callable<Boolean> {
        private final KieSession ksession;
        private final int index;

        public EPManipulator(KieSession ksession, int index) {
            this.ksession = ksession;
            this.index = index;
        }

        @Override
        public Boolean call() throws Exception {
            ArrayList results = new ArrayList();
            this.ksession.setGlobal("results" + this.index, results);
            this.ksession.insert((Object)("ACME" + this.index));
            EntryPoint ep = this.ksession.getEntryPoint("EP" + this.index);
            for (int i = 0; i < 12; ++i) {
                ep.insert((Object)new StockTick(1L, "ACME" + this.index, i - 50));
                ep.insert((Object)new StockTick(2L, "DROO" + this.index, i));
                ep.insert((Object)new StockTick(3L, "ACME" + this.index, i));
            }
            return true;
        }
    }
}

