/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.base.UndefinedCalendarExcption;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class TimerAndCalendarExceptionTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public TimerAndCalendarExceptionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @Test(timeout=10000L)
    public void testUnknownProtocol() {
        this.wrongTimerExpression("xyz:30");
    }

    @Test(timeout=10000L)
    public void testMissingColon() {
        this.wrongTimerExpression("int 30");
    }

    @Test(timeout=10000L)
    public void testMalformedExpression() {
        this.wrongTimerExpression("30s s30");
    }

    @Test(timeout=10000L)
    public void testMalformedIntExpression() {
        this.wrongTimerExpression("int 30s");
    }

    @Test(timeout=10000L)
    public void testMalformedCronExpression() {
        this.wrongTimerExpression("cron: 0/30 * * * * *");
    }

    private void wrongTimerExpression(String timer) {
        String drl = "package org.simple \nrule xxx \n  timer (" + timer + ") when \nthen \nend  \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUndefinedCalendar() {
        String drl = "rule xxx \n  calendars \"cal1\"\nwhen \nthen \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule xxx \n  calendars \"cal1\"\nwhen \nthen \nend  \n"});
        KieSession ksession = kbase.newKieSession();
        try {
            try {
                ksession.fireAllRules();
                Assert.fail((String)"should throw UndefinedCalendarExcption");
            }
            catch (UndefinedCalendarExcption undefinedCalendarExcption) {
                // empty catch block
            }
        }
        finally {
            ksession.dispose();
        }
    }
}

