/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.util.Collection;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class CommentTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public CommentTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testCommentDelimiterInString() {
        String drl = "rule x\ndialect \"mvel\"\nwhen\nthen\nSystem.out.println( \"/*\" );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"comment-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule x\ndialect \"mvel\"\nwhen\nthen\nSystem.out.println( \"/*\" );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ksession.dispose();
    }

    @Test
    public void testCommentWithCommaInRHS() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nrule R1 when\n   $p : Person( age < name.length ) \nthen\n   insertLogical(new Person(\"Mario\",\n       // this is the age,\n       38));end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"comment-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.dispose();
    }
}

