/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.builder.impl;

import java.io.File;
import java.io.IOException;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class KnowledgeBuilderImplTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testCreateDumpDrlGeneratedFileRemovingInvalidCharacters() throws Exception {
        File dumpDir = this.temporaryFolder.getRoot();
        MatcherAssert.assertThat((Object)KnowledgeBuilderImpl.createDumpDrlFile((File)dumpDir, (String)"xxx", (String)".drl"), (Matcher)KnowledgeBuilderImplTest.fileEndsWith(File.separator + "xxx.drl"));
        MatcherAssert.assertThat((Object)KnowledgeBuilderImpl.createDumpDrlFile((File)dumpDir, (String)"x?x?", (String)".drl"), (Matcher)KnowledgeBuilderImplTest.fileEndsWith(File.separator + "x_x_.drl"));
        MatcherAssert.assertThat((Object)KnowledgeBuilderImpl.createDumpDrlFile((File)dumpDir, (String)"x/x/", (String)".drl"), (Matcher)KnowledgeBuilderImplTest.fileEndsWith(File.separator + "x_x_.drl"));
        MatcherAssert.assertThat((Object)KnowledgeBuilderImpl.createDumpDrlFile((File)dumpDir, (String)"x\\x\\", (String)".drl"), (Matcher)KnowledgeBuilderImplTest.fileEndsWith(File.separator + "x_x_.drl"));
        MatcherAssert.assertThat((Object)KnowledgeBuilderImpl.createDumpDrlFile((File)dumpDir, (String)"x*x*", (String)".drl"), (Matcher)KnowledgeBuilderImplTest.fileEndsWith(File.separator + "x_x_.drl"));
        MatcherAssert.assertThat((Object)KnowledgeBuilderImpl.createDumpDrlFile((File)dumpDir, (String)"aa.AA01-_", (String)".drl"), (Matcher)KnowledgeBuilderImplTest.fileEndsWith(File.separator + "aa.AA01-_.drl"));
    }

    private static FileEndsWithMatcher fileEndsWith(String endsWithString) {
        return new FileEndsWithMatcher(endsWithString);
    }

    private static class FileEndsWithMatcher
    extends BaseMatcher<File> {
        private final String endsWithString;

        private FileEndsWithMatcher(String endsWithString) {
            this.endsWithString = endsWithString;
        }

        public boolean matches(Object item) {
            if (item instanceof File) {
                try {
                    return ((File)item).getCanonicalPath().endsWith(this.endsWithString);
                }
                catch (IOException e) {
                    return false;
                }
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendValue((Object)this.endsWithString);
        }
    }
}

