/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.runtime.pipeline.impl;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import com.sun.xml.bind.v2.util.XmlFactory;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.SchemaFactory;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.io.KieResources;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.JaxbConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class DroolsJaxbHelperXSDInKJARTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final Logger LOG = LoggerFactory.getLogger(DroolsJaxbHelperXSDInKJARTest.class);
    private static final String simpleXsdRelativePath = "simple.xsd";

    public DroolsJaxbHelperXSDInKJARTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testInternalsDryRun() {
        System.getProperties().entrySet().forEach(e -> LOG.debug("{}", e));
        LOG.info("{}", SAXParserFactory.newInstance().getClass());
        LOG.info("{}", SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").getClass());
        LOG.info("{}", XmlFactory.createSchemaFactory((String)"http://www.w3.org/2001/XMLSchema", (boolean)false).getClass());
    }

    @Test
    public void testXsdModelInKJAR() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieResources kieResources = ks.getResources();
        Options xjcOpts = new Options();
        xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
        JaxbConfiguration jaxbConfiguration = KnowledgeBuilderFactory.newJaxbConfiguration((Options)xjcOpts, (String)"xsd");
        kfs.write(kieResources.newClassPathResource(simpleXsdRelativePath, this.getClass()).setResourceType(ResourceType.XSD).setConfiguration((ResourceConfiguration)jaxbConfiguration));
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        if (!errors.isEmpty()) {
            Assert.fail((String)("" + errors));
        }
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        Assert.assertNotNull((Object)ksession);
    }
}

