/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.simulation;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.drools.core.fluent.impl.ExecutableBuilderImpl;
import org.drools.mvel.compiler.Message;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;
import org.kie.internal.builder.fluent.ExecutableBuilder;
import org.kie.internal.builder.fluent.KieSessionFluent;
import org.kie.internal.builder.fluent.Scope;

@RunWith(value=Parameterized.class)
public class BatchRunFluentTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    String header = "package org.drools.mvel.compiler\nimport " + Message.class.getCanonicalName() + "\n";
    String drl1 = "global String outS;\nglobal String outS2;\nglobal Long timeNow;\nrule R1\nwhen\n   s : String()\nthen\n    kcontext.getKnowledgeRuntime().setGlobal(\"outS\", s);\n    kcontext.getKnowledgeRuntime().setGlobal(\"timeNow\", kcontext.getKnowledgeRuntime().getSessionClock().getCurrentTime() );\nend\n\nrule R2\nagenda-group \"agenda2\"\nwhen\n   s : String()\nthen\n    kcontext.getKnowledgeRuntime().setGlobal(\"outS2\", s);\nend\n";
    String id = "org.kie";
    ReleaseId releaseId;

    public BatchRunFluentTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true, (boolean)true);
    }

    @Before
    public void setUp() {
        this.releaseId = KieUtil.generateReleaseId((String)this.id);
        List resources = KieUtil.getResourcesFromDrls((String[])new String[]{this.header + this.drl1});
        KieUtil.getKieModuleFromResources((ReleaseId)this.releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (Resource[])resources.toArray(new Resource[0]));
    }

    @Test
    public void testOutName() {
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)f.newApplicationContext("app1")).getKieContainer(this.releaseId).newSession().insert((Object)"h1")).fireAllRules()).getGlobal("outS")).out("outS")).dispose();
        RequestContext requestContext = (RequestContext)ExecutableRunner.create().execute(f.getExecutable());
        Assert.assertEquals((Object)"h1", requestContext.getOutputs().get("outS"));
    }

    @Test
    public void testOutWithPriorSetAndNoName() {
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)f.newApplicationContext("app1")).getKieContainer(this.releaseId).newSession().insert((Object)"h1")).fireAllRules()).getGlobal("outS")).set("outS")).out()).dispose();
        RequestContext requestContext = (RequestContext)ExecutableRunner.create().execute(f.getExecutable());
        Assert.assertEquals((Object)"h1", requestContext.getOutputs().get("outS"));
        Assert.assertEquals((Object)"h1", (Object)requestContext.get("outS"));
    }

    @Test
    public void testSetAndOutBehaviour() {
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)f.newApplicationContext("app1")).getKieContainer(this.releaseId).newSession().insert((Object)"h1")).fireAllRules()).getGlobal("outS")).set("outS")).getGlobal("outS")).set("outS1")).out()).dispose();
        RequestContext requestContext = (RequestContext)ExecutableRunner.create().execute(f.getExecutable());
        Assert.assertNull(requestContext.getOutputs().get("outS"));
        Assert.assertEquals((Object)"h1", (Object)requestContext.get("outS"));
        Assert.assertNotNull(requestContext.getOutputs().get("outS1"));
        Assert.assertEquals((Object)requestContext.get("outS1"), requestContext.getOutputs().get("outS1"));
        Assert.assertEquals((Object)requestContext.get("outS"), (Object)requestContext.get("outS1"));
    }

    @Test
    public void testOutWithoutPriorSetAndNoName() {
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)f.newApplicationContext("app1")).getKieContainer(this.releaseId).newSession().insert((Object)"h1")).fireAllRules()).getGlobal("outS")).out()).dispose();
        try {
            RequestContext requestContext = (RequestContext)ExecutableRunner.create().execute(f.getExecutable());
            Assert.assertEquals((Object)"h1", (Object)requestContext.get("out1"));
            Assert.fail((String)"Must throw Exception, as no prior set was called and no name given to out");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSetAndGetWithCommandRegisterWithEnds() {
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)((KieSessionFluent)((ExecutableBuilder)((KieSessionFluent)((ExecutableBuilder)f.newApplicationContext("app1")).getKieContainer(this.releaseId).newSession().set("s1")).end()).getKieContainer(this.releaseId).newSession().set("s2")).end()).get("s1", KieSessionFluent.class)).insert((Object)"h1")).fireAllRules()).end()).get("s2", KieSessionFluent.class)).insert((Object)"h2")).fireAllRules()).end()).get("s1", KieSessionFluent.class)).getGlobal("outS")).out("outS1")).dispose()).get("s2", KieSessionFluent.class)).getGlobal("outS")).out("outS2")).dispose();
        RequestContext requestContext = (RequestContext)ExecutableRunner.create().execute(f.getExecutable());
        Assert.assertEquals((Object)"h1", requestContext.getOutputs().get("outS1"));
        Assert.assertEquals((Object)"h2", requestContext.getOutputs().get("outS2"));
    }

    @Test
    public void testSetAndGetWithCommandRegisterWithoutEnds() {
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)((KieSessionFluent)((ExecutableBuilder)f.newApplicationContext("app1")).getKieContainer(this.releaseId).newSession().set("s1")).end()).getKieContainer(this.releaseId).newSession().set("s2")).get("s1", KieSessionFluent.class)).insert((Object)"h1")).fireAllRules()).get("s2", KieSessionFluent.class)).insert((Object)"h2")).fireAllRules()).get("s1", KieSessionFluent.class)).getGlobal("outS")).out("outS1")).dispose()).get("s2", KieSessionFluent.class)).getGlobal("outS")).out("outS2")).dispose();
        RequestContext requestContext = (RequestContext)ExecutableRunner.create().execute(f.getExecutable());
        Assert.assertEquals((Object)"h1", requestContext.getOutputs().get("outS1"));
        Assert.assertEquals((Object)"h2", requestContext.getOutputs().get("outS2"));
    }

    @Test
    public void testDifferentConversationIds() {
        ExecutableRunner runner = ExecutableRunner.create();
        RequestContext requestContext = (RequestContext)runner.createContext();
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)((ExecutableBuilder)f.newApplicationContext("app1")).startConversation()).getKieContainer(this.releaseId).newSession().insert((Object)"h1")).fireAllRules()).dispose();
        runner.execute(f.getExecutable(), (Context)requestContext);
        String conversationId = requestContext.getConversationContext().getName();
        runner.execute(f.getExecutable(), (Context)requestContext);
        Assert.assertNotEquals((Object)conversationId, (Object)requestContext.getConversationContext().getName());
    }

    @Test
    public void testRequestScope() {
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)f.newApplicationContext("app1")).getKieContainer(this.releaseId).newSession().insert((Object)"h1")).fireAllRules()).getGlobal("outS")).set("outS1")).dispose();
        RequestContext requestContext = (RequestContext)ExecutableRunner.create().execute(f.getExecutable());
        Assert.assertNull((Object)requestContext.get("outS"));
        Assert.assertNull(requestContext.getOutputs().get("outS1"));
        Assert.assertNull((Object)requestContext.getApplicationContext().get("outS1"));
        Assert.assertNull((Object)requestContext.getConversationContext());
        Assert.assertEquals((Object)"h1", (Object)requestContext.get("outS1"));
    }

    @Test
    public void testApplicationScope() {
        ExecutableRunner runner = ExecutableRunner.create();
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)f.newApplicationContext("app1")).getKieContainer(this.releaseId).newSession().insert((Object)"h1")).fireAllRules()).getGlobal("outS")).set("outS1", Scope.APPLICATION)).dispose();
        RequestContext requestContext = (RequestContext)runner.execute(f.getExecutable());
        Assert.assertEquals(null, (Object)requestContext.get("outS"));
        Assert.assertEquals((Object)"h1", (Object)requestContext.getApplicationContext().get("outS1"));
        f = new ExecutableBuilderImpl();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)f.getApplicationContext("app1")).getKieContainer(this.releaseId).newSession().insert((Object)"h2")).fireAllRules()).getGlobal("outS")).set("outS2", Scope.APPLICATION)).dispose();
        requestContext = (RequestContext)runner.execute(f.getExecutable());
        Assert.assertEquals((Object)"h1", (Object)requestContext.getApplicationContext().get("outS1"));
        Assert.assertEquals((Object)"h2", (Object)requestContext.getApplicationContext().get("outS2"));
    }

    @Test
    public void testConversationScope() {
        ExecutableRunner runner = ExecutableRunner.create();
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)((ExecutableBuilder)f.newApplicationContext("app1")).startConversation()).getKieContainer(this.releaseId).newSession().insert((Object)"h1")).fireAllRules()).getGlobal("outS")).set("outS1", Scope.CONVERSATION)).dispose();
        RequestContext requestContext = (RequestContext)runner.execute(f.getExecutable());
        Assert.assertEquals(null, (Object)requestContext.get("outS"));
        String conversationId = requestContext.getConversationContext().getName();
        Assert.assertEquals((Object)"h1", (Object)requestContext.getConversationContext().get("outS1"));
        f = new ExecutableBuilderImpl();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)((ExecutableBuilder)f.getApplicationContext("app1")).joinConversation(conversationId)).getKieContainer(this.releaseId).newSession().insert((Object)"h2")).fireAllRules()).getGlobal("outS")).set("outS2", Scope.CONVERSATION)).dispose();
        requestContext = (RequestContext)runner.execute(f.getExecutable());
        Assert.assertEquals((Object)"h1", (Object)requestContext.getConversationContext().get("outS1"));
        Assert.assertEquals((Object)"h2", (Object)requestContext.getConversationContext().get("outS2"));
        f = new ExecutableBuilderImpl();
        f.endConversation(conversationId);
        requestContext = (RequestContext)runner.execute(f.getExecutable());
        Assert.assertNull((Object)requestContext.getConversationContext());
    }

    @Test
    public void testContextScopeSearching() {
        ExecutableRunner runner = ExecutableRunner.create();
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)f.newApplicationContext("app1")).getKieContainer(this.releaseId).newSession().insert((Object)"h1")).fireAllRules()).getGlobal("outS")).set("outS1", Scope.APPLICATION)).get("outS1")).out()).dispose();
        RequestContext requestContext = (RequestContext)runner.execute(f.getExecutable());
        Assert.assertEquals((Object)"h1", (Object)requestContext.get("outS1"));
        Assert.assertEquals((Object)"h1", (Object)requestContext.getApplicationContext().get("outS1"));
        Assert.assertEquals((Object)"h1", (Object)requestContext.get("outS1"));
        f = new ExecutableBuilderImpl();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)((ExecutableBuilder)f.getApplicationContext("app1")).startConversation()).getKieContainer(this.releaseId).newSession().insert((Object)"h2")).fireAllRules()).getGlobal("outS")).set("outS1", Scope.CONVERSATION)).get("outS1")).out()).dispose();
        requestContext = (RequestContext)runner.execute(f.getExecutable());
        Assert.assertEquals((Object)"h2", (Object)requestContext.get("outS1"));
        Assert.assertEquals((Object)"h1", (Object)requestContext.getApplicationContext().get("outS1"));
        Assert.assertEquals((Object)"h2", (Object)requestContext.getConversationContext().get("outS1"));
        Assert.assertEquals((Object)"h2", (Object)requestContext.get("outS1"));
        f = new ExecutableBuilderImpl();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)((ExecutableBuilder)f.getApplicationContext("app1")).joinConversation(requestContext.getConversationContext().getName())).getKieContainer(this.releaseId).newSession().insert((Object)"h3")).fireAllRules()).getGlobal("outS")).set("outS1", Scope.REQUEST)).get("outS1")).out()).dispose();
        requestContext = (RequestContext)runner.execute(f.getExecutable());
        Assert.assertEquals((Object)"h3", (Object)requestContext.get("outS1"));
        Assert.assertEquals((Object)"h1", (Object)requestContext.getApplicationContext().get("outS1"));
        Assert.assertEquals((Object)"h2", (Object)requestContext.getConversationContext().get("outS1"));
        Assert.assertEquals((Object)"h3", (Object)requestContext.get("outS1"));
    }

    @Test
    public void testAfter() {
        ExecutableRunner runner = ExecutableRunner.create((long)0L);
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)((ExecutableBuilder)((ExecutableBuilder)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)((ExecutableBuilder)f.after(1000L)).newApplicationContext("app1")).getKieContainer(this.releaseId).newSession().insert((Object)"h1")).fireAllRules()).getGlobal("outS")).out("outS1")).getGlobal("timeNow")).out("timeNow1")).dispose()).after(2000L)).newApplicationContext("app1")).getKieContainer(this.releaseId).newSession().insert((Object)"h1")).fireAllRules()).getGlobal("outS")).out("outS2")).getGlobal("timeNow")).out("timeNow2")).dispose();
        RequestContext requestContext = (RequestContext)runner.execute(f.getExecutable());
        Assert.assertEquals((Object)1000L, requestContext.getOutputs().get("timeNow1"));
        Assert.assertEquals((Object)2000L, requestContext.getOutputs().get("timeNow2"));
    }

    @Test
    public void testSetKieContainerTest() {
        KieServices kieServices = KieServices.Factory.get();
        KieContainer kieContainer = kieServices.newKieContainer(this.releaseId);
        ExecutableRunner runner = ExecutableRunner.create((long)0L);
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)f.newApplicationContext("app1")).setKieContainer(kieContainer).newSession().insert((Object)"h1")).fireAllRules()).getGlobal("outS")).out("outS1")).dispose();
        RequestContext requestContext = (RequestContext)runner.execute(f.getExecutable());
        Assert.assertEquals((Object)"h1", requestContext.getOutputs().get("outS1"));
    }

    @Test
    public void testKieSessionCustomizationTest() {
        ExecutableRunner runner = ExecutableRunner.create((long)0L);
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)f.newApplicationContext("app1")).getKieContainer(this.releaseId).newSessionCustomized(null, (sessionName, kieContainer) -> kieContainer.getKieSessionConfiguration(sessionName)).insert((Object)"h1")).fireAllRules()).getGlobal("outS")).out("outS1")).dispose();
        RequestContext requestContext = (RequestContext)runner.execute(f.getExecutable());
        Assert.assertEquals((Object)"h1", requestContext.getOutputs().get("outS1"));
    }

    @Test
    public void testKieSessionByName() {
        ExecutableRunner runner = ExecutableRunner.create((long)0L);
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)f.newApplicationContext("app1")).getKieContainer(this.releaseId).newSession("KieSessionModelName").insert((Object)"h1")).fireAllRules()).getGlobal("outS")).out("outS1")).dispose();
        RequestContext requestContext = (RequestContext)runner.execute(f.getExecutable());
        Assert.assertEquals((Object)"h1", requestContext.getOutputs().get("outS1"));
    }

    @Test
    public void testAgendaGroup() {
        ExecutableRunner runner = ExecutableRunner.create((long)0L);
        ExecutableBuilder f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)f.newApplicationContext("app1")).getKieContainer(this.releaseId).newSession().insert((Object)"h1")).fireAllRules()).getGlobal("outS2")).out("outS2")).dispose();
        RequestContext requestContext = (RequestContext)runner.execute(f.getExecutable());
        Assert.assertNotEquals((Object)"h1", requestContext.getOutputs().get("outS2"));
        f = ExecutableBuilder.create();
        ((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((KieSessionFluent)((ExecutableBuilder)f.newApplicationContext("app1")).getKieContainer(this.releaseId).newSession().setActiveAgendaGroup("agenda2")).insert((Object)"h1")).fireAllRules()).getGlobal("outS2")).out("outS2")).dispose();
        requestContext = (RequestContext)runner.execute(f.getExecutable());
        Assert.assertEquals((Object)"h1", requestContext.getOutputs().get("outS2"));
    }
}

