/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.lang.reflect.Field;
import java.util.Collection;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.mvel.compiler.Message;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.io.ResourceFactory;

@RunWith(value=Parameterized.class)
public class DynamicRuleLoadTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private final String drl1 = "package org.drools.mvel.compiler\nrule R1 when\n   Message( $m : message )\nthen\n    System.out.println($m);\nend\n";
    private final String drl2_1 = "package org.drools.mvel.compiler\nglobal " + DynamicRuleLoadTest.class.getCanonicalName() + " test;\nrule R2_1 when\n   $m : Message( message == \"Hi Universe\" )\nthen\n    test.updateToVersion();end\n";
    private final String drl2_2 = "package org.drools.mvel.compiler\nglobal " + DynamicRuleLoadTest.class.getCanonicalName() + " test;\nrule R2_2 when\n   $m : Message( message == \"Hello World\" )\nthen\n    test.done();end\n";
    private final String javaSrc = "package org.drools.mvel.compiler.test;\npublic class PersonObject {\n    private String id;\n    public String getId() {\n        return id;\n    }\n    public void setId(String id) {\n        this.id = id;\n    }\n    public void updateId() {\n        this.id = \"Person from version 1\";\n    }\n}";
    private final String javaSrc_2 = "package org.drools.mvel.compiler.test;\npublic class PersonObject {\n    private String id;\n    public String getId() {\n        return id;\n    }\n    public void setId(String id) {\n        this.id = id;\n    }\n    public void updateId() {\n        this.id = \"Person from version 2\";\n    }\n}";
    private final String person_drl = "package org.drools.mvel.compiler.test\nimport org.drools.mvel.compiler.test.PersonObject;\n\nrule \"Update person's id\"\nwhen\n    $person : PersonObject()\nthen\n    $person.updateId();\n    delete($person);\nend";
    private KieContainer kieContainer;
    private KieSession ksession;
    private boolean done = false;

    public DynamicRuleLoadTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testKJarUpgrade() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieModule km = KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.mvel.compiler\nrule R1 when\n   Message( $m : message )\nthen\n    System.out.println($m);\nend\n", this.drl2_1});
        this.kieContainer = ks.newKieContainer(km.getReleaseId());
        this.ksession = this.kieContainer.newKieSession();
        this.ksession.setGlobal("test", (Object)this);
        this.ksession.insert((Object)new Message("Hi Universe"));
        this.ksession.fireAllRules();
        Assert.assertTrue((boolean)this.done);
    }

    @Test
    public void testKJarUpgradeWithJavaClass() throws Exception {
        KieServices ks = KieServices.Factory.get();
        String kmodule = "<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\"/>\n  </kbase>\n</kmodule>";
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade-java", "1.0.0");
        Resource javaResource = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler.test;\npublic class PersonObject {\n    private String id;\n    public String getId() {\n        return id;\n    }\n    public void setId(String id) {\n        this.id = id;\n    }\n    public void updateId() {\n        this.id = \"Person from version 1\";\n    }\n}".getBytes()).setResourceType(ResourceType.JAVA).setSourcePath("org/drools/mvel/compiler/test/PersonObject.java");
        Resource drlResource = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler.test\nimport org.drools.mvel.compiler.test.PersonObject;\n\nrule \"Update person's id\"\nwhen\n    $person : PersonObject()\nthen\n    $person.updateId();\n    delete($person);\nend".getBytes()).setResourceType(ResourceType.DRL).setSourcePath("kbase1/person.drl");
        KieFileSystem kfs = KieUtil.getKieFileSystemWithKieModule((KieModuleModel)KieModuleModelImpl.fromXML((String)kmodule), (ReleaseId)releaseId1, (Resource[])new Resource[]{javaResource, drlResource});
        KieModule km = KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs);
        this.kieContainer = ks.newKieContainer(km.getReleaseId());
        this.ksession = this.kieContainer.newKieSession();
        Class<?> clazz = this.kieContainer.getClassLoader().loadClass("org.drools.mvel.compiler.test.PersonObject");
        Object person = clazz.newInstance();
        this.ksession.insert(person);
        this.ksession.fireAllRules();
        Assert.assertNotNull(person);
        Object personId = this.valueOf(person, "id");
        Assert.assertNotNull((Object)personId);
        Assert.assertEquals((Object)"Person from version 1", (Object)personId);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade-java", "1.1.0");
        Resource javaResource2 = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler.test;\npublic class PersonObject {\n    private String id;\n    public String getId() {\n        return id;\n    }\n    public void setId(String id) {\n        this.id = id;\n    }\n    public void updateId() {\n        this.id = \"Person from version 2\";\n    }\n}".getBytes()).setResourceType(ResourceType.JAVA).setSourcePath("org/drools/mvel/compiler/test/PersonObject.java");
        Resource drlResource2 = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler.test\nimport org.drools.mvel.compiler.test.PersonObject;\n\nrule \"Update person's id\"\nwhen\n    $person : PersonObject()\nthen\n    $person.updateId();\n    delete($person);\nend".getBytes()).setResourceType(ResourceType.DRL).setSourcePath("kbase1/person.drl");
        KieFileSystem kfs2 = KieUtil.getKieFileSystemWithKieModule((KieModuleModel)KieModuleModelImpl.fromXML((String)kmodule), (ReleaseId)releaseId2, (Resource[])new Resource[]{javaResource2, drlResource2});
        KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs2);
        this.kieContainer.updateToVersion(releaseId2);
        Assert.assertEquals((Object)releaseId2, (Object)this.kieContainer.getReleaseId());
        this.ksession = this.kieContainer.newKieSession();
        person = this.kieContainer.getClassLoader().loadClass("org.drools.mvel.compiler.test.PersonObject").newInstance();
        this.ksession.insert(person);
        this.ksession.fireAllRules();
        Assert.assertNotNull(person);
        personId = this.valueOf(person, "id");
        Assert.assertNotNull((Object)personId);
        Assert.assertEquals((Object)"Person from version 2", (Object)personId);
    }

    public void updateToVersion() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieModule km = KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.mvel.compiler\nrule R1 when\n   Message( $m : message )\nthen\n    System.out.println($m);\nend\n", this.drl2_2});
        this.kieContainer.updateToVersion(releaseId2);
        this.ksession.insert((Object)new Message("Hello World"));
    }

    public void done() {
        this.done = true;
    }

    protected Object valueOf(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception e) {
            return null;
        }
    }
}

