/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class PolymorphismTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public PolymorphismTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @Test
    public void testModifySubclassOverWindow() {
        String drl = "declare Number @role( event ) end\ndeclare Integer @role( event ) end\n\nrule R1 no-loop when\n    $i: Integer()\nthen\n    update($i);\nend\nrule R2 when\n    $n: Number() over window:length(1)\nthen\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)1);
        int fired = ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)fired);
    }

    @Test
    public void testModifySubclass() {
        String drl = "import " + A.class.getCanonicalName() + "\n;import " + B.class.getCanonicalName() + "\n;import " + C.class.getCanonicalName() + "\n;import " + X.class.getCanonicalName() + "\n;\nrule Ra when\n    $a: A(id == 3)\nthen\n    delete($a);\nend\nrule Rb when\n    $a: A(id == 2)\n    $b: B($id : id == 2)\nthen\n    modify($b) { setId($id+1) };\nend\nrule Rc when\n    $a: A(id == 1)\n    $c: C($id : id == 1)\nthen\n    modify($c) { setId($id+1) };\nend\nrule Rd when\n    $a: A(id == 0)\n    $d: X($id : id == 0)\nthen\n    modify($d) { setId($id+1) };\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new X(0));
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)ksession.getObjects().size());
    }

    @Test
    public void testModifySubclass2() {
        String drl = "import " + A.class.getCanonicalName() + "\n;import " + B.class.getCanonicalName() + "\n;import " + C.class.getCanonicalName() + "\n;import " + X.class.getCanonicalName() + "\n;\nrule Rd when\n    $a: X(id == 0)\n    $d: C($id : id == 0)\nthen\n    modify($d) { setId($id+1) };\nend\nrule Rc when\n    $a: X(id == 1)\n    $c: B($id : id == 1)\nthen\n    modify($c) { setId($id+1) };\nend\nrule Rb when\n    $a: X(id == 2)\n    $b: A($id : id == 2)\nthen\n    modify($b) { setId($id+1) };\nend\nrule Ra when\n    $a: X(id == 3)\nthen\n    delete($a);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kieBase.newKieSession();
        FactHandle fh = ksession.insert((Object)new X(0));
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)ksession.getObjects().size());
        System.out.println(fh);
    }

    public static class X
    extends C {
        public X(int id) {
            super(id);
        }
    }

    public static class C
    extends B {
        public C(int id) {
            super(id);
        }
    }

    public static class B
    extends A {
        public B(int id) {
            super(id);
        }
    }

    public static class A {
        private int id;

        public A(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

