/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.oopath;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;

public class RecursiveQueryBenchmark {
    private static final String RELATIONAL_DRL = "import " + Node.class.getCanonicalName() + ";\nimport " + Edge.class.getCanonicalName() + ";\nimport " + List.class.getCanonicalName() + ";\nquery findNodesWithValue( int $id, int $value, List list )\n  $n: Node( id == $id, $v : value )   eval( $v != $value || ( $v == $value && list.add( $n ) ) )\n  Edge( fromId == $id, $toId : toId )   findNodesWithValue( $toId, $value, list; )\nend\n";
    private static final String RELATIONAL_DRL_OLD = "import " + Node.class.getCanonicalName() + ";\nimport " + Edge.class.getCanonicalName() + ";\nquery findNodesWithValue( int $fromId, int $toId, int $value )\n  ( Edge( fromId == $fromId, toId == $toId ) and Node( id == $toId, value == $value ) )\n  or\n  ( Edge( fromId == $fromId, $childId : toId ) and findNodesWithValue( $childId, $toId, $value; ) )\nend\n\nrule R when\n  Node( root == true, $rootId : id )\n  accumulate( findNodeWithValue($rootId, $nodeId, 0;) ; $result : count($nodeId) )\nthen\n  System.out.println( $result );\nend\n";
    private static final String FROM_DRL = "import " + Node.class.getCanonicalName() + ";\nimport " + Edge.class.getCanonicalName() + ";\nimport " + List.class.getCanonicalName() + ";\nquery findNodesWithValue( Node $from, int $value, List list )\n  Edge( $n : to, $v : to.value ) from $from.outEdges\n  eval( $v != $value || ( $v == $value && list.add( $n ) ) )\n  findNodesWithValue( $n, $value, list; )\nend\n";
    private static final String FROM_DRL_OLD = "import " + Node.class.getCanonicalName() + ";\nimport " + Edge.class.getCanonicalName() + ";\nquery findNodesWithValue( Node $from, Node $to, int $value )\n  Edge( to.value == $value, $to := to ) from $from.outEdges\n  or\n  ( Edge( $child : to ) from $from.outEdges and findNodesWithValue( $child, $to, $value; ) )\nend\n\nrule R when\n  $root: Node( root == true )\n  accumulate( findNodeWithValue($root, $node, 0;) ; $result : count($node) )\nthen\n  System.out.println( $result );\nend\n";
    private static final String XPATH_DRL = "import " + Node.class.getCanonicalName() + ";\nimport " + Edge.class.getCanonicalName() + ";\nimport " + List.class.getCanonicalName() + ";\nquery findNodesWithValue( Node $from, int $value, List list )\n  Node( id == $from.id, $n: /outEdges/to )\n  eval( $n.getValue() != $value || ( $n.getValue() == $value && list.add( $n ) ) )\n  findNodesWithValue( $n, $value, list; )\nend\n";
    private static final String XPATH_DRL_OLD = "import " + Node.class.getCanonicalName() + ";\nimport " + Edge.class.getCanonicalName() + ";\nquery findNodesWithValue( Node $from, Node $to, int $value )\n  Node( this == $from, $to := /outEdges/to[value == $value] )\n  or\n  ( Node( this == $from, $child : /outEdges/to ) and findNodesWithValue( $child, $to, $value; ) )\nend\n\nrule R when\n  $root: Node( root == true )\n  accumulate( findNodeWithValue($root, $node, 0;) ; $result : count($node) )\nthen\n  System.out.println( $result );\nend\n";

    public static void main(String[] args) {
        int n = 1000;
        for (int i = 0; i < 5; ++i) {
            System.out.println("-------------------------------------");
            System.out.println("Running with " + n + " nodes");
            System.out.println("Relational version");
            RecursiveQueryBenchmark.runTest(new RelationalTest(), n);
            System.out.println("From version");
            RecursiveQueryBenchmark.runTest(new FromTest(), n);
            n *= 2;
            System.gc();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            System.gc();
        }
    }

    private static void runTest(Test test, int n) {
        KieBase kbase = RecursiveQueryBenchmark.getKieBase(test.getDrl());
        for (int i = 0; i < 3; ++i) {
            test.runTest(kbase, n);
            System.gc();
        }
        BenchmarkResult batch = new BenchmarkResult("Batch");
        for (int i = 0; i < 10; ++i) {
            long[] result = test.runTest(kbase, n);
            batch.accumulate(result[0]);
            System.gc();
        }
        System.out.println(batch);
    }

    private static KieBase getKieBase(String drl) {
        return new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]);
    }

    public static long[] execTest(KieBase kbase, int n, boolean isRelational) {
        KieSession ksession = kbase.newKieSession();
        Node root = RecursiveQueryBenchmark.generateTree(ksession, n, isRelational);
        ArrayList list = new ArrayList();
        long start = System.nanoTime();
        ksession.getQueryResults("findNodesWithValue", new Object[]{isRelational ? Integer.valueOf(root.getId()) : root, 0, list});
        ksession.fireAllRules();
        long[] result = new long[]{System.nanoTime() - start};
        ksession.dispose();
        return result;
    }

    private static Node generateTree(KieSession ksession, int n, boolean insertAll) {
        Random RANDOM = new Random(0L);
        Node root = new Node(1);
        root.setRoot(true);
        ksession.insert((Object)root);
        ArrayList<Node> nodes = new ArrayList<Node>(n);
        for (int i = 0; i < n; ++i) {
            Node node = new Node(i / 10);
            nodes.add(node);
        }
        ArrayList<Node> nodesInTree = new ArrayList<Node>(n);
        nodesInTree.add(root);
        while (!nodes.isEmpty()) {
            Node parent = (Node)nodesInTree.get(RANDOM.nextInt(nodesInTree.size()));
            Node node = (Node)nodes.remove(RANDOM.nextInt(nodes.size()));
            Edge edge = new Edge(parent, node);
            parent.addOutEdge(edge);
            nodesInTree.add(node);
            if (!insertAll) continue;
            ksession.insert((Object)edge);
            ksession.insert((Object)node);
        }
        return root;
    }

    public static class BenchmarkResult {
        private final String name;
        private long min = Long.MAX_VALUE;
        private long max = 0L;
        private long sum = 0L;
        private int counter = 0;

        public BenchmarkResult(String name) {
            this.name = name;
        }

        public void accumulate(long result) {
            if (result < this.min) {
                this.min = result;
            }
            if (result > this.max) {
                this.max = result;
            }
            this.sum += result;
            ++this.counter;
        }

        private long getAverage() {
            return (this.sum - this.min - this.max) / (long)(this.counter - 2);
        }

        public String toString() {
            return this.name + " results: min = " + this.min + "; max = " + this.max + "; avg = " + this.getAverage();
        }
    }

    public static class Edge {
        public final Node from;
        public final Node to;

        public Edge(Node from, Node to) {
            this.from = from;
            this.to = to;
        }

        public Node getFrom() {
            return this.from;
        }

        public int getFromId() {
            return this.from.getId();
        }

        public Node getTo() {
            return this.to;
        }

        public int getToId() {
            return this.to.getId();
        }

        public String toString() {
            return "Edge[" + this.getFromId() + ", " + this.getToId() + "]";
        }
    }

    public static class Node {
        private static int ID_GENERATOR = 0;
        private final int id = ID_GENERATOR++;
        private final List<Edge> outEdges = new ArrayList<Edge>();
        private final int value;
        private boolean root;

        public Node(int value) {
            this.value = value;
        }

        public List<Edge> getOutEdges() {
            return this.outEdges;
        }

        public void addOutEdge(Edge edge) {
            this.outEdges.add(edge);
        }

        public int getValue() {
            return this.value;
        }

        public int getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.id == node.id;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean isRoot() {
            return this.root;
        }

        public void setRoot(boolean root) {
            this.root = root;
        }

        public String toString() {
            return "Node: " + this.id;
        }
    }

    private static class FromTest
    implements Test {
        private FromTest() {
        }

        @Override
        public long[] runTest(KieBase kbase, int n) {
            return RecursiveQueryBenchmark.execTest(kbase, n, false);
        }

        @Override
        public String getDrl() {
            return FROM_DRL;
        }
    }

    private static class RelationalTest
    implements Test {
        private RelationalTest() {
        }

        @Override
        public long[] runTest(KieBase kbase, int n) {
            return RecursiveQueryBenchmark.execTest(kbase, n, true);
        }

        @Override
        public String getDrl() {
            return RELATIONAL_DRL;
        }
    }

    static interface Test {
        public long[] runTest(KieBase var1, int var2);

        public String getDrl();
    }
}

