/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class DroolsFromRHSTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DroolsFromRHSTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testHalt() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_halt.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)0);
        ksession.fireAllRules();
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)i, results.get(i));
        }
    }

    @Test
    public void testFireLimit() throws Exception {
        int i;
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_fireLimit.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)0);
        int count = ksession.fireAllRules();
        Assert.assertEquals((long)21L, (long)count);
        Assert.assertEquals((long)20L, (long)results.size());
        for (i = 0; i < 20; ++i) {
            Assert.assertEquals((Object)i, results.get(i));
        }
        results.clear();
        ksession.insert((Object)0);
        count = ksession.fireAllRules(10);
        Assert.assertEquals((long)10L, (long)count);
        Assert.assertEquals((long)10L, (long)results.size());
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)i, results.get(i));
        }
        count = ksession.fireAllRules();
        Assert.assertEquals((long)11L, (long)count);
        Assert.assertEquals((long)20L, (long)results.size());
        for (i = 0; i < 20; ++i) {
            Assert.assertEquals((Object)i, results.get(i));
        }
        results.clear();
        ksession.insert((Object)0);
        count = ksession.fireAllRules();
        Assert.assertEquals((long)21L, (long)count);
        Assert.assertEquals((long)20L, (long)results.size());
        for (i = 0; i < 20; ++i) {
            Assert.assertEquals((Object)i, results.get(i));
        }
        results.clear();
    }
}

