/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;

@RunWith(value=Parameterized.class)
public class NewLineAtEoFTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final String drl = "package org.jboss.qa.brms.commentend\nrule simple\n    when\n    then\n        System.out.println(\"Hello world!\");\nend\n";

    public NewLineAtEoFTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testNoNewlineAtTheEnd() {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.jboss.qa.brms.commentend\nrule simple\n    when\n    then\n        System.out.println(\"Hello world!\");\nend\n//test"});
        if (kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            Assert.fail((String)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).toString());
        }
    }

    @Test
    public void testNewlineAtTheEnd() {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assert.assertFalse((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }
}

