/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.rule.ConsequenceMetaData;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;

@RunWith(value=Parameterized.class)
public class RuleMetadataTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public RuleMetadataTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testModify() {
        String rule1 = "modify( $a ) { setA( 20 ), setB( $bb ) }";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assert.assertEquals((long)1L, (long)consequenceMetaData.getStatements().size());
        ConsequenceMetaData.Statement statment = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assert.assertEquals((Object)ConsequenceMetaData.Statement.Type.MODIFY, (Object)statment.getType());
        Assert.assertEquals((Object)"org.drools.A", (Object)statment.getFactClassName());
        Assert.assertEquals((long)2L, (long)statment.getFields().size());
        ConsequenceMetaData.Field field1 = (ConsequenceMetaData.Field)statment.getFields().get(0);
        Assert.assertEquals((Object)"a", (Object)field1.getName());
        Assert.assertEquals((Object)"20", (Object)field1.getValue());
        Assert.assertTrue((boolean)field1.isLiteral());
        ConsequenceMetaData.Field field2 = (ConsequenceMetaData.Field)statment.getFields().get(1);
        Assert.assertEquals((Object)"b", (Object)field2.getName());
        Assert.assertEquals((Object)"$bb", (Object)field2.getValue());
        Assert.assertFalse((boolean)field2.isLiteral());
    }

    @Test
    public void testModify2() {
        String rule1 = "modify( $a ) { setC( $bc ) };\n modify( $b ) { c = \"Hello\" };";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assert.assertEquals((long)2L, (long)consequenceMetaData.getStatements().size());
        ConsequenceMetaData.Statement statment1 = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assert.assertEquals((Object)ConsequenceMetaData.Statement.Type.MODIFY, (Object)statment1.getType());
        Assert.assertEquals((Object)"org.drools.A", (Object)statment1.getFactClassName());
        Assert.assertEquals((long)1L, (long)statment1.getFields().size());
        ConsequenceMetaData.Field field1 = (ConsequenceMetaData.Field)statment1.getFields().get(0);
        Assert.assertEquals((Object)"c", (Object)field1.getName());
        Assert.assertEquals((Object)"$bc", (Object)field1.getValue());
        Assert.assertFalse((boolean)field1.isLiteral());
        ConsequenceMetaData.Statement statment2 = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(1);
        Assert.assertEquals((Object)ConsequenceMetaData.Statement.Type.MODIFY, (Object)statment2.getType());
        Assert.assertEquals((Object)B.class.getName(), (Object)statment2.getFactClassName());
        Assert.assertEquals((long)1L, (long)statment2.getFields().size());
        ConsequenceMetaData.Field field2 = (ConsequenceMetaData.Field)statment2.getFields().get(0);
        Assert.assertEquals((Object)"c", (Object)field2.getName());
        Assert.assertEquals((Object)"\"Hello\"", (Object)field2.getValue());
        Assert.assertTrue((boolean)field2.isLiteral());
    }

    @Test
    public void testRetract() {
        String rule1 = "retract( $b );";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assert.assertEquals((long)1L, (long)consequenceMetaData.getStatements().size());
        ConsequenceMetaData.Statement statment = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assert.assertEquals((Object)ConsequenceMetaData.Statement.Type.RETRACT, (Object)statment.getType());
        Assert.assertEquals((Object)B.class.getName(), (Object)statment.getFactClassName());
    }

    @Test
    public void testRetractWithFunction() {
        String rule1 = "retract( getA($a) );";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assert.assertEquals((long)1L, (long)consequenceMetaData.getStatements().size());
        ConsequenceMetaData.Statement statment = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assert.assertEquals((Object)ConsequenceMetaData.Statement.Type.RETRACT, (Object)statment.getType());
        Assert.assertEquals((Object)"org.drools.A", (Object)statment.getFactClassName());
    }

    @Test
    public void testUpdate() {
        String rule1 = "$a.setA( 20 );\n $a.setB( $bb );\n update( $a );";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assert.assertEquals((long)1L, (long)consequenceMetaData.getStatements().size());
        ConsequenceMetaData.Statement statment = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assert.assertEquals((Object)ConsequenceMetaData.Statement.Type.MODIFY, (Object)statment.getType());
        Assert.assertEquals((Object)"org.drools.A", (Object)statment.getFactClassName());
        Assert.assertEquals((long)2L, (long)statment.getFields().size());
        ConsequenceMetaData.Field field1 = (ConsequenceMetaData.Field)statment.getFields().get(0);
        Assert.assertEquals((Object)"a", (Object)field1.getName());
        Assert.assertEquals((Object)"20", (Object)field1.getValue());
        Assert.assertTrue((boolean)field1.isLiteral());
        ConsequenceMetaData.Field field2 = (ConsequenceMetaData.Field)statment.getFields().get(1);
        Assert.assertEquals((Object)"b", (Object)field2.getName());
        Assert.assertEquals((Object)"$bb", (Object)field2.getValue());
        Assert.assertFalse((boolean)field2.isLiteral());
    }

    @Test
    public void testUpdate2() {
        String rule1 = "$a.setC( $bc );\n $b.c = \"Hello\";\n update( $a );\n update( $b );";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assert.assertEquals((long)2L, (long)consequenceMetaData.getStatements().size());
        ConsequenceMetaData.Statement statment1 = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assert.assertEquals((Object)ConsequenceMetaData.Statement.Type.MODIFY, (Object)statment1.getType());
        Assert.assertEquals((Object)"org.drools.A", (Object)statment1.getFactClassName());
        Assert.assertEquals((long)1L, (long)statment1.getFields().size());
        ConsequenceMetaData.Field field1 = (ConsequenceMetaData.Field)statment1.getFields().get(0);
        Assert.assertEquals((Object)"c", (Object)field1.getName());
        Assert.assertEquals((Object)"$bc", (Object)field1.getValue());
        Assert.assertFalse((boolean)field1.isLiteral());
        ConsequenceMetaData.Statement statment2 = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(1);
        Assert.assertEquals((Object)ConsequenceMetaData.Statement.Type.MODIFY, (Object)statment2.getType());
        Assert.assertEquals((Object)B.class.getName(), (Object)statment2.getFactClassName());
        Assert.assertEquals((long)1L, (long)statment2.getFields().size());
        ConsequenceMetaData.Field field2 = (ConsequenceMetaData.Field)statment2.getFields().get(0);
        Assert.assertEquals((Object)"c", (Object)field2.getName());
        Assert.assertEquals((Object)"\"Hello\"", (Object)field2.getValue());
        Assert.assertTrue((boolean)field2.isLiteral());
    }

    @Test
    public void testInsert() {
        String rule1 = "insert( new A(1, $bb, \"3\") );";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assert.assertEquals((long)1L, (long)consequenceMetaData.getStatements().size());
        ConsequenceMetaData.Statement statment = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assert.assertEquals((Object)ConsequenceMetaData.Statement.Type.INSERT, (Object)statment.getType());
        Assert.assertEquals((Object)"org.drools.A", (Object)statment.getFactClassName());
        Assert.assertEquals((long)3L, (long)statment.getFields().size());
        ConsequenceMetaData.Field field1 = (ConsequenceMetaData.Field)statment.getFields().get(0);
        Assert.assertEquals((Object)"a", (Object)field1.getName());
        Assert.assertEquals((Object)"1", (Object)field1.getValue());
        Assert.assertTrue((boolean)field1.isLiteral());
        ConsequenceMetaData.Field field2 = (ConsequenceMetaData.Field)statment.getFields().get(1);
        Assert.assertEquals((Object)"b", (Object)field2.getName());
        Assert.assertEquals((Object)"$bb", (Object)field2.getValue());
        Assert.assertFalse((boolean)field2.isLiteral());
        ConsequenceMetaData.Field field3 = (ConsequenceMetaData.Field)statment.getFields().get(2);
        Assert.assertEquals((Object)"c", (Object)field3.getName());
        Assert.assertEquals((Object)"\"3\"", (Object)field3.getValue());
        Assert.assertTrue((boolean)field3.isLiteral());
    }

    @Test
    public void testInsert2() {
        String rule1 = "insert( new B(1, $ab) );";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assert.assertEquals((long)1L, (long)consequenceMetaData.getStatements().size());
        ConsequenceMetaData.Statement statment = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assert.assertEquals((Object)ConsequenceMetaData.Statement.Type.INSERT, (Object)statment.getType());
        Assert.assertEquals((Object)B.class.getName(), (Object)statment.getFactClassName());
    }

    private KieBase getKnowledgeBase(String ... consequences) {
        String rule = "package org.drools\nimport " + B.class.getCanonicalName() + "\nglobal java.util.List list;\nfunction A getA(A a) {\n    return a;\n}declare A\n    a : int\n    b : int\n    c : String\nend\n";
        int i = 0;
        for (String str : consequences) {
            rule = rule + "rule R" + i++ + "\nwhen\n   $a : A( $aa : a, $ab : b, $ac : c )\n   $b : B( $ba : a, $bb : b, $bc : c )\nthen\n" + str + "\nend\n";
        }
        return KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
    }

    private RuleImpl getRule(KieBase kbase, String ruleName) {
        return ((KnowledgeBaseImpl)kbase).getPackage("org.drools").getRule(ruleName);
    }

    public static class B {
        public int a;
        public int b;
        public String c;

        public B() {
        }

        public B(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        public String getC() {
            return this.c;
        }

        public void setC(String c) {
            this.c = c;
        }
    }
}

