/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.NodeMemories;
import org.drools.core.common.TupleSets;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class MemoryLeakTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MemoryLeakTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testStagedTupleLeak() throws Exception {
        String str = "rule R1 when\n    $i : Integer()\nthen\n    insertLogical( $i.toString() );\nend\n\nrule R2 when\n    $i : Integer()\nthen\n    delete( $i );\nend\n\nrule R3 when\n    $l : Long()\n    $s : String( this == $l.toString() )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        for (int i = 0; i < 10; ++i) {
            ksession.insert((Object)i);
            ksession.fireAllRules();
        }
        Rete rete = ((KnowledgeBaseImpl)kbase).getRete();
        JoinNode joinNode = null;
        for (ObjectTypeNode otn : rete.getObjectTypeNodes()) {
            if (String.class != otn.getObjectType().getValueType().getClassType()) continue;
            joinNode = (JoinNode)otn.getObjectSinkPropagator().getSinks()[0];
            break;
        }
        Assert.assertNotNull(joinNode);
        InternalWorkingMemory wm = (InternalWorkingMemory)ksession;
        BetaMemory memory = (BetaMemory)wm.getNodeMemory(joinNode);
        TupleSets stagedRightTuples = memory.getStagedRightTuples();
        Assert.assertNull((Object)stagedRightTuples.getDeleteFirst());
        Assert.assertNull((Object)stagedRightTuples.getInsertFirst());
    }

    @Test
    public void testStagedLeftTupleLeak() throws Exception {
        String str = "rule R1 when\n    String( this == \"this\" )\n    String( this == \"that\" )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
        for (int i = 0; i < 10; ++i) {
            FactHandle fh = ksession.insert((Object)"this");
            ksession.fireAllRules();
            ksession.delete(fh);
            ksession.fireAllRules();
        }
        Rete rete = ((KnowledgeBaseImpl)kbase).getRete();
        LeftInputAdapterNode liaNode = null;
        for (ObjectTypeNode otn : rete.getObjectTypeNodes()) {
            if (String.class != otn.getObjectType().getValueType().getClassType()) continue;
            AlphaNode alphaNode = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
            liaNode = (LeftInputAdapterNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
            break;
        }
        Assert.assertNotNull(liaNode);
        InternalWorkingMemory wm = (InternalWorkingMemory)ksession;
        LeftInputAdapterNode.LiaNodeMemory memory = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory(liaNode);
        TupleSets stagedLeftTuples = memory.getSegmentMemory().getStagedLeftTuples();
        Assert.assertNull((Object)stagedLeftTuples.getDeleteFirst());
        Assert.assertNull((Object)stagedLeftTuples.getInsertFirst());
    }

    @Test
    public void testBetaMemoryLeakOnFactDelete() {
        String drl = "rule R1 when\n    $a : Integer(this == 1)\n    $b : String()\n    $c : Integer(this == 2)\nthen \nend\nrule R2 when\n    $a : Integer(this == 1)\n    $b : String()\n    $c : Integer(this == 3)\nthen \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        FactHandle fh1 = ksession.insert((Object)1);
        FactHandle fh2 = ksession.insert((Object)3);
        FactHandle fh3 = ksession.insert((Object)"test");
        ksession.fireAllRules();
        ksession.delete(fh1);
        ksession.delete(fh2);
        ksession.delete(fh3);
        ksession.fireAllRules();
        NodeMemories nodeMemories = ((InternalWorkingMemory)ksession).getNodeMemories();
        for (int i = 0; i < nodeMemories.length(); ++i) {
            Memory memory = nodeMemories.peekNodeMemory(i);
            if (memory == null || memory.getSegmentMemory() == null) continue;
            SegmentMemory segmentMemory = memory.getSegmentMemory();
            System.out.println(memory);
            LeftTuple deleteFirst = (LeftTuple)memory.getSegmentMemory().getStagedLeftTuples().getDeleteFirst();
            if (segmentMemory.getRootNode() instanceof JoinNode) {
                BetaMemory bm = (BetaMemory)segmentMemory.getNodeMemories().getFirst();
                Assert.assertEquals((long)0L, (long)bm.getLeftTupleMemory().size());
            }
            System.out.println(deleteFirst);
            Assert.assertNull((Object)deleteFirst);
        }
    }

    @Test(timeout=5000L)
    @Ignore(value="The checkReachability method is not totally reliable and can fall in an endless loop.We need to find a better way to check this.")
    public void testLeakAfterSessionDispose() {
        String drl = "import " + Person.class.getCanonicalName() + "\nrule R when\n    $p : Person()\nthen\nend\n";
        ReleaseId releaseId = KieUtil.generateReleaseId((String)"test");
        List resources = KieUtil.getResourcesFromDrls((String[])new String[]{drl});
        KieUtil.getKieModuleFromResources((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])resources.toArray(new Resource[0]));
        KieContainer kContainer = KieServices.Factory.get().newKieContainer(releaseId);
        KieBase kBase = KieBaseUtil.getDefaultKieBaseFromReleaseId((ReleaseId)releaseId);
        KieSession ksession = kBase.newKieSession();
        ksession.insert((Object)new Person("Mario", 40));
        ksession.fireAllRules();
        MemoryLeakTest.checkReachability(ksession, Person.class::isInstance, true);
        MemoryLeakTest.checkReachability(kBase, ksession::equals, true);
        MemoryLeakTest.checkReachability(kContainer, ksession::equals, true);
        ksession.dispose();
        MemoryLeakTest.checkReachability(kContainer, Person.class::isInstance, false);
        MemoryLeakTest.checkReachability(kBase, ksession::equals, false);
        MemoryLeakTest.checkReachability(kContainer, ksession::equals, false);
    }

    private static void checkReachability(Object root, Predicate<Object> condition, boolean reachable) {
        Collection<Object> results = MemoryLeakTest.checkObject(root, condition);
        Assert.assertTrue((boolean)(reachable ^ results.isEmpty()));
    }

    private static Collection<Object> checkObject(Object object, Predicate<Object> condition) {
        ArrayList<Object> results = new ArrayList<Object>();
        Set<Object> visited = Collections.newSetFromMap(new IdentityHashMap());
        List<Object> childObjects = MemoryLeakTest.checkObject(object, condition, results, visited);
        while (childObjects != null && !childObjects.isEmpty()) {
            childObjects = MemoryLeakTest.checkObjects(childObjects, condition, results, visited);
        }
        return results;
    }

    private static List<Object> checkObjects(List<Object> objects, Predicate<Object> condition, Collection<Object> results, Set<Object> visited) {
        ArrayList<Object> childObjects = new ArrayList<Object>();
        objects.forEach(object -> childObjects.addAll(MemoryLeakTest.checkObject(object, condition, results, visited)));
        return childObjects;
    }

    private static List<Object> checkObject(Object object, Predicate<Object> condition, Collection<Object> results, Set<Object> visited) {
        ArrayList<Object> childObjects = new ArrayList<Object>();
        if (object != null) {
            if (!visited.add(object)) {
                return childObjects;
            }
            if (condition.test(object)) {
                results.add(object);
            } else if (object instanceof Object[]) {
                for (Object child : (Object[])object) {
                    if (child == null) continue;
                    childObjects.addAll(MemoryLeakTest.getFieldsFromObject(child));
                }
            } else if (!object.getClass().isArray()) {
                childObjects.addAll(MemoryLeakTest.getFieldsFromObject(object));
            }
        }
        return childObjects;
    }

    private static List<Object> getFieldsFromObject(Object object) {
        ArrayList<Object> childObjects = new ArrayList<Object>();
        for (Class<?> c = object.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) continue;
                field.setAccessible(true);
                try {
                    childObjects.add(field.get(object));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return childObjects;
    }
}

