/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.lang.Expander;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.compiler.lang.dsl.DefaultExpander;
import org.drools.compiler.lang.dsl.DefaultExpanderResolver;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.internal.builder.conf.LanguageLevelOption;

@RunWith(value=Parameterized.class)
public class DrlParserTest {
    private static final String NL = System.getProperty("line.separator");
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DrlParserTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testExpandDRL() throws Exception {
        String dsl = "[condition]Something=Something()" + NL + "[then]another=another();";
        String drl = "rule 'foo' " + NL + " when " + NL + " Something " + NL + " then " + NL + " another " + NL + "end";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        String result = parser.getExpandedDRL(drl, (Reader)new StringReader(dsl));
        Assertions.assertThat((String)("rule 'foo' " + NL + " when " + NL + " Something() " + NL + " then " + NL + " another(); " + NL + "end")).isEqualToIgnoringWhitespace((CharSequence)result);
    }

    @Test
    public void testExpandDRLUsingInjectedExpander() throws Exception {
        String dsl = "[condition]Something=Something()" + NL + "[then]another=another();";
        String drl = "rule 'foo' " + NL + " when " + NL + " Something " + NL + " then " + NL + " another " + NL + "end";
        DefaultExpanderResolver resolver = new DefaultExpanderResolver((Reader)new StringReader(dsl));
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        if (!file.parseAndLoad((Reader)new StringReader(dsl))) {
            throw new RuntimeException("Error parsing and loading DSL file." + file.getErrors());
        }
        DefaultExpander expander = new DefaultExpander();
        expander.addDSLMapping(file.getMapping());
        resolver.addExpander("*", (Expander)expander);
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        String result = parser.getExpandedDRL(drl, resolver);
        Assertions.assertThat((String)("rule 'foo' " + NL + " when " + NL + " Something() " + NL + " then " + NL + " another(); " + NL + "end")).isEqualToIgnoringWhitespace((CharSequence)result);
    }

    @Test
    public void testDeclaredSuperType() throws Exception {
        String drl = "package foo \ndeclare Bean1 \nage: int \nname : String \nend \ndeclare Bean2 extends Bean1\ncheese : String \nend";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr pkgDescr = parser.parse(null, drl);
        TypeDeclarationDescr bean1Type = (TypeDeclarationDescr)pkgDescr.getTypeDeclarations().get(0);
        Assert.assertNull((Object)bean1Type.getSuperTypeName());
        TypeDeclarationDescr bean2Type = (TypeDeclarationDescr)pkgDescr.getTypeDeclarations().get(1);
        Assert.assertEquals((Object)"Bean1", (Object)bean2Type.getSuperTypeName());
    }

    @Test
    public void testBigDecimalWithZeroValue() throws Exception {
        String drl = "package foo \ndeclare Bean1 \nfield1: java.math.BigDecimal \nend \nrule \"bigdecimal\" \nwhen \nBean1( field1 == 0B ) \nthen \nend";
        this.createKBuilderAddDrlAndAssertHasNoErrors(drl);
    }

    @Test
    public void testBigDecimalWithZeroDecimalPointValue() throws Exception {
        String drl = "package foo \ndeclare Bean1 \nfield1: java.math.BigDecimal \nend \nrule \"bigdecimal\" \nwhen \nBean1( field1 == 0.0B ) \nthen \nend";
        this.createKBuilderAddDrlAndAssertHasNoErrors(drl);
    }

    @Test
    public void testBigDecimalWithNonZeroValue() throws Exception {
        String drl = "package foo \ndeclare Bean1 \nfield1: java.math.BigDecimal \nend \nrule \"bigdecimal\" \nwhen \nBean1( field1 == 1B ) \nthen \nend";
        this.createKBuilderAddDrlAndAssertHasNoErrors(drl);
    }

    @Test
    public void testBigDecimalWithNonZeroDecimalPointValue() throws Exception {
        String drl = "package foo \ndeclare Bean1 \nfield1: java.math.BigDecimal \nend \nrule \"bigdecimal\" \nwhen \nBean1( field1 == 1.0B ) \nthen \nend";
        this.createKBuilderAddDrlAndAssertHasNoErrors(drl);
    }

    @Test
    public void testBigIntegerWithZeroValue() throws Exception {
        String drl = "package foo \ndeclare Bean1 \nfield1: java.math.BigInteger \nend \nrule \"bigdecimal\" \nwhen \nBean1( field1 == 0I ) \nthen \nend";
        this.createKBuilderAddDrlAndAssertHasNoErrors(drl);
    }

    @Test
    public void testBigIntegerWithNonZeroValue() throws Exception {
        String drl = "package foo \ndeclare Bean1 \nfield1: java.math.BigInteger \nend \nrule \"bigdecimal\" \nwhen \nBean1( field1 == 1I ) \nthen \nend";
        this.createKBuilderAddDrlAndAssertHasNoErrors(drl);
    }

    @Test
    public void testParseConsequenceWithSingleQuoteInsideDoubleQuotesFollowedByUpdate() {
        String drl = "declare Person\n    name: String\nend\n\nrule \"test\"\nwhen\n    $p: Person()\nthen\n    $p.setName(\"Some name with' single quote inside\");\n    update($p);\nend";
        this.createKBuilderAddDrlAndAssertHasNoErrors(drl);
    }

    @Test
    public void testParseConsequenceWithEscapedDoubleQuoteInsideDoubleQuotesFollowedByUpdate() {
        String drl = "declare Person\n    name: String\nend\n\nrule \"test\"\nwhen\n    $p: Person()\nthen\n    $p.setName(\"Some name with\\\" escaped double quote inside double quotes\");\n    update($p);\nend";
        this.createKBuilderAddDrlAndAssertHasNoErrors(drl);
    }

    @Test
    public void testIfAfterPattern() {
        String str = "rule R when\n  $sum : Integer()\n  if ($sum > 70) do[greater]\nthen\nthen[greater]\nend";
        this.createKBuilderAddDrlAndAssertHasNoErrors(str);
    }

    @Test
    public void testIfAfterAccumulate() {
        String str = "rule R when\n  accumulate ( $p: Object(); \n                $sum : sum(1)  \n              )                          \n  if ($sum > 70) do[greater]\nthen\nthen[greater]\nend";
        this.createKBuilderAddDrlAndAssertHasNoErrors(str);
    }

    private void createKBuilderAddDrlAndAssertHasNoErrors(String drl) {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertEquals((String)("Expected no build errors, but got: " + errors.toString()), (long)0L, (long)errors.size());
    }
}

