/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class ExistentialOperatorTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ExistentialOperatorTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testForallAfterOr() throws Exception {
        String str = "package redhat\ndeclare Fact\n    integer : int\n    string1 : String\n    string2 : String\nend\nrule \"Rule\"\nwhen\nFact(string2 == \"Y\")\n(\n    exists (Fact(integer == 42)) or\n    Fact(integer == 43)\n)\nforall (Fact(string1 == \"X\"))\nthen\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession kieSession = kieBase.newKieSession();
        FactType factType = kieBase.getFactType("redhat", "Fact");
        Object fact = factType.newInstance();
        factType.set(fact, "string1", (Object)"X");
        factType.set(fact, "string2", (Object)"Y");
        factType.set(fact, "integer", (Object)42);
        kieSession.insert(fact);
        int n = kieSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)n);
    }
}

