/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Message;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class AndTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AndTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAnd() {
        String drl = "package HelloWorld\n \nimport " + Message.class.getCanonicalName() + ";\nimport " + Cheese.class.getCanonicalName() + " ;\n\nglobal java.util.List list;\n\nrule \"Hello World\"\n    when\n        Message() and Cheese()\n    then\n        list.add(\"hola\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"and-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new Message("hola"));
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            ksession.insert((Object)new Cheese("brie", 33));
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)((List)ksession.getGlobal("list")).size());
        }
        finally {
            ksession.dispose();
        }
    }
}

