/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Cheesery;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Pet;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class MemberOfTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MemberOfTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemberOfAndNotMemberOf() {
        String drl = "package org.drools.compiler.test;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Cheesery.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Stilton is memberOf Cheesery\"\n    salience 10\n    when\n        Cheesery( $cheeses : cheeses )\n        cheese : Cheese( type memberOf $cheeses )\n    then\n        list.add( cheese );\nend   \n\nrule \"Muzzarela is not memberOf Cheesery\"\n    when\n        Cheesery( $cheeses : cheeses )\n        cheese : Cheese( type not memberOf $cheeses )\n    then\n        list.add( cheese );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"member-of-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Cheese stilton = new Cheese("stilton", 12);
            Cheese muzzarela = new Cheese("muzzarela", 10);
            Cheese brie = new Cheese("brie", 15);
            ksession.insert((Object)stilton);
            ksession.insert((Object)muzzarela);
            Cheesery cheesery = new Cheesery();
            cheesery.getCheeses().add(stilton);
            cheesery.getCheeses().add(brie);
            ksession.insert((Object)cheesery);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)stilton, list.get(0));
            Assert.assertEquals((Object)muzzarela, list.get(1));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemberOfWithOr() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport java.util.ArrayList;\nimport " + Person.class.getCanonicalName() + ";\nrule \"Test Rule\"\nwhen\n    $list: ArrayList()                                   \n    ArrayList()                                          \n            from collect(                                \n                  Person(                                \n                      (                                  \n                          pet memberOf $list             \n                      ) || (                             \n                          pet == null                    \n                      )                                  \n                  )                                      \n            )\nthen\n  System.out.println(\"hello person\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"member-of-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            Person toni = new Person("Toni", 12);
            toni.setPet(new Pet(Pet.PetType.CAT));
            session.insert(new ArrayList());
            session.insert((Object)toni);
            session.fireAllRules();
        }
        finally {
            session.dispose();
        }
    }
}

