/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.mvel.compiler.StockTick;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class PseudoClockEventsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final String evalFirePseudoClockDeclaration = "package org.drools.mvel.integrationtests\nimport " + StockTick.class.getCanonicalName() + "\n\ndeclare StockTick\n    @role( event )\nend\n\n";
    private static final String evalFirePseudoClockRuleA = "rule A\nwhen\n\t$a: StockTick( $priceA: price )\n\t$b: StockTick( $priceA < price )\nthen \n    System.out.println(\"Rule A fired by thread \" + Thread.currentThread().getName() + \": \" + $a + \", \" + $b);\nend\n";
    private static final String evalFirePseudoClockRuleB = "rule B\nwhen\n\t$a: StockTick()\n\tnot( StockTick( this after[1,10s] $a ) )\nthen \n    System.out.println(\"Rule B fired by thread \" + Thread.currentThread().getName());\nend\n";
    int evalFirePseudoClockStockCount = 5;

    public PseudoClockEventsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @Test(timeout=10000L)
    public void testEvenFirePseudoClockRuleA() throws Exception {
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        this.processStocks(this.evalFirePseudoClockStockCount, ael, evalFirePseudoClockDeclaration + evalFirePseudoClockRuleA);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)(this.evalFirePseudoClockStockCount * (this.evalFirePseudoClockStockCount - 1) / 2)))).afterMatchFired((AfterMatchFiredEvent)ArgumentMatchers.any(AfterMatchFiredEvent.class));
    }

    @Test(timeout=10000L)
    public void testEvenFirePseudoClockRuleB() throws Exception {
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        this.processStocks(this.evalFirePseudoClockStockCount, ael, evalFirePseudoClockDeclaration + evalFirePseudoClockRuleB);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)(this.evalFirePseudoClockStockCount - 1)))).afterMatchFired((AfterMatchFiredEvent)ArgumentMatchers.any(AfterMatchFiredEvent.class));
    }

    @Test(timeout=60000L)
    public void testEvenFirePseudoClockRulesAB() throws Exception {
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        this.processStocks(this.evalFirePseudoClockStockCount, ael, evalFirePseudoClockDeclaration + evalFirePseudoClockRuleA + evalFirePseudoClockRuleB);
        int expectedActivationCount = this.evalFirePseudoClockStockCount * (this.evalFirePseudoClockStockCount - 1) / 2 + this.evalFirePseudoClockStockCount - 1;
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)expectedActivationCount))).afterMatchFired((AfterMatchFiredEvent)ArgumentMatchers.any(AfterMatchFiredEvent.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processStocks(int stockCount, AgendaEventListener agendaEventListener, String drlContentString) throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drlContentString});
        KieSessionConfiguration ksessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksessionConfig.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        ksessionConfig.setProperty("keep.reference", "true");
        KieSession ksession = kbase.newKieSession(ksessionConfig, null);
        ksession.addEventListener(agendaEventListener);
        PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
        Thread fireUntilHaltThread = new Thread(() -> ((KieSession)ksession).fireUntilHalt(), "Engine's thread");
        fireUntilHaltThread.start();
        try {
            Thread.currentThread().setName("Feeding thread");
            for (int stIndex = 1; stIndex <= stockCount; ++stIndex) {
                clock.advanceTime(20L, TimeUnit.SECONDS);
                Thread.sleep(100L);
                StockTick st = new StockTick(stIndex, "RHT", 100 * stIndex, 100 * stIndex);
                ksession.insert((Object)st);
                Thread.sleep(100L);
            }
            Thread.sleep(100L);
        }
        finally {
            ksession.halt();
            ksession.dispose();
        }
        fireUntilHaltThread.join(5000L);
        return stockCount;
    }
}

