/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.eventgenerator.example;

import java.util.HashMap;
import java.util.Map;
import org.drools.mvel.integrationtests.eventgenerator.Event;

public class StatusChangedEvent
extends Event {
    public static final String[] PROPERTY_FIELD_NAMES = new String[]{"OldValue", "NewValue"};
    public static final int OLD_VALUE = 0;
    public static final int NEW_VALUE = 1;

    public StatusChangedEvent(String parentId, int oldValue, int newValue) {
        super(Event.EventType.STATUSCHANGED, parentId);
        this.addParameters(StatusChangedEvent.createStatusChangedParameters(oldValue, newValue));
    }

    public StatusChangedEvent(String parentId, long start, long end) {
        super(Event.EventType.STATUSCHANGED, parentId, start, end);
    }

    public StatusChangedEvent(String parentId, int oldValue, int newValue, long start, long end) {
        super(Event.EventType.STATUSCHANGED, parentId, start, end);
        this.addParameters(StatusChangedEvent.createStatusChangedParameters(oldValue, newValue));
    }

    private static Map<String, String> createStatusChangedParameters(int oldValue, int newValue) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PROPERTY_FIELD_NAMES[0], String.valueOf(oldValue));
        params.put(PROPERTY_FIELD_NAMES[1], String.valueOf(newValue));
        return params;
    }

    public String getParamOldValue() {
        if (this.getParameters().containsKey(PROPERTY_FIELD_NAMES[0])) {
            return this.getParamValue(PROPERTY_FIELD_NAMES[0]);
        }
        return null;
    }

    public String getParamNewValue() {
        if (this.getParameters().containsKey(PROPERTY_FIELD_NAMES[1])) {
            return this.getParamValue(PROPERTY_FIELD_NAMES[1]);
        }
        return null;
    }
}

