/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.time.Calendar;

@RunWith(value=Parameterized.class)
public class CalendarTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final Calendar WEEKEND = timestamp -> {
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.setTimeInMillis(timestamp);
        int day = c.get(7);
        return day == 7 || day == 1;
    };
    private static final Calendar WEEKDAY = timestamp -> {
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.setTimeInMillis(timestamp);
        int day = c.get(7);
        return day != 7 && day != 1;
    };

    public CalendarTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        String drl = "package org.drools.compiler.integrationtests;\n\nglobal java.util.List list\n \nrule \"weekend\"\n    calendars \"weekend\"\n    \n    when\n    then\n        list.add(\"weekend\");\nend\n \nrule \"weekday\"\n    calendars \"weekday\"\n\n    when\n    then\n       list.add(\"weekday\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests;\n\nglobal java.util.List list\n \nrule \"weekend\"\n    calendars \"weekend\"\n    \n    when\n    then\n        list.add(\"weekend\");\nend\n \nrule \"weekday\"\n    calendars \"weekday\"\n\n    when\n    then\n       list.add(\"weekday\");\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.getCalendars().set("weekend", WEEKEND);
            ksession.getCalendars().set("weekday", WEEKDAY);
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            ksession.dispose();
            Assert.assertEquals((long)1L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }
}

