/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.ancompiler.CompiledNetwork;
import org.drools.core.common.BetaConstraints;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Pet;
import org.drools.testcoverage.common.model.Primitives;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieModule;
import org.kie.api.conf.BetaRangeIndexOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class JoinNodeRangeIndexingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public JoinNodeRangeIndexingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    private KieBase getKieBaseWithRangeIndexOption(String drl) {
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        return KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{BetaRangeIndexOption.ENABLED});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRangeIndexForJoin() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nimport " + Pet.class.getCanonicalName() + ";\nrule R1\nwhen\n   $pet : Pet()\n   Person( age > $pet.age )\nthen\nend\n";
        KieBase kbase = this.getKieBaseWithRangeIndexOption(drl);
        this.assertIndexedTrue(kbase, Person.class);
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Pet(Pet.PetType.CAT, 10));
            ksession.insert((Object)new Person("Paul", 20));
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    private void assertIndexedTrue(KieBase kbase, Class<?> factClass) {
        this.assertIndexed(kbase, factClass, true);
    }

    private void assertIndexedFalse(KieBase kbase, Class<?> factClass) {
        this.assertIndexed(kbase, factClass, false);
    }

    private void assertIndexed(KieBase kbase, Class<?> factClass, boolean isIndexed) {
        ObjectSink[] sinks;
        ObjectTypeNode otn = KieUtil.getObjectTypeNode((KieBase)kbase, factClass);
        Assertions.assertThat((Object)otn).isNotNull();
        ObjectSinkPropagator objectSinkPropagator = otn.getObjectSinkPropagator();
        if (this.kieBaseTestConfiguration.useAlphaNetworkCompiler()) {
            objectSinkPropagator = ((CompiledNetwork)objectSinkPropagator).getOriginalSinkPropagator();
        }
        boolean isPassedForJoinNode = false;
        for (ObjectSink sink : sinks = objectSinkPropagator.getSinks()) {
            if (!(sink instanceof JoinNode)) continue;
            JoinNode join = (JoinNode)sink;
            BetaConstraints betaConstraints = join.getRawConstraints();
            Assert.assertEquals((Object)isIndexed, (Object)betaConstraints.isIndexed());
            isPassedForJoinNode = true;
        }
        Assert.assertTrue((boolean)isPassedForJoinNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoercionBigDecimalVsInt() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Primitives.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R\n    when\n        Cheese($price : price)\n        p : Primitives(bigDecimal < $price)\n    then\n        list.add( p );\nend";
        KieBase kbase = this.getKieBaseWithRangeIndexOption(drl);
        this.assertIndexedTrue(kbase, Primitives.class);
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Primitives bd42 = new Primitives();
            bd42.setBigDecimal(new BigDecimal("42"));
            ksession.insert((Object)bd42);
            Primitives bd43 = new Primitives();
            bd43.setBigDecimal(new BigDecimal("43"));
            ksession.insert((Object)bd43);
            ksession.insert((Object)new Cheese("gorgonzola", 43));
            ksession.fireAllRules();
            Assertions.assertThat(list).containsExactly((Object[])new Primitives[]{bd42});
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoercionIntVsBigDecimal() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Person.class.getCanonicalName() + ";\nimport " + Primitives.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R\n\n    when\n        Person($salary : salary)\n        p : Primitives(intPrimitive < $salary)\n    then\n        list.add( p );\nend";
        KieBase kbase = this.getKieBaseWithRangeIndexOption(drl);
        this.assertIndexedTrue(kbase, Primitives.class);
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Primitives i42 = new Primitives();
            i42.setIntPrimitive(42);
            ksession.insert((Object)i42);
            Primitives i43 = new Primitives();
            i43.setIntPrimitive(43);
            ksession.insert((Object)i43);
            Person john = new Person("John");
            john.setSalary(new BigDecimal("43.0"));
            ksession.insert((Object)john);
            ksession.fireAllRules();
            Assertions.assertThat(list).containsExactly((Object[])new Primitives[]{i42});
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoercionStringVsIntWithMap() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Map.class.getCanonicalName() + ";\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R\n    when\n        $map : Map()        p : Cheese(type < $map.get(\"key\"))\n    then\n        list.add( p );\nend";
        KieBase kbase = this.getKieBaseWithRangeIndexOption(drl);
        this.assertIndexedFalse(kbase, Cheese.class);
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Cheese cheese1 = new Cheese("1");
            ksession.insert((Object)cheese1);
            Cheese cheese5 = new Cheese("5");
            ksession.insert((Object)cheese5);
            Cheese cheese10 = new Cheese("10");
            ksession.insert((Object)cheese10);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("key", 5);
            ksession.insert(map);
            ksession.fireAllRules();
            Assertions.assertThat(list).containsExactly((Object[])new Cheese[]{cheese1});
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoercionIntVsStringWithMap() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + MapHolder.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R\n    when\n        Cheese($type : type)        p : MapHolder(map.get(\"key\") < $type)\n    then\n        list.add( p );\nend";
        KieBase kbase = this.getKieBaseWithRangeIndexOption(drl);
        this.assertIndexedFalse(kbase, MapHolder.class);
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            MapHolder holder1 = new MapHolder();
            holder1.getMap().put("key", 1);
            ksession.insert((Object)holder1);
            MapHolder holder5 = new MapHolder();
            holder5.getMap().put("key", 5);
            ksession.insert((Object)holder5);
            MapHolder holder10 = new MapHolder();
            holder10.getMap().put("key", 10);
            ksession.insert((Object)holder10);
            Cheese cheese = new Cheese("5");
            ksession.insert((Object)cheese);
            ksession.fireAllRules();
            Assertions.assertThat(list).containsExactly((Object[])new MapHolder[]{holder1});
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithGlobal() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nglobal Integer minAge;\nrule R1\nwhen\n   Person( age > minAge )\nthen\nend\n";
        KieBase kbase = this.getKieBaseWithRangeIndexOption(drl);
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.setGlobal("minAge", (Object)15);
            ksession.insert((Object)new Person("Paul", 20));
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertUpdateDelete() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nimport " + Pet.class.getCanonicalName() + ";\nglobal java.util.Set result;\nrule R1\nwhen\n   $pet : Pet()\n   $person : Person( age > $pet.age )\nthen\n   result.add( $person.getName() + \" > \" + $pet.getName() );\nend\nrule R2\n   salience 100\nwhen\n   String (this == \"trigger R2\")\n   $person : Person( name == \"Paul\" )\nthen\n   modify($person) {setAge(20)}\nend\nrule R3\n   salience 100\nwhen\n   String (this == \"trigger R3\")\n   $pet : Pet( )\nthen\n   modify($pet) {setAge($pet.getAge() - 5)}\nend\nrule R4\n   salience 100\nwhen\n   String (this == \"trigger R4\")\n   $pet : Pet( name == \"Oliver\" )\nthen\n   delete($pet);\nend\n";
        KieBase kbase = this.getKieBaseWithRangeIndexOption(drl);
        this.assertIndexedTrue(kbase, Person.class);
        KieSession ksession = kbase.newKieSession();
        try {
            HashSet result = new HashSet();
            ksession.setGlobal("result", result);
            ksession.insert((Object)new Pet("Oliver", 5));
            ksession.insert((Object)new Pet("Leo", 10));
            ksession.insert((Object)new Pet("Milo", 20));
            ksession.insert((Object)new Person("John", 10));
            ksession.insert((Object)new Person("Paul", 10));
            Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
            Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"John > Oliver", "Paul > Oliver"});
            ksession.insert((Object)"trigger R2");
            Assert.assertEquals((long)3L, (long)ksession.fireAllRules());
            Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"John > Oliver", "Paul > Oliver", "Paul > Leo"});
            ksession.insert((Object)"trigger R3");
            Assert.assertEquals((long)8L, (long)ksession.fireAllRules());
            Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"John > Oliver", "John > Leo", "Paul > Oliver", "Paul > Leo", "Paul > Milo"});
            ksession.insert((Object)"trigger R4");
            ksession.insert((Object)new Person("George", 15));
            Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
            Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"John > Oliver", "John > Leo", "Paul > Oliver", "Paul > Leo", "Paul > Milo", "George > Leo"});
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBoxed() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nimport " + IntegerHolder.class.getCanonicalName() + ";\nrule R1\nwhen\n   $holder : IntegerHolder()\n   Person( age > $holder.value )\nthen\nend\n";
        KieBase kbase = this.getKieBaseWithRangeIndexOption(drl);
        this.assertIndexedTrue(kbase, Person.class);
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new IntegerHolder(10));
            ksession.insert((Object)new Person("Paul", 20));
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBoxed2() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nimport " + IntegerHolder.class.getCanonicalName() + ";\nrule R1\nwhen\n   $p : Person( )\n   IntegerHolder(value > $p.age)\nthen\nend\n";
        KieBase kbase = this.getKieBaseWithRangeIndexOption(drl);
        this.assertIndexedTrue(kbase, IntegerHolder.class);
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new IntegerHolder(30));
            ksession.insert((Object)new Person("Paul", 20));
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleFacts() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nimport " + Pet.class.getCanonicalName() + ";\nglobal java.util.Set result;\nrule R1\nwhen\n   $pet : Pet()\n   $person : Person( age > $pet.age )\nthen\n   result.add( $person.getName() + \" > \" + $pet.getName() );\nend\n";
        KieBase kbase = this.getKieBaseWithRangeIndexOption(drl);
        this.assertIndexedTrue(kbase, Person.class);
        KieSession ksession = kbase.newKieSession();
        HashSet result = new HashSet();
        ksession.setGlobal("result", result);
        try {
            ksession.insert((Object)new Pet("Charlie", 5));
            ksession.insert((Object)new Pet("Max", 10));
            ksession.insert((Object)new Pet("Buddy", 15));
            ksession.insert((Object)new Pet("Oscar", 20));
            ksession.insert((Object)new Person("John", 2));
            ksession.insert((Object)new Person("Paul", 10));
            ksession.insert((Object)new Person("George", 20));
            ksession.insert((Object)new Person("Ringo", 30));
            Assert.assertEquals((long)8L, (long)ksession.fireAllRules());
            Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"Paul > Charlie", "George > Charlie", "George > Max", "George > Buddy", "Ringo > Charlie", "Ringo > Max", "Ringo > Buddy", "Ringo > Oscar"});
        }
        finally {
            ksession.dispose();
        }
    }

    public static class IntegerHolder {
        private Integer value;

        public IntegerHolder(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }
    }

    public static class MapHolder {
        private Map<String, Object> map = new HashMap<String, Object>();

        public Map<String, Object> getMap() {
            return this.map;
        }

        public void setMap(Map<String, Object> map) {
            this.map = map;
        }
    }
}

